#
# TABLE STRUCTURE FOR: QR_code_settings
#

DROP TABLE IF EXISTS `QR_code_settings`;

CREATE TABLE `QR_code_settings` (
  `id` int NOT NULL,
  `camera_type` varchar(15) DEFAULT NULL,
  `auto_attendance` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

INSERT INTO `QR_code_settings` (`id`, `camera_type`, `auto_attendance`, `created_at`) VALUES (1, 'environment', 1, '2024-09-30 09:50:28');


#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `case_reference_id` int DEFAULT NULL,
  `vehicle_id` int DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `standard_charge` int DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `discount` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int DEFAULT NULL,
  `note` text,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `charge_id` (`charge_id`),
  KEY `idx_contact_no` (`contact_no`),
  KEY `idx_vehicle_model` (`vehicle_model`),
  KEY `idx_driver` (`driver`),
  KEY `index_date` (`date`),
  KEY `index_call_from` (`call_from`),
  KEY `index_call_to` (`call_to`),
  KEY `index_charge_category_id` (`charge_category_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ambulance_call_ibfk_6` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `discount_percentage`, `discount`, `tax_percentage`, `amount`, `net_amount`, `transaction_id`, `note`, `generated_by`, `created_at`) VALUES (6, 5, NULL, 3, NULL, NULL, NULL, 'ajay', '2024-10-04 16:37:00', '', '', NULL, 4, 150, '0.00', '0.00', '18.00', '150.00', '177.00', 57, '', 7, '2024-10-04 11:08:09');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `discount_percentage`, `discount`, `tax_percentage`, `amount`, `net_amount`, `transaction_id`, `note`, `generated_by`, `created_at`) VALUES (7, 7, NULL, 3, NULL, NULL, NULL, 'ajay', '2024-10-10 04:51:00', '', '', NULL, 4, 150, '0.00', '0.00', '18.00', '150.00', '177.00', 92, '', 1, '2024-10-10 11:51:22');


#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int NOT NULL AUTO_INCREMENT,
  `holiday_type` int NOT NULL COMMENT '1 for holiday , 2 for activity , 3 for vacation',
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL COMMENT 'Holiday Description',
  `is_active` int NOT NULL DEFAULT '1' COMMENT '1 for active 0 for inactive',
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_holiday_type` (`holiday_type`),
  KEY `idx_created_by` (`created_by`),
  KEY `index_from_date` (`from_date`) USING BTREE,
  KEY `index_to_date` (`to_date`) USING BTREE,
  CONSTRAINT `annual_calendar_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (1, 1, '2024-09-18 00:00:00', '2024-09-18 23:59:00', 'Ganesh Chaturthi (guh-NESH cha-TUR-thee) is a festival that pays homage to Lord Ganesh, the remover of obstacles, and celebrates the day of his birth.', 1, '#008000', 1, 1, '2024-09-27 15:19:09', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (2, 2, '2024-09-27 00:00:00', '2024-09-27 23:59:00', 'Hospital Activities means any activities that received direct or indirect financial support from the Hospital, including Hospital salary support or funding from any outside source awarded to or administered by the Hospital; made substantial use of any space, facilities, materials or other resources of the Hospital', 1, '#008000', 1, 2, '2024-09-28 12:31:25', '2024-09-28');
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (3, 3, '2024-09-23 00:00:00', '2024-09-27 23:59:00', 'Hospital Activities means any activities that received direct or indirect financial support from the Hospital', 1, '#008000', 1, 2, '2024-09-28 18:01:20', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (4, 1, '2024-10-02 00:00:00', '2024-10-02 23:59:00', 'gandhi jyanti is a hodiday', 1, '#008000', 0, 1, '2024-09-30 12:16:04', '2024-09-30');
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (5, 1, '2024-10-12 00:00:00', '2024-10-12 23:59:00', 'Dasherra in navratri', 1, '#008000', 1, 1, '2024-10-11 16:20:28', NULL);


#
# TABLE STRUCTURE FOR: antenatal_examine
#

DROP TABLE IF EXISTS `antenatal_examine`;

CREATE TABLE `antenatal_examine` (
  `id` int NOT NULL AUTO_INCREMENT,
  `primary_examine_id` int NOT NULL,
  `visit_details_id` int DEFAULT NULL,
  `ipdid` int DEFAULT NULL,
  `uter_size` varchar(250) DEFAULT NULL,
  `uterus_size` varchar(250) DEFAULT NULL,
  `presentation_position` varchar(250) DEFAULT NULL,
  `brim_presentation` varchar(250) DEFAULT NULL,
  `foeta_heart` varchar(250) DEFAULT NULL,
  `blood_pressure` varchar(250) DEFAULT NULL,
  `antenatal_oedema` varchar(250) DEFAULT NULL,
  `antenatal_weight` varchar(250) DEFAULT NULL,
  `urine_sugar` varchar(250) DEFAULT NULL,
  `urine` varchar(250) DEFAULT NULL,
  `remark` text,
  `next_visit` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_uter_size` (`uter_size`),
  KEY `index_uterus_size` (`uterus_size`),
  KEY `index_presentation_position` (`presentation_position`),
  KEY `index_brim_presentation` (`brim_presentation`),
  KEY `index_foeta_heart` (`foeta_heart`),
  KEY `index_blood_pressure` (`blood_pressure`),
  KEY `index_antenatal_oedema` (`antenatal_oedema`),
  KEY `index_antenatal_weight` (`antenatal_weight`),
  KEY `index_urine_sugar` (`urine_sugar`),
  KEY `index_urine` (`urine`),
  KEY `primary_examine_id` (`primary_examine_id`),
  CONSTRAINT `antenatal_examine_ibfk_1` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_2` FOREIGN KEY (`ipdid`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_3` FOREIGN KEY (`primary_examine_id`) REFERENCES `primary_examine` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `antenatal_examine` (`id`, `primary_examine_id`, `visit_details_id`, `ipdid`, `uter_size`, `uterus_size`, `presentation_position`, `brim_presentation`, `foeta_heart`, `blood_pressure`, `antenatal_oedema`, `antenatal_weight`, `urine_sugar`, `urine`, `remark`, `next_visit`, `created_at`) VALUES (5, 5, NULL, 2, 'k', 'kk', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k', 'k  ', 'kk  ', '2024-09-30 07:06:20');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_appoint_priority` (`appoint_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 13:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `doctor_shift_time_id` int DEFAULT NULL,
  `doctor_global_shift_id` int DEFAULT NULL,
  `is_queue` int DEFAULT NULL,
  `created_time` datetime DEFAULT NULL,
  `rejected_time` datetime DEFAULT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `live_consult_link` int NOT NULL DEFAULT '1' COMMENT '1 (link created) 0 (not created)',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `doctor_shift_time_id` (`doctor_shift_time_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_4` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_5` FOREIGN KEY (`doctor_shift_time_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (4, 3, 10, 10, '2024-10-08 17:31:00', '1', '4', 2, '', '', 'approved', 'Online', '', '', 2, 1, 0, '2024-09-28 15:32:15', '2024-09-28 15:42:15', 'no', 0, '2024-09-28 10:02:15');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (24, 6, 25, 24, '2024-10-08 17:31:00', '2', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-10-07 12:01:39');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (25, 7, 30, 28, '2024-10-09 12:59:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2024-10-09 07:29:57');
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`) VALUES (26, 7, 31, 29, '2024-10-10 13:52:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 3, 1, 0, NULL, NULL, 'no', 1, '2024-10-09 08:23:12');


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appointment_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `standard_amount` float(10,2) NOT NULL DEFAULT '0.00',
  `tax` float(10,2) NOT NULL DEFAULT '0.00',
  `discount_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `index_standard_amount` (`standard_amount`),
  KEY `index_tax` (`tax`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_paid_amount` (`paid_amount`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_payment_type` (`payment_type`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3;

INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (4, 4, 1, '236.00', '0.00', '2.00', '231.28', 'Paystack', 'Online', '172751793502', 'Payment deposit through Paystack TXN ID: 172751793502', '2024-09-28 15:35:47', '2024-09-28 10:05:47');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (18, 24, 1, '236.00', '0.00', '2.00', '231.28', NULL, 'Offline', NULL, NULL, '2024-10-07 17:31:39', '2024-10-07 12:01:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (19, 25, 1, '236.00', '0.00', '3.00', '228.92', NULL, 'Offline', NULL, NULL, '2024-10-09 12:59:57', '2024-10-09 07:29:57');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (20, 26, 1, '236.00', '0.00', '4.00', '226.56', NULL, 'Offline', NULL, NULL, '2024-10-09 13:53:12', '2024-10-09 08:23:12');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appointment_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `position` int DEFAULT NULL,
  `shift_id` int DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int DEFAULT NULL,
  `bed_group_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_3` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, 'general bed', 1, 1, 'no', '2024-09-26 12:01:09');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, 'Private bed', 2, 2, 'no', '2024-09-28 08:07:01');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, 'ICU Bed ', 2, 1, 'no', '2024-09-28 08:07:32');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, 'VVIP bed', 2, 2, 'no', '2024-10-07 10:54:41');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `floor` int NOT NULL,
  `is_active` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_color` (`color`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'normal bed', '#b31414', '', 1, 0, '2024-09-26 12:00:46');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'Ac Bed', '#f4f4f4', '', 1, 0, '2024-09-28 08:06:06');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'Private Beds', '#47a136', '', 2, 0, '2024-09-28 08:06:32');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (4, 'vvip bed', '#f4f4f4', '', 2, 0, '2024-10-09 09:46:09');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'general bed', '2024-09-26 11:59:39');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'Private Beds', '2024-09-28 08:06:41');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (3, 'VIP Bed', '2024-10-07 10:56:08');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (4, 'vvip bed', '2024-10-09 09:44:39');


#
# TABLE STRUCTURE FOR: bill
#

DROP TABLE IF EXISTS `bill`;

CREATE TABLE `bill` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_id` int NOT NULL,
  `attachment` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `attachment_name` mediumtext,
  `amount` float(10,2) DEFAULT NULL,
  `payment_mode` varchar(100) DEFAULT NULL,
  `cheque_no` varchar(100) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `note` mediumtext,
  `received_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_id` (`case_id`),
  CONSTRAINT `bill_ibfk_1` FOREIGN KEY (`case_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `birth_report` mediumtext,
  `document` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `address` text,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_child_name` (`child_name`),
  KEY `index_gender` (`gender`),
  KEY `index_weight` (`weight`),
  KEY `index_contact` (`contact`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (3, 'Riya  Paul', 'uploads/patient_images/no_image.png', 'Female', '2024-10-11 01:23:00', '2.5', 3, 9, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2024-10-11 08:24:20');


#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (1, 'A-', 1, '2024-09-26 07:05:49');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (2, 'A+', 1, '2024-09-26 07:05:57');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (3, 'B-', 1, '2024-09-26 07:06:09');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (4, 'B+', 1, '2024-09-26 07:06:16');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (5, 'Red Cells', 2, '2024-09-26 07:06:27');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (6, 'Plazma', 2, '2024-09-26 07:06:37');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (7, 'O+', 1, '2024-09-26 07:06:56');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (8, 'O-', 1, '2024-10-07 12:06:59');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (9, 'AB+', 1, '2024-10-10 11:24:59');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (10, 'AB-', 1, '2024-10-10 11:25:27');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `index_donor_name` (`donor_name`),
  KEY `index_gender` (`gender`),
  KEY `index_father_name` (`father_name`),
  KEY `index_contact_no` (`contact_no`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'John', '2004-06-18', 2, 'Male', 'Smith', '', '9089089789', '2024-09-26 07:47:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'maria', '1999-02-11', 3, 'Female', 'Kalvin', '', '87895675', '2024-09-26 07:48:18');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'Lokesh', '1994-06-16', 4, 'Male', 'Arjun', '', '788956757', '2024-09-26 07:49:00');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (4, 'Sara', '1999-07-09', 1, 'Female', 'oliver', '', '89068575', '2024-09-26 08:13:32');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (5, 'JAYA VARMA', '1998-10-16', 7, 'Female', '', '', '', '2024-10-10 11:30:20');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int NOT NULL,
  `blood_bank_product_id` int DEFAULT NULL,
  `blood_donor_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT '0.00',
  `volume` varchar(100) DEFAULT NULL,
  `unit` int DEFAULT NULL,
  `available` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_bag_no` (`bag_no`),
  KEY `index_lot` (`lot`),
  KEY `index_amount` (`amount`),
  KEY `index_unit` (`unit`),
  KEY `index_volume` (`volume`),
  KEY `index_quantity` (`quantity`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_apply_charge` (`apply_charge`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (1, 0, NULL, 1, 3, '2024-09-26', '1', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 1, 0, '2024-09-26 07:49:31');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (2, 0, NULL, 1, 3, '2024-09-24', '2', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 6, 0, '2024-09-26 07:49:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (3, 0, NULL, 2, 3, '2024-09-21', '4', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 1, 1, '2024-09-26 07:50:13');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (4, 0, NULL, 1, 3, '2024-09-30', '7', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 1, 0, '2024-09-26 07:50:36');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (5, 0, NULL, 2, 3, '2024-09-30', '67', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 1, 1, '2024-09-26 07:50:59');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (6, 2, 5, NULL, NULL, NULL, '5', '2', 1, NULL, NULL, NULL, 'blood bank Center', NULL, '0.00', '0.00', '220', 1, 0, '2024-09-26 07:53:05');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (7, 2, 6, NULL, NULL, NULL, '8', '2', 1, NULL, NULL, NULL, 'blood bank Center', NULL, '0.00', '0.00', '220', 6, 1, '2024-09-26 07:53:05');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (8, 0, 1, 4, 3, '2024-09-29', '15', '2', 1, '250.00', '250.00', '287.50', 'blood bank Center', '', '0.00', '15.00', '220', 1, 0, '2024-09-26 08:14:39');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (9, 0, NULL, 3, 3, '2024-09-27', '12', '5', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '', 2, 0, '2024-09-27 12:12:41');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (10, 8, 5, NULL, NULL, NULL, '2', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '5', 1, 0, '2024-09-27 12:13:44');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (11, 8, 6, NULL, NULL, NULL, '3', '7', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '6', 3, 0, '2024-09-27 12:13:44');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (12, 0, NULL, 4, 3, '2024-09-30', '33', '33', 1, '250.00', '250.00', '287.50', '33', '33', '0.00', '15.00', '33', 4, 0, '2024-09-30 10:06:07');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (13, 0, NULL, 4, 3, '2024-09-30', '34', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 1, 0, '2024-09-30 11:46:18');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (14, 0, NULL, 4, 3, '2024-09-23', '21', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '220', 6, 0, '2024-09-30 11:46:33');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (15, 0, NULL, 4, 3, '2024-10-10', '0', '2', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '', 5, 1, '2024-10-10 11:27:23');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (16, 14, 5, NULL, NULL, NULL, '5', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '7', 6, 1, '2024-10-10 11:29:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (17, 14, 6, NULL, NULL, NULL, '4', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '6', 3, 1, '2024-10-10 11:29:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (18, 0, 7, 5, 3, '2024-10-10', '23', '12', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '', 5, 0, '2024-10-10 11:31:13');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (19, 0, NULL, 4, 3, '2024-10-10', '24', '20', 1, '250.00', '250.00', '287.50', '', '', '0.00', '15.00', '', 5, 1, '2024-10-10 11:32:35');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `case_reference_id` int DEFAULT NULL,
  `blood_donor_cycle_id` int DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int DEFAULT NULL,
  `reference` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `charge_id` int DEFAULT NULL,
  `standard_charge` int NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `technician` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `remark` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `organisation_id` int DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  KEY `generated_by` (`generated_by`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  KEY `hospital_doctor` (`hospital_doctor`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_5` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_6` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_7` FOREIGN KEY (`hospital_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `hospital_doctor`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`) VALUES (9, 3, 9, 13, '2024-09-30 18:11:00', 2, 'Ajay Verma (9002)', 3, 250, '15.00', '10.00', '250.00', '258.75', NULL, '', '', NULL, NULL, NULL, 1, '2024-09-30 12:42:18');
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `hospital_doctor`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`) VALUES (10, 7, NULL, 9, '2024-10-08 16:53:00', 2, 'Ajay Verma (9002)', 11, 200, '18.00', '10.00', '200.00', '212.40', NULL, '', '', 6, '2025-10-29', '100', 1, '2024-10-08 11:24:58');
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `hospital_doctor`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`) VALUES (11, 7, NULL, 10, '2024-10-08 18:14:00', NULL, 'Ajay Verma (9002)', 11, 200, '18.00', '3.00', '5.00', '5.72', NULL, '', '', 6, '2025-10-29', '100', 1, '2024-10-08 12:46:09');
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `hospital_doctor`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`) VALUES (12, 7, NULL, 18, '2024-10-10 04:35:00', 2, 'Ajay Verma (9002)', 11, 200, '18.00', '0.00', '5.00', '5.90', NULL, 'AJAY', '', 6, '2025-10-29', '100', 1, '2024-10-10 11:36:45');


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 1, '2024-09-30 10:17:48');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 05:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 1, '2024-09-30 10:17:51');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_id` int DEFAULT NULL,
  `discount_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_references_ibfk_1` (`bill_id`),
  CONSTRAINT `case_references_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bill` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3;

INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (1, NULL, '0.00', '2024-09-26 07:37:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (2, NULL, '0.00', '2024-09-26 09:54:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (3, NULL, '0.00', '2024-09-26 12:02:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (4, NULL, '0.00', '2024-09-27 09:29:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (5, NULL, '0.00', '2024-09-27 09:46:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (6, NULL, '0.00', '2024-09-27 09:48:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (7, NULL, '0.00', '2024-09-28 07:09:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (8, NULL, '0.00', '2024-09-28 07:13:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (9, NULL, '0.00', '2024-09-28 08:08:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (10, NULL, '0.00', '2024-09-28 10:05:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (11, NULL, '0.00', '2024-09-28 10:36:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (12, NULL, '0.00', '2024-09-28 10:36:45');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (13, NULL, '0.00', '2024-09-28 10:37:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (14, NULL, '0.00', '2024-09-28 10:37:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (15, NULL, '0.00', '2024-09-28 10:37:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (16, NULL, '0.00', '2024-09-28 10:37:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (17, NULL, '0.00', '2024-09-28 10:44:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (18, NULL, '0.00', '2024-09-28 10:47:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (19, NULL, '0.00', '2024-09-28 10:49:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (20, NULL, '0.00', '2024-09-28 10:49:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (21, NULL, '0.00', '2024-09-28 10:50:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (22, NULL, '0.00', '2024-09-30 07:25:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (23, NULL, '0.00', '2024-10-01 04:36:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (24, NULL, '0.00', '2024-10-07 11:48:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (25, NULL, '0.00', '2024-10-07 12:01:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (26, NULL, '0.00', '2024-10-08 07:50:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (27, NULL, '0.00', '2024-10-08 07:53:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (28, NULL, '0.00', '2024-10-08 08:17:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (29, NULL, '0.00', '2024-10-08 10:35:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (30, NULL, '0.00', '2024-10-09 07:29:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (31, NULL, '0.00', '2024-10-09 08:23:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (32, NULL, '0.00', '2024-10-09 08:32:30');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int NOT NULL,
  `content_height` int NOT NULL,
  `footer_height` int NOT NULL,
  `content_width` int NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', 'certificate.jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2021-10-28 22:58:45');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (13, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-10-01 08:33:35');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (14, 'File cover', '<td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-10-14 08:01:09');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (15, 'FILE COVER', '<td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-10-14 08:00:33');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type_id` int DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (1, 2, 'Opd Charge', 'Opd Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 1, 'Appointment meeting', 'Appointment meeting', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 3, 'Ipd Charge', 'Ipd Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 7, 'Ambulance service', 'Ambulance service', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 6, 'Blood bank Charge', 'Blood bank Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 4, 'pathology', 'pathology test', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 12, 'heametology', 'all heametology charges', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 1, 'TPA Appointment', 'TPA Appointment', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 2, 'TPA opd', 'TPA opd', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 3, 'TPA ipd', 'TPA ipd', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 4, 'TPA path', 'TPA path', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 5, 'TPA radiology  charge', 'tpa radiology', NULL, '', '2024-10-08 11:17:40');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 2, 'opd charge fees', 'opd fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'pahtology charge', 'pathology', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_charge_type` (`charge_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 14:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 14:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 14:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 21:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-22 22:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-22 22:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-22 22:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 13:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 03:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 03:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 03:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 03:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 03:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 03:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 03:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 03:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 03:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 03:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 03:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 03:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 03:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 03:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 03:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 03:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 03:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 03:53:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (28, 1, 'opd', '2024-09-28 12:10:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (29, 1, 'ipd', '2024-09-28 12:10:24');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (30, 1, 'pathology', '2024-09-28 12:10:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (31, 1, 'radiology', '2024-09-28 12:10:28');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (32, 1, 'blood_bank', '2024-09-28 12:10:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (33, 1, 'ambulance', '2024-09-28 12:10:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (34, 2, 'appointment', '2024-09-28 12:10:33');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (35, 3, 'appointment', '2024-09-28 12:10:34');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (36, 4, 'appointment', '2024-09-28 12:10:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (37, 5, 'appointment', '2024-09-28 12:10:36');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (38, 6, 'appointment', '2024-09-28 12:10:37');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (39, 7, 'appointment', '2024-09-28 12:10:38');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (40, 8, 'appointment', '2024-09-28 12:10:39');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (41, 9, 'appointment', '2024-09-28 12:10:40');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (42, 10, 'appointment', '2024-09-28 12:10:41');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (43, 11, 'appointment', '2024-09-28 12:10:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (44, 3, 'opd', '2024-09-28 12:10:46');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (45, 4, 'opd', '2024-09-28 12:10:47');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (46, 5, 'opd', '2024-09-28 12:10:48');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (47, 6, 'opd', '2024-09-28 12:10:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (48, 7, 'opd', '2024-09-28 12:10:50');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (49, 2, 'ipd', '2024-09-28 12:10:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (50, 4, 'ipd', '2024-09-28 12:10:53');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (51, 5, 'ipd', '2024-09-28 12:10:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (52, 6, 'ipd', '2024-09-28 12:10:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (53, 7, 'ipd', '2024-09-28 12:10:57');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (54, 9, 'ipd', '2024-09-28 12:10:58');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (55, 9, 'opd', '2024-09-28 12:11:00');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (56, 2, 'pathology', '2024-10-07 08:21:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (57, 2, 'radiology', '2024-10-07 08:21:05');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (58, 3, 'pathology', '2024-10-07 08:21:10');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (59, 5, 'pathology', '2024-10-07 08:21:12');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (60, 6, 'pathology', '2024-10-07 08:21:13');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (61, 7, 'pathology', '2024-10-07 08:21:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (62, 8, 'pathology', '2024-10-07 08:21:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (63, 10, 'pathology', '2024-10-07 08:21:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (64, 11, 'pathology', '2024-10-07 08:21:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (65, 7, 'radiology', '2024-10-07 08:21:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (66, 4, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (67, 3, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (68, 6, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (69, 8, 'radiology', '2024-10-07 09:12:32');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (70, 10, 'radiology', '2024-10-07 09:12:34');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (71, 11, 'radiology', '2024-10-07 09:12:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (72, 2, 'blood_bank', '2024-10-08 08:52:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (73, 3, 'blood_bank', '2024-10-08 08:52:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (74, 4, 'blood_bank', '2024-10-08 08:52:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (75, 5, 'blood_bank', '2024-10-08 08:52:19');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (76, 7, 'blood_bank', '2024-10-08 08:52:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (77, 8, 'blood_bank', '2024-10-08 08:52:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (78, 9, 'blood_bank', '2024-10-08 08:52:24');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (79, 10, 'blood_bank', '2024-10-08 08:52:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (80, 11, 'blood_bank', '2024-10-08 08:52:26');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (81, 2, 'ambulance', '2024-10-08 08:52:28');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (82, 3, 'ambulance', '2024-10-08 08:52:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (83, 4, 'ambulance', '2024-10-08 08:52:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (84, 5, 'ambulance', '2024-10-08 08:52:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (85, 6, 'ambulance', '2024-10-08 08:52:32');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (86, 8, 'ambulance', '2024-10-08 08:52:33');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (87, 10, 'ambulance', '2024-10-08 08:52:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (88, 9, 'ambulance', '2024-10-08 08:52:36');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (89, 11, 'ambulance', '2024-10-08 08:52:37');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'litter', 0, '2024-09-26 07:07:21');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'hour', 0, '2024-09-26 07:07:26');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (3, 'per day', 0, '2024-09-26 07:07:33');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (5, 'ml', 0, '2024-09-26 07:07:40');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (6, 'g/dl', 0, '2024-09-26 07:07:46');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (7, 'gm/day', 0, '2024-10-07 08:56:50');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_category_id` int DEFAULT NULL,
  `tax_category_id` int DEFAULT NULL,
  `charge_unit_id` int DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT '0.00',
  `date` date DEFAULT NULL,
  `description` mediumtext,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  KEY `index_name` (`name`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_date` (`date`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (1, 2, 2, 2, 'Appointment meeting', '200.00', NULL, '', '', '2024-09-26 07:10:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (2, 1, 1, 2, 'OPD charge service', '150.00', NULL, '', '', '2024-09-26 07:12:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (3, 5, 1, 1, 'Blood test charge', '250.00', NULL, '', '', '2024-09-26 07:13:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (4, 4, 2, 2, 'Ambulance service', '150.00', NULL, '', '', '2024-09-26 07:14:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (7, 1, 2, 2, 'tax', '200.00', NULL, '', '', '2024-10-07 09:09:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (8, 2, 1, 2, 'TPA charges', '200.00', NULL, '', '', '2024-10-08 08:11:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (9, 1, 1, 1, 'TPA ', '200.00', NULL, '', '', '2024-10-08 08:22:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (10, 6, 2, 2, 'TPA PATH', '150.00', NULL, '', '', '2024-10-08 08:23:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (11, 5, 2, 6, 'TPA BLOOD BANK', '200.00', NULL, '', '', '2024-10-08 08:24:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (12, 2, 1, 3, 'TPA Appointment', '200.00', NULL, '', '', '2024-10-08 10:32:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (13, 10, 1, 2, 'TPA OPD CHECKUP FEES', '1000.00', NULL, '', '', '2024-10-08 10:34:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (14, 13, 3, 2, 'tpa radiology fees', '500.00', NULL, '', '', '2024-10-08 11:18:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 1, 1, 2, 'OPD charge fees', '500.00', NULL, '', '', '2024-10-09 08:26:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 3, 1, 2, 'IPD charge fees', '200.00', NULL, '', '', '2024-10-09 10:47:30');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `chat_user_one` int NOT NULL,
  `chat_user_two` int NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_connections` (`id`, `chat_user_one`, `chat_user_two`, `ip`, `time`, `created_at`, `updated_at`) VALUES (1, 1, 2, NULL, NULL, '2024-09-26 12:22:05', NULL);


#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `chat_user_id` int NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int NOT NULL,
  `is_first` int DEFAULT '0',
  `is_read` int NOT NULL DEFAULT '0',
  `chat_connection_id` int NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (1, 'you are now connected on chat', 2, '', 0, 1, 1, 1, NULL);


#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `create_staff_id` int DEFAULT NULL,
  `create_patient_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'staff', 1, NULL, NULL, NULL, 0, '2024-09-26 12:22:05', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'staff', 2, NULL, 1, NULL, 0, '2024-09-26 12:22:05', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text,
  `image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (1, 1, 'Staff', 'aman', '', '', '2024-09-30', '', '', '', '', '', NULL);
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (2, 2, 'offline', 'jaya', '', '', '2024-10-10', '', '', '', '', '', NULL);
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (3, 3, 'Patient', 'jyoti', '', '', '2024-10-10', '', '', '', '', '', NULL);


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_complaint_type` (`complaint_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Late checkup', '', '2024-09-30 07:41:18');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (2, 'hair fall', '', '2024-10-07 11:28:28');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (3, 'staff related', '', '2024-10-10 12:03:45');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int NOT NULL AUTO_INCREMENT,
  `conference_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `ipd_id` int DEFAULT NULL,
  `created_id` int DEFAULT NULL,
  `title` text,
  `date` datetime NOT NULL,
  `duration` int NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int NOT NULL,
  `client_video` int NOT NULL,
  `description` mediumtext,
  `timezone` text,
  `return_response` text,
  `api_type` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `live_consult_link` int NOT NULL DEFAULT '1' COMMENT 'appointment zoom link for front user status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (1, 'consult', 2, NULL, 10, NULL, NULL, 'Online consult for Checkup ID 8', '2024-09-28 11:00:00', 0, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2024-09-28 10:05:47');


#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `conference_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `total_hit` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `doctor` int DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text,
  `cons_doctor` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (1, 2, '2024-09-28 16:04:00', '2024-09-28', 'imigate', 2, '2024-09-28 10:34:55');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (3, 4, '2024-10-09 16:00:00', '2024-10-09', 'offline only', 2, '2024-10-09 10:30:18');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text,
  `is_active` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (2, 'Hospital document file', 'Hospital document file', 1, '2024-09-30 10:09:12');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (4, 'documentation', '', 1, '2024-10-01 07:45:09');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (5, 'medical list', '', 1, '2024-10-01 07:46:34');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (6, 'Hospital record', '', 1, '2024-10-05 09:22:06');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (7, 'All medical inventory record', 'All medical inventory record', 1, '2024-10-14 07:19:57');


#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `belong_table_id` int DEFAULT NULL,
  `custom_field_id` int DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `index_field_value` (`field_value`),
  KEY `index_belong_table_id` (`belong_table_id`),
  KEY `index_custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1, 1, 1, 'Pelvic Examination', '2024-09-28 08:10:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2, NULL, 2, 'Good', '2024-09-28 08:13:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3, NULL, 2, 'Good', '2024-09-28 11:27:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4, NULL, 3, 'Custom fields dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', '2024-09-28 11:27:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (5, 2, 1, 'k', '2024-09-28 12:07:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (6, 2, 2, 'Good', '2024-09-28 12:07:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (7, 2, 3, 'k', '2024-09-28 12:07:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (8, 3, 4, 'Caustom radiology', '2024-09-28 12:24:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (9, 3, 1, 'yes', '2024-09-28 12:36:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (10, 3, 2, 'Good', '2024-09-28 12:36:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (11, 3, 3, '', '2024-09-28 12:36:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (12, 4, 1, 'k', '2024-09-30 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (13, 4, 2, 'Good', '2024-09-30 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (14, 4, 3, 'k', '2024-09-30 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (15, 5, 1, 'CUSTOM test', '2024-09-30 07:27:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (16, 5, 2, 'bad', '2024-09-30 07:27:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (17, 5, 3, 'CUSTOM test', '2024-09-30 07:27:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (18, 4, 4, 'no', '2024-10-08 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (19, 4, 7, '', '2024-10-08 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (20, 10, 9, '', '2024-10-08 11:24:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (21, 11, 10, '2', '2024-10-08 12:46:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (22, 25, 6, '', '2024-10-09 07:29:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (23, 24, 6, '', '2024-10-09 07:31:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (24, 4, 6, '', '2024-10-09 07:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (25, 26, 6, '', '2024-10-09 08:23:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (26, 0, 4, 'no', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (27, 0, 7, '', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (28, 5, 4, 'no', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (29, 5, 7, '', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (30, 12, 9, '', '2024-10-10 11:36:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (31, 3, 8, '', '2024-10-11 08:24:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (32, 5, 13, '', '2024-10-11 12:01:05');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int DEFAULT NULL,
  `validation` int DEFAULT '0',
  `field_values` mediumtext,
  `visible_on_print` int DEFAULT NULL,
  `visible_on_report` int DEFAULT NULL,
  `visible_on_table` int DEFAULT NULL,
  `visible_on_patient_panel` int DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_belong_to` (`belong_to`),
  KEY `index_type` (`type`),
  KEY `index_visible_on_table` (`visible_on_table`),
  KEY `index_visible_on_print` (`visible_on_print`),
  KEY `index_visible_on_report` (`visible_on_report`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (1, 'Previous Details CUSTOM', 'antenatal', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2024-09-30 06:24:55');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (2, 'Health Report CUSTOM', 'antenatal', 'select', 12, 1, 'Good, bad', 1, 1, 1, 1, NULL, 0, '2024-09-30 10:53:38');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (3, 'custom fields CUSTOM', 'antenatal', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2024-09-30 06:25:09');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (4, 'caustom radiology', 'radiology', 'input', 12, 1, 'dfgdfgdg', 1, 1, 1, 1, NULL, 0, '2024-09-28 12:23:08');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (5, 'ambulances', 'ambulance_call', 'checkbox', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:15:13');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (6, 'appoinment', 'appointment', 'date_picker', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:16:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (7, 'radiology', 'radiology', 'date_picker', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:16:52');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (8, 'birth record', 'birth_report', 'date_picker_time', 12, 0, '2,3', 0, 0, 1, 0, NULL, 0, '2024-10-07 12:17:53');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (9, 'blood issue', 'blood_issue', 'date_picker', 12, 0, '2,3', 0, 0, 1, 0, NULL, 0, '2024-10-07 12:18:31');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (10, 'component issue', 'component_issue', 'checkbox', 12, 0, '2,3', 1, 0, 0, 0, NULL, 0, '2024-10-07 12:19:07');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (11, 'death record', 'death_report', 'checkbox', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:19:38');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (12, 'donor', 'donor', 'checkbox', 12, 0, '2.3', 0, 0, 1, 0, NULL, 0, '2024-10-07 12:54:35');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (13, 'expenses', 'expenses', 'colorpicker', 12, 0, '2,3', 0, 0, 0, 0, NULL, 0, '2024-10-07 12:55:19');


#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `attachment_name` text,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (4, 5, 23, '', NULL, '2024-10-11 01:25:00', 'Karan', '', 'yes', '2024-10-11 08:25:32');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (5, 5, 23, '', NULL, '2024-10-11 01:27:00', 'Karan', '', 'yes', '2024-10-11 08:27:08');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_department_name` (`department_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'Opd', 'yes', '2024-09-26 07:18:39');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (2, 'IPD', 'yes', '2024-09-26 07:18:45');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (3, 'Radiology', 'yes', '2024-09-26 07:18:53');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', '2024-09-26 07:19:00');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (6, 'Pharma', 'yes', '2024-09-30 11:08:44');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (7, 'Blood bank', 'yes', '2024-10-11 10:27:08');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_reference_id` int DEFAULT NULL,
  `opd_details_id` int DEFAULT NULL,
  `ipd_details_id` int DEFAULT NULL,
  `discharge_by` int DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text,
  `treatment_home` varchar(255) NOT NULL,
  `note` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text,
  `note` text,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_reference_no` (`reference_no`),
  KEY `index_to_title` (`to_title`),
  KEY `index_from_title` (`from_title`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (1, '1234', '', '', '', 'Electricity bill', '2024-09-30', '', 'receive', '2024-09-30 07:50:31');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (2, '234', 'Report', ' ', '', '', '2024-09-30', '', 'dispatch', '2024-09-30 08:53:42');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (3, '', '', '', '', 'income tex', '2024-10-10', '', 'receive', '2024-10-10 12:00:36');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (4, '', 'Document in hospital', '', '', '', '2024-10-10', '', 'dispatch', '2024-10-10 12:01:39');


#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `global_shift_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (1, 2, 1, '2024-09-26 07:30:09');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 2, 2, '2024-09-26 07:30:10');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (3, 2, 3, '2024-09-27 09:27:52');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 2, 4, '2024-09-27 09:27:54');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (5, 2, 5, '2024-09-27 09:27:57');


#
# TABLE STRUCTURE FOR: doctor_shift_time
#

DROP TABLE IF EXISTS `doctor_shift_time`;

CREATE TABLE `doctor_shift_time` (
  `id` int NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `doctor_global_shift_id` int DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `doctor_global_shift_id` (`doctor_global_shift_id`),
  KEY `index_day` (`day`),
  CONSTRAINT `doctor_shift_time_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_time_ibfk_3` FOREIGN KEY (`doctor_global_shift_id`) REFERENCES `doctor_global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:33');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (2, 'Tuesday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:45');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (3, 'Thursday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:56');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (4, 'Friday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:05');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (5, 'Wednesday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:17');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (6, 'Saturday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:25');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (1, '1 time', '2024-09-26 12:16:40');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (2, '3 time', '2024-10-07 11:37:53');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (3, '2 times', '2024-10-10 09:04:40');


#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (1, '2time', '2024-09-26 12:07:36');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (2, 'morning-night', '2024-10-07 11:37:34');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (3, 'After meal', '2024-10-10 09:04:16');


#
# TABLE STRUCTURE FOR: duty_roster_assign
#

DROP TABLE IF EXISTS `duty_roster_assign`;

CREATE TABLE `duty_roster_assign` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` int NOT NULL,
  `roster_duty_date` date DEFAULT NULL,
  `floor_id` int DEFAULT NULL,
  `department_id` int DEFAULT NULL,
  `staff_id` int NOT NULL,
  `duty_roster_list_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `duty_roster_list_id` (`duty_roster_list_id`),
  KEY `department_id` (`department_id`),
  KEY `staff_id` (`staff_id`),
  KEY `floor_id` (`floor_id`),
  KEY `index_roster_duty_date` (`roster_duty_date`),
  CONSTRAINT `duty_roster_assign_ibfk_1` FOREIGN KEY (`duty_roster_list_id`) REFERENCES `duty_roster_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_2` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_4` FOREIGN KEY (`floor_id`) REFERENCES `floor` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (31, 4, '2024-08-28', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (32, 4, '2024-08-29', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (33, 4, '2024-08-30', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (34, 4, '2024-08-31', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (35, 4, '2024-09-01', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (36, 4, '2024-09-02', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (37, 4, '2024-09-03', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (38, 4, '2024-09-04', 2, 1, 2, 3, '2024-10-05 07:09:49');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (39, 5, '2024-08-28', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (40, 5, '2024-08-29', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (41, 5, '2024-08-30', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (42, 5, '2024-08-31', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (43, 5, '2024-09-01', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (44, 5, '2024-09-02', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (45, 5, '2024-09-03', 1, 6, 4, 3, '2024-10-05 07:10:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (46, 5, '2024-09-04', 1, 6, 4, 3, '2024-10-05 07:10:53');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (47, 6, '2024-10-12', 3, 7, 8, 5, '2024-10-11 10:46:24');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (48, 6, '2024-10-13', 3, 7, 8, 5, '2024-10-11 10:46:24');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (49, 6, '2024-10-14', 3, 7, 8, 5, '2024-10-11 10:46:24');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (50, 6, '2024-10-15', 3, 7, 8, 5, '2024-10-11 10:46:24');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (51, 7, '2024-10-11', 4, 7, 8, 6, '2024-10-11 10:46:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (52, 7, '2024-10-12', 4, 7, 8, 6, '2024-10-11 10:46:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (53, 7, '2024-10-13', 4, 7, 8, 6, '2024-10-11 10:46:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (54, 7, '2024-10-14', 4, 7, 8, 6, '2024-10-11 10:46:52');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `created_at`) VALUES (55, 7, '2024-10-15', 4, 7, 8, 6, '2024-10-11 10:46:52');


#
# TABLE STRUCTURE FOR: duty_roster_list
#

DROP TABLE IF EXISTS `duty_roster_list`;

CREATE TABLE `duty_roster_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `duty_roster_shift_id` int NOT NULL,
  `duty_roster_start_date` date NOT NULL,
  `duty_roster_end_date` date NOT NULL,
  `duty_roster_total_day` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `duty_roster_shift_id` (`duty_roster_shift_id`),
  KEY `index_duty_roster_start_date` (`duty_roster_start_date`),
  KEY `index_duty_roster_end_date` (`duty_roster_end_date`),
  CONSTRAINT `duty_roster_list_ibfk_1` FOREIGN KEY (`duty_roster_shift_id`) REFERENCES `duty_roster_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (2, 2, '2024-09-08', '2024-09-14', 7, '2024-09-27 04:57:56');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (3, 1, '2024-08-28', '2024-09-04', 8, '2024-09-28 12:33:25');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (4, 4, '2024-10-01', '2024-10-02', 2, '2024-09-30 11:45:46');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (5, 5, '2024-10-12', '2024-10-15', 4, '2024-10-11 10:44:27');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (6, 3, '2024-10-11', '2024-10-15', 5, '2024-10-11 10:45:35');


#
# TABLE STRUCTURE FOR: duty_roster_shift
#

DROP TABLE IF EXISTS `duty_roster_shift`;

CREATE TABLE `duty_roster_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_start` time NOT NULL,
  `shift_end` time NOT NULL,
  `shift_hour` time NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_shift_name` (`shift_name`),
  KEY `index_shift_start` (`shift_start`),
  KEY `index_shift_end` (`shift_end`),
  KEY `index_shift_hour` (`shift_hour`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (1, 'Morning ', '10:30:00', '13:30:00', '03:00:00', 1, '2024-09-27 04:56:13');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (2, 'Evening', '16:30:00', '19:00:00', '02:30:00', 1, '2024-09-27 04:56:48');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (3, 'Night ', '20:00:00', '23:30:00', '03:30:00', 1, '2024-09-27 04:57:18');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (4, 'afternoon', '12:00:00', '15:00:00', '03:00:00', 1, '2024-09-30 11:45:18');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (5, 'MORNNING', '10:00:00', '14:00:00', '04:00:00', 1, '2024-10-11 10:43:04');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'smtp', 'smtp.gmail.com', '587', 'ascent.jbp@gmail.com', 'ascent.jbp@gmail.com', 'tls', 'true', 'yes', '2024-09-30 05:00:18');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `start_date` (`start_date`),
  KEY `index_end_date` (`end_date`),
  KEY `index_event_type` (`event_type`) USING BTREE,
  KEY `index_event_color` (`event_color`) USING BTREE,
  KEY `index_event_title` (`event_title`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (1, 'holidays', '', '2024-10-02 00:00:00', '2024-10-02 00:00:00', 'task', '#000', '1', 7, 'no', '2024-09-30 07:18:58');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (2, 'holiday', '', '2024-11-08 00:00:00', '2024-11-08 00:00:00', 'task', '#000', '7', 1, 'no', '2024-10-05 07:13:51');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (3, 'event', '', '2024-10-16 00:00:00', '2024-10-16 00:00:00', 'task', '#000', '7', 1, 'no', '2024-10-07 09:02:58');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (4, 'dashara holiday', '', '2024-10-12 00:00:00', '2024-10-12 00:00:00', 'task', '#000', '1', 7, 'no', '2024-10-09 07:09:54');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_exp_category` (`exp_category`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'tax', 'income tax', 'yes', 'no', '2024-09-28 12:52:41');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'electricity', '', 'yes', 'no', '2024-10-05 08:37:17');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Income tex', '', 'yes', 'no', '2024-10-07 12:09:01');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Staff expence', '', 'yes', 'no', '2024-10-11 12:04:52');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_name` (`name`),
  KEY `index_date` (`date`) USING BTREE,
  KEY `index_amount` (`amount`) USING BTREE,
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (2, 1, 'income tex', '', '2024-09-30', '10000.00', NULL, '', 'yes', 'no', 1, '2024-09-30 12:21:41');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (3, 1, 'tex', '', '2024-09-30', '1000.00', NULL, '', 'yes', 'no', 1, '2024-09-30 12:23:51');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (5, 2, 'Electricity bill expence', '', '2024-10-11', '3000.00', NULL, '', 'yes', 'no', 1, '2024-10-11 12:01:05');


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_extension` text,
  `file_mime` text,
  `file_size` int NOT NULL,
  `image_extension` text,
  `image_mime` text,
  `image_size` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text,
  `finding_category_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (1, 'Elevated temperature (above 100.4°)', 'The medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 1, '2024-09-30 04:37:15');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (2, 'Eczema.', 'Eczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 2, '2024-09-30 04:37:44');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (3, 'Osteoporosis', 'Bone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 3, '2024-09-30 04:38:07');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (4, 'Damaged Hair', 'Damaged Hair	', 4, '2024-09-30 04:38:19');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (5, 'fever', '', 1, '2024-10-07 07:53:32');


#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (1, 'Fever', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (2, 'Skin Problem', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (3, 'Bone Density Problems', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (4, 'Hair Problems', '2024-09-30 04:36:36');


#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (1, '1st floor', '', '2024-09-26 12:00:24');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (2, '2nd Floor', '', '2024-09-28 08:06:17');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (3, '3rd floor', '', '2024-10-07 10:58:22');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (4, '4th floor', '', '2024-10-09 09:46:32');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (5, '5th floor', '', '2024-10-09 09:46:46');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (1, NULL, 'uploads/gallery/youtube_video/thumb/', 'uploads/gallery/youtube_video/', '66f7d16a750c0.jpg', '66f7d16a750c0.jpg', 'video', '0', 'https://www.youtube.com/watch?v=4kFg2EqEIv8&list=PLu0W_9lII9aikXkRE0WxDt1vozo3hnmtR&index=3', 'Web Development 101: How HTML, CSS, JavaScript & PHP Work Together | PHP Tutorial #3', '2024-09-28 09:50:34');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (2, NULL, 'uploads/gallery/youtube_video/thumb/', 'uploads/gallery/youtube_video/', '66fbc0c77fae4.jpg', '66fbc0c77fae4.jpg', 'video', '0', 'https://youtu.be/kbvHM2S2_bk', 'Gaurav\'s Farewell | Canva', '2024-10-01 09:28:39');


#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu_id` int DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int NOT NULL,
  `parent_id` int NOT NULL,
  `ext_url` mediumtext,
  `open_new_tab` int DEFAULT '0',
  `ext_url_link` mediumtext,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `publish` int NOT NULL DEFAULT '0',
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 03:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 0, 0, '1', NULL, 'https://dev1.webfeb.com/shqratfa/form/appointment', 'appointment', 2, 0, NULL, 'no', '2024-09-26 05:35:36');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 03:18:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 10:54:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (5, 1, 'Annual Calendar', 0, 0, '1', NULL, 'https://dev1.webfeb.com/shqratfa/page/annual_calendar', 'annual-calendar', NULL, 0, NULL, 'no', '2024-09-30 12:04:11');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (6, 1, 'messeges', 1, 0, NULL, NULL, NULL, 'messeges', NULL, 0, NULL, 'no', '2024-10-14 09:11:04');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `open_new_tab` int NOT NULL DEFAULT '0',
  `ext_url` mediumtext,
  `ext_url_link` mediumtext,
  `publish` int NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:55');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (4, 'SIDE MENU', 'side-menu', '', 0, NULL, NULL, 0, 'manual', 'no', '2024-10-01 09:31:38');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (5, 'Side menu2', 'side-menu2', '', 0, NULL, NULL, 0, 'manual', 'no', '2024-10-14 09:09:44');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_id` int DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext,
  `publish_date` date DEFAULT NULL,
  `publish` int DEFAULT '0',
  `sidebar` int DEFAULT '0',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe>Home page firstghfrf</p>', '0000-00-00', 1, 1, 'no', '2024-10-05 09:49:18');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 03:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 11:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 06:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 11:35:25');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (6, 'manual', 0, 'complain', 'page/complain-1', 'page', 'complain-1', '', '', '', '', '<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe><img src=\"https://dev1.webfeb.com/shphp8ga/uploads/gallery/media/free-medical-camp-design-template-b6101353f0605b9179200e35e650d2e5_screen.jpg\" />', NULL, 0, 1, 'no', '2024-10-01 09:20:45');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `program_id` int DEFAULT NULL,
  `media_gallery_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (1, 6, 1, '2024-10-14 09:04:13');


#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext,
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (1, 'events', 'camp', 'read/camp', 'camp', NULL, '2024-10-01', '2024-10-01', 'hospital', '<p>hospital camp</p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-01 09:26:43');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (2, 'events', 'event', 'read/event', 'EVENT', NULL, '2024-10-05', '2024-10-05', 'HOSPITAL', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:53:51');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (3, 'gallery', 'gallery-image', 'read/gallery-image', 'GALLERY IMAGE', NULL, NULL, NULL, NULL, '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:55:25');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (4, 'notice', 'news', 'read/news', 'NEWS', '2024-10-05', NULL, NULL, NULL, '<p>NEWS</p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:56:31');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (5, 'events', 'hospital-camp', 'read/hospital-camp', 'Hospital camp', NULL, '2024-10-14', '2024-10-14', 'hospital', '<p><span style=\"font-size: 13px;\">Hospital camp</span><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:01:57');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (6, 'gallery', 'hospital-image', 'read/hospital-image', 'HOSPITAL IMAGE', NULL, NULL, NULL, NULL, '<p><span xss=\"removed\">HOSPITAL IMAGE</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:04:13');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (7, 'notice', 'hospital-news', 'read/hospital-news', 'HOSPITAL NEWS', '2024-10-14', NULL, NULL, NULL, '<p><span xss=removed>HOSPITAL NEWS</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:05:06');


#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int DEFAULT '0',
  `is_active_front_cms` int DEFAULT '0',
  `is_active_online_appointment` int DEFAULT NULL,
  `is_active_sidebar` int DEFAULT '0',
  `logo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'white_gray', NULL, 1, 1, NULL, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2024-09-30 12:06:27');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `online_appointment_id` int DEFAULT NULL,
  `type` varchar(30) NOT NULL COMMENT 'patient_bill,appointment	',
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_gateway_name` (`gateway_name`),
  KEY `index_module_type` (`module_type`),
  KEY `index_unique_id` (`unique_id`),
  KEY `online_appointment_id` (`online_appointment_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int DEFAULT NULL,
  `posted_data` text,
  `response` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_date` (`date`),
  KEY `index_call_duration` (`call_duration`),
  KEY `index_follow_up_date` (`follow_up_date`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (2, 'AMAN', '4556676546', '2024-09-30', '', NULL, '', '', 'Incoming', '2024-09-30 07:49:38');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (3, 'jaya', '4565766', '2024-10-10', '', '2024-10-10', '', '', 'Incoming', '2024-10-10 11:57:24');


#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_start_time` (`start_time`),
  KEY `index_end_time` (`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'Morning', '09:30:00', '13:30:00', '2024-09-26 07:15:31');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'Evening', '15:00:00', '18:00:00', '2024-09-26 07:15:57');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (3, 'night', '20:00:00', '23:00:00', '2024-09-27 09:15:56');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (4, 'night', '20:00:00', '23:00:00', '2024-09-27 09:15:56');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (5, 'morning2', '09:00:00', '12:00:00', '2024-09-27 09:17:41');


#
# TABLE STRUCTURE FOR: google_authenticator
#

DROP TABLE IF EXISTS `google_authenticator`;

CREATE TABLE `google_authenticator` (
  `id` int NOT NULL AUTO_INCREMENT,
  `use_authenticator` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `google_authenticator` (`id`, `use_authenticator`, `created_at`) VALUES (1, 1, '2024-09-30 12:34:50');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int NOT NULL AUTO_INCREMENT,
  `inc_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `generated_by` int DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_name` (`name`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_date` (`date`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (2, 1, 'opd', '', '2024-09-30', '3000.00', '', 'no', NULL, 7, 'yes', '2024-10-05 08:27:22');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (3, 1, 'ajay', '', '2024-10-05', '20000.00', '', 'no', NULL, 7, 'yes', '2024-10-05 08:26:39');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (4, 2, 'medical income soruce', '', '2024-10-11', '20000.00', '', 'no', NULL, 1, 'yes', '2024-10-11 11:59:51');


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_income_category` (`income_category`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Opd income', 'hospital', 'yes', 'no', '2024-10-11 12:03:29');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Ipd income', '', 'yes', 'no', '2024-10-11 12:03:08');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Medical income', '', 'yes', 'no', '2024-10-07 12:08:33');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Pathology income', 'Pathology income', 'yes', 'no', '2024-10-11 12:02:51');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` int DEFAULT NULL,
  `bed_group_id` int DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` longtext NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int DEFAULT NULL,
  `organisation_id` int DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `is_antenatal` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed` (`bed`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_6` FOREIGN KEY (`bed`) REFERENCES `bed` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (2, 3, 9, NULL, NULL, '', '', '', NULL, 3, 3, '', 'No', '', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-09-28 13:38:00', 'no', 'no', 1, 1, '2024-09-28 08:08:25');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (3, 5, 23, NULL, NULL, '', '', '', NULL, 2, 2, '', 'No', 'Constant or severe abdominal pain\r\nDiseases that affect the digestive system can also cause chronic abdominal pain. The most common are: gastroesophageal reflux disease (GERD) irritable bowel syndrome or spastic colon.', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-10-01 10:06:00', 'no', 'no', 1, 1, '2024-10-01 04:36:56');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (4, 7, 26, NULL, NULL, '', '', '', NULL, 4, 2, '', 'No', '', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-10-08 13:19:00', 'no', 'no', 1, NULL, '2024-10-08 07:50:31');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int NOT NULL,
  `consult_doctor` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `attachment_name` text NOT NULL,
  `header_note` text,
  `footer_note` text,
  `finding_description` text,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int DEFAULT NULL,
  `prescribe_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_date` (`date`),
  KEY `prescribe_by` (`prescribe_by`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_4` FOREIGN KEY (`prescribe_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (1, NULL, 2, '', '', '', '', '', 'yes', '2024-09-26', 1, 2, '2024-09-26 13:06:21');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (2, NULL, 5, '', '', '', '', '', 'yes', '2024-09-27', 1, 2, '2024-09-27 10:11:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (3, NULL, 6, '', '', '', '', ' ', 'yes', '2024-09-27', 1, 2, '2024-09-27 12:41:00');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (4, NULL, 7, '', '', '', '', '', 'yes', '2024-09-28', 1, 2, '2024-09-28 07:11:02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (5, NULL, 9, '', '', '', '', '', 'yes', '2024-09-28', 1, 2, '2024-09-28 07:30:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (6, 2, NULL, '', '', '', '', ' ', 'yes', '2024-09-28', 1, 2, '2024-09-28 10:33:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (7, NULL, 1, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-09-30', 1, 2, '2024-09-30 04:40:45');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (15, 3, NULL, '', '', '', '', '', 'yes', '2024-10-01', 1, 2, '2024-10-01 11:19:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (16, 3, NULL, '', '', '', '', '', 'yes', '2024-10-01', 1, 2, '2024-10-01 11:19:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (17, NULL, 25, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-08', 1, 2, '2024-10-08 08:02:38');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (18, NULL, 27, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-08', 1, 2, '2024-10-08 10:41:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (19, NULL, 30, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-10-09', 1, 2, '2024-10-09 08:34:00');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (20, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (21, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:24');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (22, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:26');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (23, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (24, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (25, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (26, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (27, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (28, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (29, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (30, 4, NULL, '', '', '', '', 'fever\r\n ', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:11:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (31, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:21:50');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `basic_id` int DEFAULT NULL,
  `pharmacy_id` int DEFAULT NULL,
  `dosage` int DEFAULT NULL,
  `dose_interval_id` int DEFAULT NULL,
  `dose_duration_id` int DEFAULT NULL,
  `instruction` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_dosage` (`dosage`),
  KEY `index_dose_interval_id` (`dose_interval_id`),
  KEY `index_dose_duration_id` (`dose_duration_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_3` FOREIGN KEY (`dose_interval_id`) REFERENCES `dose_interval` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_4` FOREIGN KEY (`dose_duration_id`) REFERENCES `dose_interval` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (1, 1, 1, 1, 1, 1, '', '2024-09-26 13:06:21');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (2, 2, 1, 1, 1, 1, '', '2024-09-27 10:11:54');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (3, 3, 1, 1, 1, 1, '', '2024-09-27 12:28:04');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (4, 4, 1, 1, 1, 1, '', '2024-09-28 07:11:02');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (5, 5, 1, 1, 1, 1, '', '2024-09-28 07:30:37');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (6, 6, 1, 1, 1, 1, '', '2024-09-28 10:33:25');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (7, 7, 1, 1, 1, 1, 'dsf', '2024-09-30 04:40:45');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (15, 15, 1, 1, 1, NULL, '', '2024-10-01 11:19:23');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (16, 16, 1, 1, 1, NULL, '', '2024-10-01 11:19:43');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (17, 17, 1, 1, 1, 1, '', '2024-10-08 08:02:38');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (18, 18, 1, 1, 1, 1, '', '2024-10-08 10:41:57');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (19, 19, 1, 1, 1, 1, '', '2024-10-09 08:34:00');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (20, 20, 1, 1, 1, NULL, '', '2024-10-09 09:59:19');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (21, 21, 1, 1, 1, NULL, '', '2024-10-09 09:59:24');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (22, 22, 1, 1, 1, NULL, '', '2024-10-09 09:59:26');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (23, 23, 1, 1, 1, NULL, '', '2024-10-09 09:59:37');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (24, 24, 1, 1, 1, NULL, '', '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (25, 25, 1, 1, 1, NULL, '', '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (26, 26, 1, 1, 1, NULL, '', '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (27, 27, 1, 1, 1, NULL, '', '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (28, 28, 1, 1, 1, NULL, '', '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (29, 29, 1, 1, 1, NULL, '', '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (30, 30, 1, 1, 1, NULL, '', '2024-10-09 10:04:34');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (31, 31, 1, 1, 2, NULL, '', '2024-10-09 10:21:50');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int DEFAULT NULL,
  `pathology_id` int DEFAULT NULL,
  `radiology_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (9, 17, 3, NULL, '2024-10-08 08:02:38');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (10, 18, 4, NULL, '2024-10-08 10:41:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (11, 19, 3, NULL, '2024-10-09 08:34:00');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (12, 19, NULL, 2, '2024-10-09 08:34:00');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (13, 20, 3, NULL, '2024-10-09 09:59:19');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (14, 20, NULL, 2, '2024-10-09 09:59:19');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (15, 21, 3, NULL, '2024-10-09 09:59:24');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (16, 21, NULL, 2, '2024-10-09 09:59:24');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (17, 22, 3, NULL, '2024-10-09 09:59:26');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (18, 22, NULL, 2, '2024-10-09 09:59:26');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (19, 23, 3, NULL, '2024-10-09 09:59:37');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (20, 23, NULL, 2, '2024-10-09 09:59:37');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (21, 24, 4, NULL, '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (22, 24, NULL, 2, '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (23, 25, 4, NULL, '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (24, 25, NULL, 2, '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (25, 26, 4, NULL, '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (26, 26, NULL, 2, '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (27, 27, 4, NULL, '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (28, 27, NULL, 2, '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (29, 28, 4, NULL, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (30, 28, NULL, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (31, 29, 4, NULL, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (32, 29, NULL, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (33, 30, 4, NULL, '2024-10-09 10:04:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (34, 30, NULL, 2, '2024-10-09 10:04:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (35, 31, 3, NULL, '2024-10-09 10:21:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (36, 31, NULL, 2, '2024-10-09 10:21:50');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category_id` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `description` text,
  `quantity` int NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `index_name` (`name`),
  KEY `index_unit` (`unit`),
  KEY `index_quantity` (`quantity`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (1, 1, 'cotton', '20-30', NULL, '', 0, NULL, '2024-09-30 13:00:45');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (2, 3, 'injection', '20', NULL, '', 0, NULL, '2024-10-05 09:09:44');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (3, 2, 'dr.OT dress', '10', NULL, '', 0, NULL, '2024-10-11 12:44:21');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (4, 4, 'All OT items', '50', NULL, '', 0, NULL, '2024-10-11 12:50:22');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (5, 5, 'All types are glopes', '50', NULL, '', 0, NULL, '2024-10-11 12:51:14');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_category` (`item_category`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'cotten', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'DR.drees', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (3, 'sirenge', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (4, 'equipment', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (5, 'hand glapes', 'yes', '', '2024-10-07 12:14:02');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `issue_type` int DEFAULT NULL,
  `issue_to` int DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `quantity` int NOT NULL,
  `note` text,
  `is_returned` int NOT NULL DEFAULT '1',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `index_issue_date` (`issue_date`),
  KEY `index_return_date` (`return_date`),
  KEY `index_quantity` (`quantity`),
  KEY `index_is_returned` (`is_returned`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (1, 9, 4, 'Super Admin', '2024-10-02', '2024-10-05', 1, 1, 0, '', 0, 'no', '2024-10-05 09:04:39');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (2, 3, 8, 'Super Admin', '2024-10-11', '2024-10-12', 2, 3, 1, '', 1, 'no', '2024-10-11 12:57:52');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT '0.00',
  `date` date DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `description` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (1, 1, 1, '+', NULL, 5, '100.00', '2024-09-30', NULL, '', 'yes', '2024-09-30 13:03:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (2, 1, 1, '+', 1, 11, '40.00', '2024-10-05', NULL, '', 'yes', '2024-10-05 09:03:32');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (3, 1, 1, '+', 1, 30, '5.00', '2024-10-11', NULL, '', 'yes', '2024-10-11 12:51:56');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (4, 3, 2, '+', 2, 9, '200.00', '2024-10-11', NULL, '', 'yes', '2024-10-11 12:52:34');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (5, 4, 2, '+', 2, 10, '1000.00', '2024-10-11', NULL, '', 'yes', '2024-10-11 12:53:14');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_store` (`item_store`),
  KEY `index_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'hospital store', '12345', 'abelible', '2024-09-30 12:57:14');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'medicine store', '123', '', '2024-10-05 09:14:30');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_supplier` (`item_supplier`),
  KEY `index_phone` (`phone`),
  KEY `index_email` (`email`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`),
  KEY `index_contact_person_email` (`contact_person_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (1, 'ashok supllier', '54566756567', '', '', '45756677867', '', '', '', '2024-09-30 12:57:48');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (2, 'pharma pvt. lmt', '78895789768', '', '', '413573567', '', '', '', '2024-10-05 09:17:28');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'X-Rays (Conventional Radiology)', '2024-09-27 11:41:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'Mastology (Mammography)', '2024-09-27 11:41:47');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (3, 'Angiography', '2024-09-27 11:42:10');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (4, 'CT Scan', '2024-09-27 11:42:33');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (5, 'M. R. C. P.', '2024-09-27 11:43:07');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (6, 'XRAY', '2024-10-08 10:55:25');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_language` (`language`),
  KEY `index_short_code` (`short_code`),
  KEY `index_country_code` (`country_code`),
  KEY `index_is_deleted` (`is_deleted`),
  KEY `index_is_rtl` (`is_rtl`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb3;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 09:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 10:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 09:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 05:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 09:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 10:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 06:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 06:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 06:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 06:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 06:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 06:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 06:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 06:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 06:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 06:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 06:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 06:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 06:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 06:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 06:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 06:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 06:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 06:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 06:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 06:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 06:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 06:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 06:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 06:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 06:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 06:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 06:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 06:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 06:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 07:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 07:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 07:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 07:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 07:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 07:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 07:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 07:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 07:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 07:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 07:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 07:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 07:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 07:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 07:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 07:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 07:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 07:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 07:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 07:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 07:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 07:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 07:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 07:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 07:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 07:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 07:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 07:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 07:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 07:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 07:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 07:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 07:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 07:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 07:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 07:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 07:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 07:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 06:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 07:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 07:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 07:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (1, 'Medical ', 'yes', '2024-09-26 07:19:20');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (2, 'Casual', 'yes', '2024-09-26 07:19:26');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (3, 'deparmental leave', 'yes', '2024-09-30 11:07:26');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (4, 'mendetary leave', 'yes', '2024-09-30 11:17:25');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (5, 'meternity leave', 'yes', '2024-10-07 12:09:31');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (6, 'Sick leave', 'yes', '2024-10-11 10:26:23');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `record_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1224 DEFAULT CHARSET=utf8mb3;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 05:34:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated For Menu Item id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 05:35:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record deleted On Front Cms Page Contents id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 07:07:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Front Cms Pages id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 07:07:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'New Record inserted On Charge Units id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'New Record inserted On Charge Units id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On Charge Units id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On Charge Units id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On Charge Units id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On Charge Units id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:46', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On Tax Category id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:06', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On Tax Category id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:16', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On Charge Categories id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:43', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On Charge Categories id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'New Record inserted On Charge Categories id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On Charge Categories id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:22', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'New Record inserted On Charge Categories id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:35', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'New Record inserted For Organisation id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:11:03', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted For Organisation id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:11:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'Record updated On Tax Category id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:12:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record updated On Tax Category id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:13:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On Global Shift id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:15:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On Global Shift id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:15:57', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On Specialist id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On Specialist id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:47', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On Specialist id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Specialist id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:22', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'New Record inserted On Staff Designation id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On Staff Designation id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On Staff Designation id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:49', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'New Record inserted On Staff Designation id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On Staff Designation id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'New Record inserted On Staff Designation id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'New Record inserted On Department id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On Department id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On Department id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:53', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On Department id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'New Record inserted On Department id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On Leave Types id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:20', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On Leave Types id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:28:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:29:52', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Shift Details id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:56', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'New Record inserted On Patient id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:36:51', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated On Patient id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:36:51', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On Appointment Created 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:37:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On Ambulance id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:39:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On Ambulance id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:40:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On Transactions id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:40:24', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted For Blood Donor id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:47:57', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted For Blood Donor id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:18', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Read System Notification id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'New Record inserted On Read System Notification id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:27', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On Read System Notification id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:28', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Read System Notification id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:32', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'New Record inserted For Blood Donor id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Blood Donor  id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On Transactions id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On Blood Donor  id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Transactions id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On Blood Donor  id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'New Record inserted On Transactions id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On Blood Donor  id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On Transactions id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:37', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On Blood Donor  id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On Transactions id 7', 7, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Transactions id 8', 8, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:51:28', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Blood Donor  id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On Blood Donor  id 7', 7, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Transactions id 9', 9, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'Record updated On Settings id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 08:03:43', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 08:09:54', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 08:10:16', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted For Blood Donor id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:43:32', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On Blood Donor  id 8', 8, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:44:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Transactions id 10', 10, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:44:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:28:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:30:55', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:37:12', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:13:20', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:13:34', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Patient id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:22:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:22:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:24:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On Transactions id 11', 11, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:24:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On Read System Notification id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:37:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On Read System Notification id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:01', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On Read System Notification id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:04', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On Read System Notification id 8', 8, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Read System Notification id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'Record updatedOn Appointment Updated 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:41:48', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:08:06', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:12:04', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:02', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On Read System Notification id 10', 10, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On Read System Notification id 11', 11, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:37', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On Read System Notification id 12', 12, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:14:11', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted On Floor id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:30:24', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On Bed Group id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:30:46', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On Bed id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:31:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On IPD id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On Bed id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On Patient bed history id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On Medicine Category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:34:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'New Record inserted On Medicine Supplier id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:36:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On Unit id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:02', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On Unit id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:14', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On Unit id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On Dose Interval id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On Medicine Dosage id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:54', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On Company id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:38:10', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On medicine group id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:38:53', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'New Record inserted On Dose Duration id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:46:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'New Record inserted On Staff Attendance id 1', 1, 0, 'Insert', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:17:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'New Record inserted On Staff Attendance id 2', 2, 0, 'Insert', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:17:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record updated On Transactions id 11', 11, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:33:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated On Visit Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:33:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'New Record inserted On Pharmacy id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:35:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'New Record inserted On Ipd Prescription Basic id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:36:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'New Record inserted On Duty Roster Shift id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:26:13', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On Duty Roster Shift id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:26:48', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'New Record inserted On Duty Roster Shift id3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'New Record inserted On Duty Roster Shift id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'New Record inserted On Duty Roster Shift id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On duty_roster_assign id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'New Record inserted On duty_roster_assign id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted On duty_roster_assign id3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On duty_roster_assign id4', 4, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'New Record inserted On duty_roster_assign id5', 5, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On duty_roster_assign id6', 6, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On duty_roster_assign id7', 7, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record updated On Patient id card id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:21:39', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'Record updated On Staff id card id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:22:04', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:24:10', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:24:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:26:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:09:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:33:13', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:33:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:41:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'New Record inserted On Global Shift id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:45:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On Global Shift id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:45:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On Global Shift id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:47:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On Shift Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:48:20', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On Shift Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:52:30', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'New Record inserted On Appointment Created 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:59:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'New Record inserted On Staff Timeline id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:00:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'Record updated On Staff Timeline id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:00:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Appointment Created 3', 3, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 15:16:06', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record deleted On Appointment Deleted id 2', 2, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:17:32', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updatedOn Appointment Updated 3', 3, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:17:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On Transactions id 14', 14, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:18:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'New Record inserted On  holiday master  id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:19:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On  holiday master  id 2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:19:39', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record updated On Transactions id 14', 14, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:20:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'Record updated On Visit Details id 5', 5, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:20:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On Pathology Category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:22:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On Pathology Category id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:22:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On Pathology Category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:23:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On Unit id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:24:36', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On Pathology Parameter id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:26:16', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On Pathology Parameter id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:28:02', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On Ipd Prescription Basic id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:41:54', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On Read System Notification id 13', 13, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:46:53', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On Charge Categories id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:51:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On pathology Test id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:53:57', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On pathology Test id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:55:06', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On pathology Test id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:02:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record deleted On  Pathology Test  id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:02:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On Lab id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:11:12', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On Lab id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:11:47', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On Lab id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:12:10', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'New Record inserted On Lab id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:12:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On Lab id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:13:07', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'New Record inserted On Unit id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:13:55', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On Unit id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:03', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record updated On Unit id 6', 6, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'Record deleted On Unit id 6', 6, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:19', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On Unit id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:42', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On Unit id 8', 8, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:15:16', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On Radiology Parameter id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:16:45', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On Radiology Parameter id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:17:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'New Record inserted On Charge Categories id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:23:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On Tax Category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:25:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On Radio id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:35:35', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'New Record inserted On Radiology Billing id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:38:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record inserted On Transactions id 15', 15, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:38:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On Blood Donor  id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:42:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On Transactions id 16', 16, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:42:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On Blood Donor  id 10', 10, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:43:44', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On Blood Donor  id 11', 11, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:43:44', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Payment Settings id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:50:42', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On Transactions id 17', 17, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:52:58', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'Record deleted On Transactions id 17', 17, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:53:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On Transactions id 18', 18, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:54:36', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'Record updated On Transactions id 14', 14, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:22', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated On Visit Details id 5', 5, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:23', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On Transactions id 19', 19, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On Visit Details id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On Ipd Prescription Basic id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:04', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updated On Transactions id 19', 19, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On Visit Details id 6', 6, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On Staff Attendance id 3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Firefox 130.0', '2024-09-27 18:06:47', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On Transactions id 20', 20, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:45', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record deleted On Transactions id 18', 18, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:49', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'Record deleted On Transactions id 20', 20, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:52', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On Transactions id 21', 21, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:15:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On Transactions id 22', 22, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:24:05', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:39:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On Transactions id 23', 23, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:39:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On Ipd Prescription Basic id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:41:02', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'Record updated On Transactions id 23', 23, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'Record updated On Visit Details id 7', 7, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'Record deleted On  OPD  id 6', 6, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On Transactions id 24', 24, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:43:50', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:43:50', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On Radiology Billing id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:53:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On Transactions id 25', 25, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:53:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On Transactions id 26', 26, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On Visit Details id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On Ipd Prescription Basic id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated On Transactions id 26', 26, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated On Visit Details id 9', 9, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On Medication Report id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:01:27', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On Radiology Billing id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:12:49', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On Medication Report id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:17:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated On Medication Report id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:17:56', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'Record deleted On  Medication Report  id 2', 2, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:18:21', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On  content_types id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On operation_category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On  upload_contents id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On  upload_contents id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On operation_category id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On operation_category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'New Record inserted On  upload_contents id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'Record deleted On upload_contents id 1', 1, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record deleted On upload_contents id 1', 1, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:21', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'Record deleted On upload_contents id 2', 2, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'Record deleted On upload_contents id 2', 2, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On operation_category id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On Operation id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:24:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On Operation id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:24:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On Operation id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:25:29', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On Operation Theatre id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated On Operation Theatre id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'Record deleted On  Operation Theatre  id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:51', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On Operation Theatre id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'Record updated On Patient Charges id 8', 8, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:31', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'Record updated On Patient Charges id 8', 8, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated On Transactions id 24', 24, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '152.58.57.96', 'Android', 'Chrome 128.0.0.0', '2024-09-28 13:29:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'New Record inserted On Patient Timeline id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:31:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On Bed Group id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:06', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'New Record inserted On Floor id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'New Record inserted On Bed Group id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On Bed id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:37:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On Bed id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:37:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On Patient id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'Record updated On Patient id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated On Patient id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On IPD id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On Bed id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On Patient bed history id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On Custom Fields id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:39:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'Record updated On Custom Field Values id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:41:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On Custom Fields id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:42:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:06', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'Record updated On Custom Field Values id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Custom Field Values id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'New Record inserted On  upload_contents id 4', 4, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:28:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On  upload_contents id 5', 5, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:30:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record deleted On upload_contents id 5', 5, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:32:54', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'Record deleted On upload_contents id 4', 4, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:34:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On  upload_contents id 6', 6, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:34:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'Record deleted On upload_contents id 6', 6, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:35:49', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On  upload_contents id 7', 7, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On  upload_contents id 8', 8, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'New Record inserted On  upload_contents id 9', 9, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On  upload_contents id 10', 10, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On  upload_contents id 11', 11, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'Record deleted On upload_contents id 11', 11, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'Record deleted On upload_contents id 9', 9, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:44:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'Record deleted On upload_contents id 8', 8, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:44:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record deleted On upload_contents id 7', 7, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:48:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On  upload_contents id 12', 12, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'New Record inserted On  upload_contents id 13', 13, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:29', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On  upload_contents id 14', 14, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On  upload_contents id 15', 15, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On  upload_contents id 16', 16, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:42', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'New Record inserted On  upload_contents id 17', 17, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'New Record inserted On  upload_contents id 18', 18, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:52', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record deleted On upload_contents id 15', 15, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:53:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record deleted On upload_contents id 16', 16, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:54:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On  upload_contents id 19', 19, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:54:58', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On  upload_contents id 20', 20, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'New Record inserted On  upload_contents id 21', 21, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On  upload_contents id 22', 22, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:51', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On  upload_contents id 23', 23, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:00', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'Record deleted On upload_contents id 20', 20, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'New Record inserted On  upload_contents id 24', 24, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:27', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record updated On Patient Timeline id 1', 1, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:08', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'Record updated On Transactions id 24', 24, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:35', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated On Visit Details id 8', 8, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:35', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record deleted On upload_contents id 24', 24, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:59:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'Record deleted On upload_contents id 22', 22, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:59:53', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On  upload_contents id 25', 25, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:00', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On  upload_contents id 26', 26, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On  upload_contents id 27', 27, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:08', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On  upload_contents id 28', 28, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'New Record inserted On  upload_contents id 29', 29, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On  upload_contents id 30', 30, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'Record updated On Transactions id 24', 24, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On Visit Details id 8', 8, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On  upload_contents id 31', 31, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On  upload_contents id 32', 32, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On  upload_contents id 33', 33, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On  upload_contents id 34', 34, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'New Record inserted On  upload_contents id 35', 35, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:44', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'Record deleted On upload_contents id 26', 26, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:54', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:03:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On  upload_contents id 36', 36, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:03:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'Record updated On Radiology Report id 2', 2, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:04:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'Record updated On Bed id 1', 1, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:08:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'Record updated On IPD id 1', 1, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:08:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'Record updated On Patient id 2', 2, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:08:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On  upload_contents id 37', 37, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:08:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On Medication Report id 3', 3, 0, 'Insert', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:09:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'New Record inserted On Front Cms Media Gallery id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:20:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:20:44', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'Record updated For Staff Attendance id 4', 4, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:23:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'New Record inserted On  upload_contents id 38', 38, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:24:28', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:25:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'New Record inserted On  upload_contents id 39', 39, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:29:24', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'New Record inserted On  upload_contents id 40', 40, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:32:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:32:31', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:33:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:33:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'New Record inserted On Payment Settings id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:35:03', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'Record updated On Patient id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:35:31', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:36:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On Medication Report id 4', 4, 0, 'Insert', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:50:00', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'New Record inserted On  upload_contents id 41', 41, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:01:50', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'New Record inserted On  upload_contents id 42', 42, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:01:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On Ipd Prescription Basic id 6', 6, 0, 'Insert', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:03:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On  upload_contents id 43', 43, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:04:04', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'New Record inserted On  upload_contents id 44', 44, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:04:13', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted On  upload_contents id 45', 45, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:04:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'New Record inserted On Appointment Created 6', 6, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:06:33', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'New Record inserted On Appointment Created 7', 7, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:06:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'New Record inserted On Appointment Created 8', 8, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:07:14', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'New Record inserted On Appointment Created 9', 9, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:07:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'New Record inserted On Appointment Created 10', 10, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:07:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'New Record inserted On Appointment Created 11', 11, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:07:48', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'New Record inserted On Operation Theatre id 3', 3, 0, 'Insert', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:12:44', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'New Record inserted On Appointment Created 12', 12, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:14:53', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'New Record inserted On Appointment Created 13', 13, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:17:44', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On Appointment Created 14', 14, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:19:20', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'New Record inserted On Appointment Created 15', 15, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:19:56', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'New Record inserted On Appointment Created 16', 16, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:20:24', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '152.58.57.96', 'Android', 'Chrome 128.0.0.0', '2024-09-28 16:28:04', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:31:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record deleted On Appointment Deleted id 5', 5, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:31:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'New Record inserted On Custom Fields id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:55:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'Record updated On Custom Field Values id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:57:33', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On Custom Field Values id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:57:33', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'New Record inserted On Custom Field Values id 4', 4, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 16:57:33', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'Record updatedOn Appointment Updated 7', 7, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:05:29', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'Record updatedOn Appointment Updated 7', 7, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:09:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:25:24', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:28:47', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'Record updated On Print Setting id 20', 20, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:31:53', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'Record updated On Print Setting id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:31:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'Record updated On Print Setting id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:32:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'Record updated On Print Setting id 4', 4, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:32:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'Record updated On Print Setting id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:32:20', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'New Record inserted On Staff Attendance id 6', 6, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:41:31', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'Record updated For Staff Attendance id 6', 6, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:41:53', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'New Record inserted On Transactions id 39', 39, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:42:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'Record updated On Transactions id 39', 39, 0, 'Update', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:42:54', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'Record deleted On Transactions id 39', 39, 0, 'Delete', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:42:59', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'Record updated For Staff Attendance id 6', 6, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:47:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'New Record inserted On Custom Fields id 4', 4, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:52:56', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'Record updated On Custom Fields id 4', 4, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:53:08', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'New Record inserted On Radiology Billing id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:54:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On Transactions id 40', 40, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:54:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'New Record inserted On Transactions id 41', 41, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:57:24', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'New Record inserted On Patient Timeline id 2', 2, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:58:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'Record updated Change Password For Staff id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 17:59:14', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:00:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'New Record inserted On  holiday master  id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:01:20', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'Record updated On  holiday master id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:01:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On duty_roster_assign id8', 8, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'New Record inserted On duty_roster_assign id9', 9, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'New Record inserted On duty_roster_assign id10', 10, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted On duty_roster_assign id11', 11, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On duty_roster_assign id12', 12, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On duty_roster_assign id13', 13, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'New Record inserted On duty_roster_assign id14', 14, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:02:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On duty_roster_assign id15', 15, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'New Record inserted On duty_roster_assign id16', 16, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'New Record inserted On duty_roster_assign id17', 17, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'New Record inserted On duty_roster_assign id18', 18, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'New Record inserted On duty_roster_assign id19', 19, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'New Record inserted On duty_roster_assign id20', 20, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'New Record inserted On duty_roster_assign id21', 21, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On Duty Roster Shift id3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:03:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'New Record inserted On Read System Notification id 14', 14, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:09:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'New Record inserted On Read System Notification id 15', 15, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:09:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'Record updated On Custom Fields id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:13:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'New Record inserted On Transactions id 42', 42, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:17:10', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'Record deleted On Transactions id 42', 42, 0, 'Delete', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:17:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'Record updated For Ambulance Call id 2', 2, 0, 'Update', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:17:51', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'New Record inserted On Transactions id 43', 43, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:19:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'Record updated For Ambulance id 1', 1, 0, 'Update', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:19:47', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'Record deleted Where Ambulance id 1', 1, 0, 'Delete', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:19:56', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'New Record inserted On Ambulance id 3', 3, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:20:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On Income Head id 1', 1, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:22:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'New Record inserted On Expense Head id 1', 1, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:22:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'New Record inserted On Income id 1', 1, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:23:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'New Record inserted On Expenses id 1', 1, 0, 'Insert', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:23:38', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'Record updated On  upload_contents id 45', 45, 0, 'Update', '182.70.153.173', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 18:26:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'New Record inserted On Finding Category id 1', 1, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:06:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'New Record inserted On Finding Category id 2', 2, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:06:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'New Record inserted On Finding Category id 3', 3, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:06:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'New Record inserted On Finding Category id 4', 4, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:06:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'New Record inserted On Finding id 1', 1, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:07:15', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On Finding id 2', 2, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:07:44', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'New Record inserted On Finding id 3', 3, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:08:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'New Record inserted On Finding id 4', 4, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:08:19', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'New Record inserted On Symptoms Classification id 1', 1, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:08:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On Symptoms Classification id 2', 2, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:08:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'New Record inserted On Symptoms Classification id 3', 3, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:08:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'New Record inserted On Symptoms id 1', 1, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:09:28', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'New Record inserted On Symptoms id 2', 2, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:09:48', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On Symptoms id 3', 3, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:10:06', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'New Record inserted On Ipd Prescription Basic id 7', 7, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:10:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On Transactions id 44', 44, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:11:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record updated For Staff id 5', 5, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:20:17', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'Record updated On Pathology Report id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:20:30', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'Record updated On Email Config id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:30:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'Record updated On Patient id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:30:40', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'Record updated On Notification Setting id 5', 5, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 10:41:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'Record updated On Settings id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 10:51:09', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'Record updated On Patients id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 10:56:20', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'Record updated On Print Setting id 19', 19, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:19:39', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'Record updated On Print Setting id 17', 17, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:19:44', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'Record updated On Print Setting id 18', 18, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:19:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'Record updated On Print Setting id 16', 16, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:19:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'Record updated On Print Setting id 15', 15, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:01', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'Record updated On Print Setting id 14', 14, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'Record updated On Print Setting id 13', 13, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:12', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'Record updated On Print Setting id 12', 12, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:16', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'Record updated On Print Setting id 11', 11, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:21', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'Record updated On Print Setting id 10', 10, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'Record updated On Print Setting id 9', 9, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:32', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'Record updated On Print Setting id 8', 8, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:37', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'Record updated On Print Setting id 7', 7, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:41', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On Print Setting id 6', 6, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'Record updated On Print Setting id 5', 5, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:20:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'New Record inserted On Supplier Bill Basic id 1', 1, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:22:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On Staff Attendance id 7', 7, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 11:29:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'New Record inserted On Staff Attendance id 8', 8, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 11:29:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'New Record inserted On Staff Attendance id 9', 9, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 11:29:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'New Record inserted On Staff Attendance id 10', 10, 0, 'Insert', '1.23.234.222', 'Windows 10', 'Firefox 130.0', '2024-09-30 11:29:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'Record updated On Custom Fields id 1', 1, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:54:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:55:02', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'Record updated On Custom Fields id 3', 3, 0, 'Update', '1.23.234.222', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 11:55:09', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'New Record inserted On Read System Notification id 16', 16, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:08', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'New Record inserted On Read System Notification id 17', 17, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'New Record inserted On Read System Notification id 18', 18, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:12', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On Read System Notification id 19', 19, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:15', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'New Record inserted On Read System Notification id 20', 20, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:16', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'New Record inserted On Read System Notification id 21', 21, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:48:17', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'New Record inserted On Transactions id 45', 45, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:49:29', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'Record deleted On Transactions id 43', 43, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:49:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'Record updated For Ambulance Call id 3', 3, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:50:58', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'Record deleted Where Ambulance Call id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:51:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'Record updated For Staff Attendance id 7', 7, 0, 'Update', '152.59.48.143', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:55:24', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'New Record inserted On Appointment Created 18', 18, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:55:29', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'Record updated On Custom Field Values id 15', 15, 0, 'Update', '152.59.49.226', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:57:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'Record updated On Custom Field Values id 16', 16, 0, 'Update', '152.59.49.226', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:57:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'Record updated On Custom Field Values id 17', 17, 0, 'Update', '152.59.49.226', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:57:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'Record updated For Staff id 6', 6, 0, 'Update', '152.59.48.143', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 12:58:11', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '152.58.57.96', 'Android', 'Chrome 128.0.0.0', '2024-09-30 12:58:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'Record updated For Ambulance id 3', 3, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:01:25', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'New Record inserted On Visitors Purpose id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:10:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On complaint_type id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:11:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'New Record inserted On Visitors Book id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:14:53', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'Record updated On Visitors Book id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:15:23', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On Visitors Book id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:15:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On General Calls id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:17:59', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'Record updated On General Calls id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:18:38', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'Record deleted On General Calls id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:18:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On General Calls id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:19:38', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'New Record inserted On dispatch_receive id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 13:20:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On dispatch_receive id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:22:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'Record updated On dispatch_receive id 2', 2, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:23:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'New Record inserted On Complaint id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:24:33', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'New Record inserted On Birth Report id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:45:21', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'Record updated For Birth Report id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:45:21', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'Record updated For Birth Report id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:46:14', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'Record deleted Where Birth Report  id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:46:24', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'New Record inserted On Birth Report id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:46:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'Record updated For Birth Report id 2', 2, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 14:46:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'New Record inserted On Death Report id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:12', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'Record updated On Patient id 2', 2, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:12', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'Record updated For Death Report id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:41', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'New Record inserted On Patient id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:41', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'Record deleted Where Death Report  id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:47', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On Death Report id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:56', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'Record updated On Patient id 2', 2, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:12:56', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:14:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:14:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:14:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:14:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '27.57.143.112', 'Android', 'Chrome 124.0.0.0', '2024-09-30 15:20:28', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'Record updated For Staff Attendance id 9', 9, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:23:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On Staff Payslip id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:24:09', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'New Record inserted On Payslip Allowance id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:24:09', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On Payslip Allowance id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:24:09', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'New Record inserted On Blood Donor  id 12', 12, 0, 'Insert', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:36:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On Transactions id 47', 47, 0, 'Insert', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:36:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'Record deleted On upload_contents id 36', 36, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:37:38', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'Record deleted On upload_contents id 42', 42, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:37:43', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'Record deleted On upload_contents id 45', 45, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:37:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'Record deleted On upload_contents id 44', 44, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:37:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'Record deleted On upload_contents id 43', 43, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:37:54', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'Record deleted On upload_contents id 28', 28, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:01', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record deleted On upload_contents id 41', 41, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:06', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'Record deleted On upload_contents id 39', 39, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:08', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'Record deleted On upload_contents id 37', 37, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:11', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'Record deleted On upload_contents id 38', 38, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:13', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'Record deleted On upload_contents id 27', 27, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:16', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'Record deleted On upload_contents id 33', 33, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:19', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'Record deleted On upload_contents id 40', 40, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:22', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'Record deleted On share_contents id 1', 1, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'Record deleted On share_contents id 2', 2, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:34', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'Record deleted On content_types id 1', 1, 0, 'Delete', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:38:39', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'New Record inserted On  content_types id 2', 2, 0, 'Insert', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:39:12', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'New Record inserted On  upload_contents id 46', 46, 0, 'Insert', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:39:25', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'Record updated On Captcha where name appointment', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:41:57', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'Record updated On Captcha where name userlogin', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:41:59', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'Record updated On Captcha where name userlogin', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:44:28', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'Record updated On Captcha where name appointment', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:44:30', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'Record updated On Captcha where name userlogin', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:47:48', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'Record updated On Captcha where name appointment', 0, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 15:47:51', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:23:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:23:38', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'New Record inserted On Medication Report id 5', 5, 0, 'Insert', '1.22.246.31', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:26:17', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On Leave Types id 3', 3, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:37:26', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'Record updated On Department id 5', 5, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:38:23', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'Record deleted On Department id 5', 5, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:38:29', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'New Record inserted On Department id 6', 6, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:38:44', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:42:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:42:07', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:42:47', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:42:47', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:44:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:44:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On Leave Types id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:47:25', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'Record updated For Staff id 6', 6, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:59:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'Record updated For Staff id 6', 6, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 16:59:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:00:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'Record updated For Staff id 4', 4, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:00:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'New Record inserted On  upload_contents id 47', 47, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:04:14', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'New Record inserted On  content_types id 3', 3, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:04:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'New Record inserted On  upload_contents id 48', 48, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:05:05', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'Record updated On Staff Payslip id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:10:38', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'Record updated On Staff payslip where id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:11:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'New Record inserted On System Notification id 236', 236, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:11:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On System Notification id 237', 237, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:11:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'Record updated On Staff Payslip where id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:11:49', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'Record updated On Staff payslip where id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:12:00', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'New Record inserted On System Notification id 239', 239, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:12:00', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'New Record inserted On System Notification id 240', 240, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:12:00', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'New Record inserted On Duty Roster Shift id4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:15:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On Transactions id 48', 48, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:15:41', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'New Record inserted On Duty Roster Shift id4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:15:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'Record deleted Where Blood Issue id 7', 7, 0, 'Delete', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:15:55', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'New Record inserted On Blood Donor  id 13', 13, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'New Record inserted On Transactions id 49', 49, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'New Record inserted On duty_roster_assign id22', 22, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'New Record inserted On duty_roster_assign id23', 23, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'New Record inserted On Blood Donor  id 14', 14, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:33', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On Transactions id 50', 50, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:33', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On duty_roster_assign id24', 24, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On duty_roster_assign id25', 25, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'New Record inserted On duty_roster_assign id26', 26, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On duty_roster_assign id27', 27, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record inserted On duty_roster_assign id28', 28, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On duty_roster_assign id29', 29, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On duty_roster_assign id30', 30, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On Transactions id 51', 51, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:16:53', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'New Record inserted On Transactions id 52', 52, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:17:22', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On Transactions id 53', 53, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:17:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'New Record inserted On  holiday master  id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:18:17', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On Referral Category id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:22:33', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On Referral Category id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:22:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On Referral Commission id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'New Record inserted On Referral Commission id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On Referral Commission id 3', 3, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'New Record inserted On Referral Commission id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'New Record inserted On Referral Commission id 5', 5, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'New Record inserted On Referral Commission id 6', 6, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'New Record inserted On Referral Commission id 7', 7, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:31', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'New Record inserted On Referral Commission id 8', 8, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On Referral Commission id 9', 9, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'New Record inserted On Referral Commission id 10', 10, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'New Record inserted On Referral Commission id 11', 11, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On Referral Commission id 12', 12, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'New Record inserted On Referral Commission id 13', 13, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On Referral Commission id 14', 14, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:25:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'Record updated On Zoom Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:27:52', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'New Record inserted On Referral Person id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'New Record inserted On Referral Person Commission id 1', 1, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'New Record inserted On Referral Person Commission id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On Referral Person Commission id 3', 3, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On Referral Person Commission id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On Referral Person Commission id 5', 5, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'New Record inserted On Referral Person Commission id 6', 6, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On Referral Person Commission id 7', 7, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:29:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'New Record inserted On Menu Item id 5', 5, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:34:11', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'Record updated On Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:34:28', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:34:42', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:35:46', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:35:54', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:36:01', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:36:20', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:36:27', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'Record updated On Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:38:10', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted For Organisation id 3', 3, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:40:58', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record updated On  holiday master id 4', 4, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:46:04', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'Record updated On Organisation id 2', 2, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:46:14', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'Record deleted Where Organisation id 2', 2, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:46:21', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted For Organisation id 4', 4, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:46:44', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'Record updated For Income id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:50:33', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On Income id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:50:50', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'Record deleted Where Income  id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:51:01', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'New Record inserted On Expenses id 2', 2, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:51:41', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'Record updated On Expenses id 1', 1, 0, 'Update', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:52:53', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'Record deleted Where Expenses  id 1', 1, 0, 'Delete', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:53:36', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'New Record inserted On Expenses id 3', 3, 0, 'Insert', '27.57.143.112', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:53:51', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'Record updated On Zoom Settings id 1', 1, 0, 'Update', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 17:58:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'Record deleted On Appointment Deleted id 20', 20, 0, 'Delete', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:04:59', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'Record deleted On Appointment Deleted id 19', 19, 0, 'Delete', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:05:01', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'Record deleted On Appointment Deleted id 17', 17, 0, 'Delete', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:05:03', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'New Record inserted On Transactions id 54', 54, 0, 'Insert', '152.59.48.229', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:12:18', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'New Record inserted On Messages Send SMS id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:12:19', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On Messages Send Mail id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:19:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'New Record inserted On Item Category id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:26:40', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On Item Category id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:26:40', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On Item Category id 3', 3, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:26:40', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On Item Category id 4', 4, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:26:40', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'New Record inserted On Item Store id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:27:14', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On Item supplier id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:27:48', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'Record updated On Item supplier id 1', 1, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:27:59', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'Record updated For Item Store id 1', 1, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:28:19', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On Item id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:30:45', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On Item Stock id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:33:00', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On Item Issue id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-30 18:33:34', '2024-09-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'New Record inserted On Patient id 5', 5, 0, 'Insert', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:39', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'Record updated On Patient id 5', 5, 0, 'Update', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:39', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'Record updated On Patient id 5', 5, 0, 'Update', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:56', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On IPD id 3', 3, 0, 'Insert', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:56', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'Record updated On Bed id 2', 2, 0, 'Update', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:56', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On Patient bed history id 3', 3, 0, 'Insert', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:06:56', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'New Record inserted On Transactions id 55', 55, 0, 'Insert', '152.59.46.206', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 10:16:20', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'New Record inserted On Referral Payment id 1', 1, 0, 'Insert', '1.22.246.162', 'Windows 10', 'Firefox 130.0', '2024-10-01 12:45:14', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On Staff Leave Request Approve id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:48:11', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On Staff Leave Request Approve id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:48:11', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On Staff Leave Request Approve id 3', 3, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:48:11', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'Record updated For Staff id 5', 5, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:50:38', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'Record updated For Staff id 5', 5, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:50:38', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'Record updated For Staff id 6', 6, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:50:57', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'Record updated For Staff id 6', 6, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:50:57', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'Record updated Change Password For Staff id 4', 4, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:54:52', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'New Record inserted On Staff Leave Request Pending id 4', 4, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:55:38', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On Messages Send SMS id 3', 3, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:57:13', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On Messages Send SMS id 4', 4, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 12:58:25', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'New Record inserted On Read System Notification id 22', 22, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:08:00', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'New Record inserted On Read System Notification id 23', 23, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:08:04', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On  upload_contents id 49', 49, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:12:07', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'Record updated On  upload_contents id 47', 47, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:13:43', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On  content_types id 4', 4, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:15:09', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'Record updated On  content_types id 3', 3, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:16:02', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'Record deleted On content_types id 3', 3, 0, 'Delete', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:16:15', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On  content_types id 5', 5, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:16:34', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On  upload_contents id 50', 50, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:21:50', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'Record updated On Settings id 1', 1, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:23:37', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'New Record inserted On Referral Payment id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 13:27:32', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'New Record inserted On Certificates id 13', 13, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:03:35', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On Patient id card id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:37:33', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'Record updated On Patient id card id 2', 2, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:37:33', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On Staff id card id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:44:00', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'Record updated On Staff id card id 2', 2, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:44:00', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'Record updated On Staff id card id 2', 2, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:44:29', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'New Record inserted On Front Cms Pages id 6', 6, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:49:58', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'Record deleted On Front Cms Page Contents id 6', 6, 0, 'Delete', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:50:45', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'Record updated On Front Cms Pages id 6', 6, 0, 'Update', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:50:45', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'New Record inserted On Page events id 1', 1, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:56:43', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On Front Cms Media Gallery id 2', 2, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 14:58:39', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'New Record inserted On Page Menu id 3', 3, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 15:01:16', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record deleted Where Page Menu id 3', 3, 0, 'Delete', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 15:01:25', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On Page Menu id 4', 4, 0, 'Insert', '122.168.39.138', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-01 15:01:38', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On Ipd Prescription Basic id 10', 10, 0, 'Insert', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:37:53', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'Record deleted On Ipd Prescription Basic id 10', 10, 0, 'Delete', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:38:04', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'New Record inserted On Ipd Prescription Basic id 11', 11, 0, 'Insert', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:38:32', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'Record deleted On Ipd Prescription Basic id 11', 11, 0, 'Delete', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:38:44', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'New Record inserted On Ipd Prescription Basic id 15', 15, 0, 'Insert', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:49:23', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'New Record inserted On Ipd Prescription Basic id 16', 16, 0, 'Insert', '152.59.48.24', 'Windows 10', 'Firefox 130.0', '2024-10-01 16:49:43', '2024-10-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'Record updated For Staff id 7', 7, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:02:02', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'Record updated For Staff id 7', 7, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:03:23', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'Record updated For Staff id 7', 7, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:03:23', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updated Change Password For Staff id 7', 7, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:04:17', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:07:19', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:09:44', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:12:12', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:12:51', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:13:22', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:13:46', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:14:05', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:14:23', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:14:39', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:15:02', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:15:20', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:15:40', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:16:00', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:16:19', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:17:15', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:18:54', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:20:49', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:26:21', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:27:59', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:34:57', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 17:44:57', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 18:10:46', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 18:15:40', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 18:25:31', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-02 18:26:13', '2024-10-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'New Record inserted On Medication Report id 6', 6, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-03 14:29:47', '2024-10-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On Patient Timeline id 3', 3, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-03 15:10:49', '2024-10-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'New Record inserted On Patient Charges id 23', 23, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-03 15:26:12', '2024-10-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On Transactions id 56', 56, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-03 15:32:02', '2024-10-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'New Record inserted On Medication Report id 7', 7, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-03 17:13:59', '2024-10-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 13:02:27', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'Record updated On  medicine_batch_details id 1', 1, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 13:11:22', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'Record updated On  medicine_batch_details id 1', 1, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 13:30:13', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On Transactions id 57', 57, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 16:38:09', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On Death Report id 3', 3, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 17:41:56', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'Record updated On Patient id 5', 5, 0, 'Update', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 17:41:56', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On Staff Attendance id 13', 13, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 17:57:06', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'New Record inserted On Staff Payslip id 2', 2, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:06:28', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On Staff Payslip id 3', 3, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:09:18', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On Payslip Allowance id 3', 3, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:09:18', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On Payslip Allowance id 4', 4, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:09:18', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'Record deleted On Staff Payslip where id ', 3, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:10:34', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'Record deleted On Payslip Allowance id ', 3, 0, 'Delete', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:10:34', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record inserted On Staff Payslip id 4', 4, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:10:44', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On Payslip Allowance id 5', 5, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:10:44', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On Payslip Allowance id 6', 6, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:10:44', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On Staff Leave Request Pending id 5', 5, 0, 'Insert', '182.64.87.227', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-04 18:20:37', '2024-10-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'New Record inserted On duty_roster_assign id31', 31, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On duty_roster_assign id32', 32, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On duty_roster_assign id33', 33, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'New Record inserted On duty_roster_assign id34', 34, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On duty_roster_assign id35', 35, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'New Record inserted On duty_roster_assign id36', 36, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On duty_roster_assign id37', 37, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On duty_roster_assign id38', 38, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:39:49', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On duty_roster_assign id39', 39, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'New Record inserted On duty_roster_assign id40', 40, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'New Record inserted On duty_roster_assign id41', 41, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On duty_roster_assign id42', 42, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'New Record inserted On duty_roster_assign id43', 43, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On duty_roster_assign id44', 44, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'New Record inserted On duty_roster_assign id45', 45, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:52', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'New Record inserted On duty_roster_assign id46', 46, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:40:53', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'New Record inserted On Referral Payment id 3', 3, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:48:35', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On Referral Person id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'New Record inserted On Referral Person Commission id 8', 8, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On Referral Person Commission id 9', 9, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'New Record inserted On Referral Person Commission id 10', 10, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'New Record inserted On Referral Person Commission id 11', 11, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'New Record inserted On Referral Person Commission id 12', 12, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On Referral Person Commission id 13', 13, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'New Record inserted On Referral Person Commission id 14', 14, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 12:59:58', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'Record updated On Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:24', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'Record updated On Referral Person Commission where Referral Person id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:00:24', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'New Record inserted For Organisation id 5', 5, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:10:40', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'Record updated On Organisation id 4', 4, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:12:14', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On Income id 3', 3, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:56:39', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'Record updated For Income id 2', 2, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:57:22', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'New Record inserted On Income Head id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 13:59:19', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On Expenses id 4', 4, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:03:48', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'New Record inserted On Expense Head id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:07:17', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On Item Stock id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:33:32', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'Record updated For Item Issue id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:34:39', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'New Record inserted On Item id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:39:44', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'New Record inserted On Item Store id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:44:30', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'New Record inserted On Item supplier id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:47:28', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'New Record inserted On  content_types id 6', 6, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:52:06', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'New Record inserted On  upload_contents id 51', 51, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 14:55:27', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'Record deleted On Front Cms Page Contents id 1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 15:19:18', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'Record updated On Front Cms Pages id 1', 1, 0, 'Update', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 15:19:18', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'New Record inserted On Page events id 2', 2, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 15:23:51', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On Page notice id 4', 4, 0, 'Insert', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 15:26:31', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 15:59:23', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:00:20', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:02:05', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:05:22', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:05:41', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:06:14', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:06:42', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:07:18', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:07:53', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:08:56', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:09:36', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:11:09', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:12:01', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:12:16', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:12:54', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:21:06', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:21:39', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:23:40', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:25:55', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:28:21', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:31:05', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:31:21', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:33:34', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:34:51', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:36:31', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:37:12', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:37:51', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:38:21', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:39:04', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:40:35', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:41:26', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.168.27.27', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-05 16:42:21', '2024-10-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:47:24', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:52:47', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:54:54', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'New Record inserted On Read System Notification id 24', 24, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:56:11', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'New Record inserted On Read System Notification id 25', 25, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:56:15', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On Read System Notification id 26', 26, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:56:17', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:58:18', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On Read System Notification id 27', 27, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 12:58:47', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:02:28', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:04:24', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:06:13', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:07:43', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On Symptoms Classification id 4', 4, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:13:15', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'New Record inserted On Operation id 4', 4, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:18:25', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On Finding id 5', 5, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:23:32', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On Patient id 6', 6, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:31:03', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'Record updated On Patient id 6', 6, 0, 'Update', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:31:03', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On Charge Categories id 8', 8, 0, 'Insert', '122.170.208.146', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 13:49:32', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'New Record inserted On Charge Units id 7', 7, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:26:50', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'Record deleted On roles Permissions where Role id  1', 1, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:28:41', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'Record updated On Patient id 3', 3, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:37:55', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'Record deleted On Charges id 6', 6, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:40:25', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'Record updated On Charge Categories id 7', 7, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:40:48', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'Record deleted On Charge Categories id 7', 7, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:41:01', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'New Record inserted On Tax Category id 4', 4, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:44:04', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'Record updated On Charge Units id 4', 4, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:44:29', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'Record deleted On Charge Units id 4', 4, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:44:35', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'Record updated On Charge Units id 4', 4, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 14:44:42', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'New Record inserted On Bed id 4', 4, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:24:41', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'Record updated On Bed id 3', 3, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:25:01', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'New Record inserted On Floor id 3', 3, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:28:22', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'Record updated On Floor id 1', 1, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:28:28', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'Record updated On Print Setting id 2', 2, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:47:38', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'Record updated On Print Setting id 3', 3, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:47:50', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'Record updated On Print Setting id 13', 13, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:52:45', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'Record updated On Print Setting id 14', 14, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:52:51', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'Record updated On Print Setting id 15', 15, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:52:58', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'Record updated On Print Setting id 16', 16, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:53:03', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'Record updated On Print Setting id 18', 18, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:53:17', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'New Record inserted On Visitors Purpose id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:54:11', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'Record updated On Visitors Purpose id 2', 2, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:54:22', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'Record deleted On Visitors Purpose id 2', 2, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:54:27', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'New Record inserted On Visitors Purpose id 3', 3, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:54:46', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On complaint_type id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 16:58:28', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'Record updated On Operation id 2', 2, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:00:12', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On Medicine Category id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:05:21', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'New Record inserted On Medicine Supplier id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:06:20', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On Medicine Dosage id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:06:59', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'New Record inserted On Dose Interval id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:07:34', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'New Record inserted On Dose Duration id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:07:53', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'New Record inserted On Unit id 9', 9, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:08:16', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'New Record inserted On Company id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:09:26', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'New Record inserted On medicine group id 2', 2, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:09:50', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'Record updated On medicine group id 2', 2, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:10:12', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'Record deleted On medicine group id 2', 2, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:10:18', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On medicine group id 3', 3, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:10:36', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'Record updated On Pathology Category id 3', 3, 0, 'Update', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:11:00', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'Record deleted On Pathology Category id 3', 3, 0, 'Delete', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:11:04', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On Pathology Category id 4', 4, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:11:23', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'New Record inserted On pathology Test id 3', 3, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:13:44', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On Appointment Created 23', 23, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:18:55', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'Record deleted On Appointment Deleted id 23', 23, 0, 'Delete', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:31:09', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On Appointment Created 24', 24, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:31:39', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On Pathology Parameter id 3', 3, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:33:13', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'New Record inserted On Unit id 10', 10, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:34:54', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On Radiology Parameter id 3', 3, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:36:03', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'Record updated On Radiology Parameter id 3', 3, 0, 'Update', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:36:14', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'Record deleted On Radiology Parameter id 3', 3, 0, 'Delete', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:36:19', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'Record updated On Zoom Settings id 1', 1, 0, 'Update', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:38:05', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'New Record inserted On Income Head id 3', 3, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:38:33', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On Expense Head id 3', 3, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:39:01', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'New Record inserted On Leave Types id 5', 5, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:39:31', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On Staff Designation id 7', 7, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:40:14', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'New Record inserted On Specialist id 5', 5, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:40:38', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'Record updated On Referral Category id 1', 1, 0, 'Update', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:41:08', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'New Record inserted On Item Category id 5', 5, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:44:02', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'New Record inserted On Custom Fields id 5', 5, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:45:13', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'New Record inserted On Custom Fields id 6', 6, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:45:49', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'Record updated On Custom Fields id 6', 6, 0, 'Update', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:46:04', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'New Record inserted On Custom Fields id 7', 7, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:46:52', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On Custom Fields id 8', 8, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:47:53', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'New Record inserted On Custom Fields id 9', 9, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:48:31', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'New Record inserted On Custom Fields id 10', 10, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:49:07', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'New Record inserted On Custom Fields id 11', 11, 0, 'Insert', '152.59.28.5', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 17:49:38', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'New Record inserted On Custom Fields id 12', 12, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 18:24:35', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'New Record inserted On Custom Fields id 13', 13, 0, 'Insert', '106.205.95.33', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-07 18:25:19', '2024-10-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'New Record inserted For Organisation id 6', 6, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 12:56:07', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'New Record inserted On Patient id 7', 7, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:15:48', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'Record updated On Patient id 7', 7, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:15:48', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'Record updated On Patient id 7', 7, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:20:31', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'New Record inserted On IPD id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:20:31', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record updated On Bed id 4', 4, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:20:31', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'New Record inserted On Patient bed history id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:20:31', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record updated On Patient id 7', 7, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:23:02', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'New Record inserted On Transactions id 60', 60, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:23:02', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'New Record inserted On Ipd Prescription Basic id 17', 17, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:32:38', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'Record updated On Patient id 7', 7, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:47:01', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'New Record inserted On Transactions id 61', 61, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 13:47:01', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'New Record inserted On Charge Categories id 9', 9, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:20:23', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'New Record inserted On Charge Categories id 10', 10, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:21:09', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'New Record inserted On Charge Categories id 11', 11, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:21:32', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'New Record inserted On Charge Categories id 12', 12, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:22:02', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'New Record inserted On pathology Test id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:26:43', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'Record updated On Organisations Charges id 17', 17, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:55:50', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'Record updated On Organisations Charges id 22', 22, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 14:56:16', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'Record updated On Patient id 7', 7, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:05:33', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'New Record inserted On Transactions id 62', 62, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:05:33', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'New Record inserted On Ipd Prescription Basic id 18', 18, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:11:57', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'New Record inserted On Medication Report id 8', 8, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:12:58', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'New Record inserted On Operation Theatre id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:13:21', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'Record updated On Patient Charges id 28', 28, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:14:20', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'New Record inserted On Patient Timeline id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:15:00', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'New Record inserted On Pharmacy Bill Basic id 1', 1, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:16:35', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'New Record inserted On Lab id 6', 6, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:25:25', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On Charge Categories id 13', 13, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:47:15', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'Record updated On Charge Categories id 13', 13, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:47:40', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On Radio id 2', 2, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:51:52', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'New Record inserted On Radiology Billing id 4', 4, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:53:18', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'New Record inserted On Transactions id 64', 64, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:53:18', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'New Record inserted On Transactions id 65', 65, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:54:58', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'Record updated On Custom Field Values id 20', 20, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 16:55:58', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'New Record inserted On Transactions id 66', 66, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 18:16:09', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'Record updated On Custom Field Values id 21', 21, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-08 18:16:27', '2024-10-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'New Record inserted On Read System Notification id 28', 28, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 12:34:05', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On Read System Notification id 29', 29, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 12:34:08', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'New Record inserted On Appointment Created 25', 25, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 12:59:57', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'Record updatedOn Appointment Updated 24', 24, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:01:42', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'New Record inserted On Custom Field Values id 23', 23, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:01:42', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'Record updatedOn Appointment Updated 25', 25, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:02:54', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'Record updated On Custom Field Values id 22', 22, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:02:54', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'Record updatedOn Appointment Updated 4', 4, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:04:07', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'New Record inserted On Custom Field Values id 24', 24, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:04:07', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'New Record inserted On Appointment Created 26', 26, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:53:12', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'New Record inserted On Charge Categories id 14', 14, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 13:59:03', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On Tax Category id 5', 5, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:00:56', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'Record updated On Patient id 3', 3, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:02:30', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On Transactions id 69', 69, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:02:30', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'New Record inserted On Ipd Prescription Basic id 19', 19, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:04:00', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'Record updated On Transactions id 69', 69, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:04:40', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'Record updated On Visit Details id 30', 30, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:04:40', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On Transactions id 70', 70, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:17:54', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'New Record inserted On Visit Details id 31', 31, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:17:54', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'New Record inserted On Medication Report id 9', 9, 0, 'Insert', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:18:28', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'Record updated On Medication Report id 9', 9, 0, 'Update', '182.70.206.164', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 14:18:40', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On Operation Theatre id 5', 5, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:04:00', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'Record updated On Operation Theatre id 5', 5, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:04:30', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On Transactions id 71', 71, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:07:44', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'Record updated On Transactions id 69', 69, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:07:58', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'Record deleted On Transactions id 69', 69, 0, 'Delete', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:08:03', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'Record updated On Patient Timeline id 2', 2, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:08:28', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'Record deleted On Patient Timeline id 2', 2, 0, 'Delete', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:08:33', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'New Record inserted On Patient Timeline id 5', 5, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:09:13', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'Record updated On Transactions id 27', 27, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:09:58', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'Record updated On Visit Details id 10', 10, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:09:58', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'New Record inserted On Bed Group id 4', 4, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:16:09', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'New Record inserted On Floor id 4', 4, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:16:32', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On Floor id 5', 5, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:16:46', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'New Record inserted On Medication Report id 10', 10, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:28:21', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'New Record inserted On Ipd Prescription Basic id 20', 20, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:29:19', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'New Record inserted On Ipd Prescription Basic id 21', 21, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:29:24', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'New Record inserted On Ipd Prescription Basic id 22', 22, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:29:26', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'New Record inserted On Ipd Prescription Basic id 23', 23, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:29:37', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'New Record inserted On Ipd Prescription Basic id 24', 24, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:31', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'New Record inserted On Ipd Prescription Basic id 25', 25, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:43', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'New Record inserted On Ipd Prescription Basic id 26', 26, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:51', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'New Record inserted On Ipd Prescription Basic id 27', 27, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:54', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'New Record inserted On Ipd Prescription Basic id 28', 28, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:59', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'New Record inserted On Ipd Prescription Basic id 29', 29, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:31:59', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On Ipd Prescription Basic id 30', 30, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:34:34', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'New Record inserted On Ipd Prescription Basic id 31', 31, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 15:51:50', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On Operation Theatre id 6', 6, 0, 'Insert', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:01:19', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'Record updated On Operation Theatre id 6', 6, 0, 'Update', '122.173.36.141', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:01:38', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'New Record inserted On Charge Categories id 15', 15, 0, 'Insert', '122.175.155.184', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:22:47', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'New Record inserted On Patient Charges id 33', 33, 0, 'Insert', '122.175.155.184', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:23:53', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On Transactions id 72', 72, 0, 'Insert', '122.175.155.184', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:26:48', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'Record updated On Patient Timeline id 4', 4, 0, 'Update', '122.175.155.184', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-09 16:50:08', '2024-10-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'New Record inserted On Pharmacy Bill Basic id 5', 5, 0, 'Insert', '1.23.234.231', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 12:21:18', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'Record updated On Pharmacy Bill Basic id 5', 5, 0, 'Update', '1.23.234.231', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 12:55:55', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'Record updated On Pharmacy Bill Basic id 5', 5, 0, 'Update', '1.23.234.231', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 12:58:04', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'New Record inserted On Pharmacy Bill Basic id 6', 6, 0, 'Insert', '1.23.234.231', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:01:59', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'New Record inserted On Pharmacy Bill Basic id 7', 7, 0, 'Insert', '1.23.234.231', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:18:28', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'Record deleted On Pharmacy Bill Detail id 7', 7, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:32:46', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'Record deleted On Pharmacy Bill Detail id 6', 6, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:32:54', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'Record deleted On Pharmacy Bill Detail id 5', 5, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:32:59', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'Record deleted On Pharmacy Bill Detail id 1', 1, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:33:03', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'New Record inserted On Pharmacy id 2', 2, 0, 'Insert', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:37:46', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'New Record inserted On Supplier Bill Basic id 2', 2, 0, 'Insert', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 13:39:03', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'New Record inserted On Pharmacy Bill Basic id 8', 8, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 13:55:14', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'New Record inserted On Pharmacy id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:04:56', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'New Record inserted On Supplier Bill Basic id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:11:38', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On Transactions id 79', 79, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:16:42', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'New Record inserted On Medicine Category id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:19:43', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'New Record inserted On Medicine Supplier id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:24:18', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'Record updated On Medicine Supplier id 3', 3, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:25:11', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'New Record inserted On Medicine Dosage id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 128.0.0.0', '2024-10-10 14:26:10', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'Record updated On Medicine Category id 3', 3, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:32:51', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On Dose Interval id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:34:16', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'New Record inserted On Dose Duration id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:34:40', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On Unit id 11', 11, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:35:31', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'New Record inserted On Company id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:37:01', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On Pharmacy Bill Basic id 9', 9, 0, 'Insert', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:37:05', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'Record updated On Pharmacy Bill Basic id 9', 9, 0, 'Update', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:37:19', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'New Record inserted On medicine group id 4', 4, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:37:34', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'Record updated On Pharmacy Bill Basic id 9', 9, 0, 'Update', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:37:37', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'New Record inserted On medicine group id 5', 5, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:38:03', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'New Record inserted On Pathology Category id 5', 5, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:43:18', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'Record deleted On Transactions id 82', 82, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:46:21', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'Record deleted On Transactions id 81', 81, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:46:23', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'Record deleted On Transactions id 80', 80, 0, 'Delete', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:46:25', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'New Record inserted On Transactions id 83', 83, 0, 'Insert', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:46:43', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'New Record inserted On pathology Test id 5', 5, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:50:59', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'New Record inserted On Transactions id 84', 84, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:53:40', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'Record updated On Pathology Report id 5', 5, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:54:03', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'Record updated On Pharmacy Bill Basic id 9', 9, 0, 'Update', '1.23.234.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 14:58:04', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'New Record inserted On Unit id 12', 12, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:40:00', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'New Record inserted On Radiology Parameter id 4', 4, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:45:13', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'New Record inserted On Radiology Billing id 5', 5, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:23', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'New Record inserted On Transactions id 86', 86, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:23', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'Record updated On Radiology Billing id 5', 5, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'Record updated On Custom Field Values id 26', 26, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'Record updated On Custom Field Values id 27', 27, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'New Record inserted On Custom Field Values id 28', 28, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On Custom Field Values id 29', 29, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:51:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'New Record inserted On Transactions id 87', 87, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:52:14', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'New Record inserted On Radio id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:53:41', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'New Record inserted On Blood Donor  id 15', 15, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:57:23', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'New Record inserted On Transactions id 88', 88, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:57:23', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'New Record inserted On Blood Donor  id 16', 16, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:59:06', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On Blood Donor  id 17', 17, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 16:59:06', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'New Record inserted For Blood Donor id 5', 5, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:00:20', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On Blood Donor  id 18', 18, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:01:13', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'New Record inserted On Transactions id 89', 89, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:01:13', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On Blood Donor  id 19', 19, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:02:35', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'New Record inserted On Transactions id 90', 90, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:02:35', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'New Record inserted On Transactions id 91', 91, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:06:45', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'Record updated On Custom Field Values id 30', 30, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:07:33', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On Transactions id 92', 92, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:21:22', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'New Record inserted On Transactions id 93', 93, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:21:32', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On Ambulance id 4', 4, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:23:05', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'Record updated For Ambulance id 4', 4, 0, 'Update', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:23:25', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'New Record inserted On Visitors Book id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:26:39', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'New Record inserted On General Calls id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:27:24', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On dispatch_receive id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:30:36', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'New Record inserted On dispatch_receive id 4', 4, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:31:39', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'New Record inserted On Complaint id 2', 2, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:32:24', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'New Record inserted On complaint_type id 3', 3, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:33:45', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On Visitors Purpose id 4', 4, 0, 'Insert', '152.59.30.119', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 17:34:32', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'New Record inserted On Complaint id 3', 3, 0, 'Insert', '152.59.31.25', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-10 18:29:52', '2024-10-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On Birth Report id 3', 3, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:54:20', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'Record updated For Birth Report id 3', 3, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:54:20', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'Record deleted Where Birth Report  id 2', 2, 0, 'Delete', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:55:00', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'New Record inserted On Death Report id 4', 4, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:55:32', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'Record updated On Patient id 5', 5, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:55:32', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'Record deleted Where Death Report  id 3', 3, 0, 'Delete', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:56:51', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'New Record inserted On Death Report id 5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:57:08', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'Record updated On Patient id 5', 5, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 13:57:08', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'Record updated For Staff id 8', 8, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:48:10', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On Staff Attendance id 14', 14, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:49:20', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'New Record inserted On Staff Attendance id 15', 15, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:49:20', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'New Record inserted On Staff Payslip id 5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:52:11', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'New Record inserted On Payslip Allowance id 7', 7, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:52:11', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'New Record inserted On Payslip Allowance id 8', 8, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:52:11', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'New Record inserted On Leave Types id 6', 6, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:56:23', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'New Record inserted On Department id 7', 7, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:57:08', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'Record updated On Department id 6', 6, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:57:23', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'Record updated On Department id 6', 6, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:57:36', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'New Record inserted On Specialist id 6', 6, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:58:31', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'Record updated On Specialist id 1', 1, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 15:59:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'New Record inserted On Staff Leave Request Approve id 6', 6, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:04:33', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'New Record inserted On Duty Roster Shift id5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:13:04', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'New Record inserted On Duty Roster Shift id5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:14:27', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'New Record inserted On Duty Roster Shift id6', 6, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:15:35', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'New Record inserted On duty_roster_assign id47', 47, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:24', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'New Record inserted On duty_roster_assign id48', 48, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:24', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'New Record inserted On duty_roster_assign id49', 49, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:24', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'New Record inserted On duty_roster_assign id50', 50, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:24', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'New Record inserted On duty_roster_assign id51', 51, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'New Record inserted On duty_roster_assign id52', 52, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'New Record inserted On duty_roster_assign id53', 53, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'New Record inserted On duty_roster_assign id54', 54, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'New Record inserted On duty_roster_assign id55', 55, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:16:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'New Record inserted On  holiday master  id 5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:20:28', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'New Record inserted On Referral Category id 3', 3, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:51:17', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'Record updated On Referral Category id 1', 1, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:51:34', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'New Record inserted On Referral Payment id 4', 4, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:52:30', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'New Record inserted On Referral Person id 3', 3, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'New Record inserted On Referral Person Commission id 15', 15, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On Referral Person Commission id 16', 16, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'New Record inserted On Referral Person Commission id 17', 17, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'New Record inserted On Referral Person Commission id 18', 18, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'New Record inserted On Referral Person Commission id 19', 19, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'New Record inserted On Referral Person Commission id 20', 20, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'New Record inserted On Referral Person Commission id 21', 21, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 16:54:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'New Record inserted For Organisation id 7', 7, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:11:13', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'New Record inserted On Income id 4', 4, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:22:39', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'Record updated For Income id 4', 4, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:23:16', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'Record updated For Income id 4', 4, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:29:51', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'Record deleted Where Expenses  id 4', 4, 0, 'Delete', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:30:12', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'New Record inserted On Expenses id 5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:31:05', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'New Record inserted On Income Head id 4', 4, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:32:51', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'Record updated On Income Head id 2', 2, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:33:08', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'Record updated On Income Head id 1', 1, 0, 'Update', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:33:29', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'New Record inserted On Expense Head id 4', 4, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:34:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'Record deleted On send notification id 2', 2, 0, 'Delete', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 17:58:27', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'New Record inserted On Messages Send SMS id 5', 5, 0, 'Insert', '152.59.29.64', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:06:46', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'New Record inserted On Messages Send SMS id 6', 6, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:09:13', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'New Record inserted On Item id 3', 3, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:13:30', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'Record updated For Item id 3', 3, 0, 'Update', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:14:21', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'New Record inserted On Item id 4', 4, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:20:22', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'New Record inserted On Item id 5', 5, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:21:14', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'New Record inserted On Item Stock id 3', 3, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:21:56', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'New Record inserted On Item Stock id 4', 4, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:22:34', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'New Record inserted On Item Stock id 5', 5, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:23:14', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On Item Issue id 2', 2, 0, 'Insert', '157.34.35.191', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-11 18:27:52', '2024-10-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'New Record inserted On  upload_contents id 52', 52, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 12:38:11', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'Record updated On  upload_contents id 52', 52, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 12:46:31', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'New Record inserted On  content_types id 7', 7, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 12:49:57', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'New Record inserted On Certificates id 14', 14, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:29:47', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'New Record inserted On Certificates id 15', 15, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:29:47', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'Record updated On Certificates id 15', 15, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:30:33', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'Record updated On Certificates id 14', 14, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:31:09', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'New Record inserted On Staff id card id 3', 3, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:44:14', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'Record updated On Staff id card id 3', 3, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 13:44:14', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'New Record inserted On Page events id 5', 5, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:31:57', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'New Record inserted On Page notice id 7', 7, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:35:06', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'New Record inserted On Page Menu id 5', 5, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:39:44', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'Record updated For Menu Item id 3', 3, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:40:40', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'New Record inserted On Menu Item id 6', 6, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:41:04', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'Record updated On Zoom Settings id 1', 1, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 14:49:21', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'New Record inserted On Read System Notification id 30', 30, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:11', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'New Record inserted On Read System Notification id 31', 31, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:13', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'New Record inserted On Read System Notification id 32', 32, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:14', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'New Record inserted On Read System Notification id 33', 33, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:16', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'New Record inserted On Read System Notification id 34', 34, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:18', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'New Record inserted On Read System Notification id 35', 35, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:19', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'New Record inserted On Read System Notification id 36', 36, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 15:17:20', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'Record updated On Settings id 1', 1, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:42:57', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'Record updated On Settings id 1', 1, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:43:35', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'Record updated On Settings id 1', 1, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:43:53', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'Record updated On Settings id 1', 1, 0, 'Update', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:44:42', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'New Record inserted On Sms Config id 1', 1, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:48:31', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'New Record inserted On Sms Config id 2', 2, 0, 'Insert', '27.57.143.189', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-14 16:49:29', '2024-10-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'Record updated On Email Config id 1', 1, 0, 'Update', '122.173.36.106', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-15 12:30:15', '2024-10-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'Record updated On Payment Settings id 1', 1, 0, 'Update', '122.173.36.106', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-15 12:31:38', '2024-10-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'Record updated On Payment Settings id 2', 2, 0, 'Update', '122.173.36.106', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-15 12:32:37', '2024-10-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '122.173.36.106', 'Windows 10', 'Chrome 129.0.0.0', '2024-10-15 12:33:19', '2024-10-15');


#
# TABLE STRUCTURE FOR: medication_report
#

DROP TABLE IF EXISTS `medication_report`;

CREATE TABLE `medication_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `medicine_dosage_id` int DEFAULT NULL,
  `pharmacy_id` int DEFAULT NULL,
  `opd_details_id` int DEFAULT NULL,
  `ipd_id` int DEFAULT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `remark` text,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `generated_by` (`generated_by`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `medicine_dosage_id` (`medicine_dosage_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `index_date` (`date`),
  KEY `index_time` (`time`),
  CONSTRAINT `medication_report_ibfk_1` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_3` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_4` FOREIGN KEY (`medicine_dosage_id`) REFERENCES `medicine_dosage` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medication_report_ibfk_5` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (4, 1, 1, NULL, 2, '2024-10-03', '15:49:00', '', 1, '2024-09-28 10:20:00');
INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (6, 1, 1, 14, NULL, '2024-10-01', '14:29:00', '', 7, '2024-10-03 08:59:47');
INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (7, 1, 1, NULL, 3, '2024-10-09', '17:13:00', '', 7, '2024-10-03 11:43:59');
INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (8, 1, 1, 25, NULL, '2024-10-10', '16:12:00', '', 1, '2024-10-08 10:42:58');
INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (9, 1, 1, 28, NULL, '2024-10-09', '14:18:00', '', 1, '2024-10-09 08:48:28');
INSERT INTO `medication_report` (`id`, `medicine_dosage_id`, `pharmacy_id`, `opd_details_id`, `ipd_id`, `date`, `time`, `remark`, `generated_by`, `created_at`) VALUES (10, 1, 1, NULL, 4, '2024-10-16', '15:28:00', '', 1, '2024-10-09 09:58:21');


#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `medicine_batch_details_id` int DEFAULT NULL,
  `pharmacy_id` int DEFAULT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `quantity` varchar(20) NOT NULL,
  `note` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `medicine_batch_details_id` (`medicine_batch_details_id`),
  KEY `index_outward_date` (`outward_date`),
  KEY `index_expiry_date` (`expiry_date`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_quantity` (`quantity`),
  CONSTRAINT `medicine_bad_stock_ibfk_1` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_bad_stock_ibfk_2` FOREIGN KEY (`medicine_batch_details_id`) REFERENCES `medicine_batch_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` int DEFAULT NULL,
  `pharmacy_id` int DEFAULT NULL,
  `inward_date` datetime NOT NULL,
  `expiry` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` float(10,2) DEFAULT '0.00',
  `purchase_price` float(10,2) DEFAULT '0.00',
  `tax` float(10,2) DEFAULT '0.00',
  `sale_rate` float(10,2) DEFAULT '0.00',
  `batch_amount` float(10,2) DEFAULT '0.00',
  `amount` float(10,2) DEFAULT '0.00',
  `available_quantity` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `supplier_bill_basic_id` (`supplier_bill_basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_inward_date` (`inward_date`),
  KEY `index_expiry` (`expiry`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_packing_qty` (`packing_qty`),
  KEY `index_purchase_rate_packing` (`purchase_rate_packing`),
  KEY `index_quantity` (`quantity`),
  KEY `index_mrp` (`mrp`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_tax` (`tax`),
  KEY `index_sale_rate` (`sale_rate`),
  KEY `index_batch_amount` (`batch_amount`),
  KEY `index_amount` (`amount`),
  KEY `index_available_quantity` (`available_quantity`),
  CONSTRAINT `medicine_batch_details_ibfk_1` FOREIGN KEY (`supplier_bill_basic_id`) REFERENCES `supplier_bill_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_batch_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `pharmacy_id`, `inward_date`, `expiry`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `tax`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (1, 1, 1, '2024-09-30 11:21:00', '2025-12-31', '352', '1000', '', '500', '30.00', '15.00', '10.00', '20.00', '35.00', '7500.00', 500, '2024-09-30 05:52:18');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `pharmacy_id`, `inward_date`, `expiry`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `tax`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (2, 2, 2, '2024-10-10 13:37:00', '2024-12-31', '12345', '10', '', '100', '50.00', '10.00', '20.00', '20.00', '10.00', '1000.00', 100, '2024-10-10 08:09:03');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `pharmacy_id`, `inward_date`, `expiry`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `tax`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (3, 3, 1, '2024-10-10 01:40:00', '2025-07-31', '123', '', '', '20', '15.00', '13.00', '5.00', '15.00', '0.00', '260.00', 20, '2024-10-10 08:41:38');


#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_medicine_category` (`medicine_category`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medicine_category` (`id`, `medicine_category`, `created_at`) VALUES (1, 'sergical', '2024-09-26 12:04:41');
INSERT INTO `medicine_category` (`id`, `medicine_category`, `created_at`) VALUES (2, 'medicine category', '2024-10-07 11:35:21');
INSERT INTO `medicine_category` (`id`, `medicine_category`, `created_at`) VALUES (3, 'Antibiotic', '2024-10-10 08:49:43');


#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int DEFAULT NULL,
  `dosage` varchar(100) NOT NULL,
  `units_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `charge_units_id` (`units_id`),
  KEY `index_dosage` (`dosage`),
  CONSTRAINT `medicine_dosage_ibfk_1` FOREIGN KEY (`medicine_category_id`) REFERENCES `medicine_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `medicine_dosage_ibfk_2` FOREIGN KEY (`units_id`) REFERENCES `unit` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage`, `units_id`, `created_at`) VALUES (1, 1, 'dose', 1, '2024-09-26 12:07:54');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage`, `units_id`, `created_at`) VALUES (2, 2, '1 time', 2, '2024-10-07 11:36:59');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage`, `units_id`, `created_at`) VALUES (3, 3, '2-3 Times', 3, '2024-10-10 08:56:10');


#
# TABLE STRUCTURE FOR: medicine_group
#

DROP TABLE IF EXISTS `medicine_group`;

CREATE TABLE `medicine_group` (
  `id` int NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_group_name` (`group_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medicine_group` (`id`, `group_name`, `created_at`) VALUES (1, 'Antibacterials', '2024-09-26 12:08:53');
INSERT INTO `medicine_group` (`id`, `group_name`, `created_at`) VALUES (3, 'Antifungal', '2024-10-07 11:40:36');
INSERT INTO `medicine_group` (`id`, `group_name`, `created_at`) VALUES (4, 'Antibiotic', '2024-10-10 09:07:34');
INSERT INTO `medicine_group` (`id`, `group_name`, `created_at`) VALUES (5, 'Antielirgic', '2024-10-10 09:08:03');


#
# TABLE STRUCTURE FOR: medicine_supplier
#

DROP TABLE IF EXISTS `medicine_supplier`;

CREATE TABLE `medicine_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `supplier` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `supplier_person` varchar(200) NOT NULL,
  `supplier_person_contact` varchar(200) NOT NULL,
  `supplier_drug_licence` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_supplier` (`supplier`),
  KEY `index_contact` (`contact`),
  KEY `index_supplier_person` (`supplier_person`),
  KEY `index_supplier_person_contact` (`supplier_person_contact`),
  KEY `index_supplier_drug_licence` (`supplier_drug_licence`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `medicine_supplier` (`id`, `supplier`, `contact`, `supplier_person`, `supplier_person_contact`, `supplier_drug_licence`, `address`, `created_at`) VALUES (1, 'medician supplier', '', 'abhay', '', '	FGFGF-0978967', '', '2024-09-26 12:06:00');
INSERT INTO `medicine_supplier` (`id`, `supplier`, `contact`, `supplier_person`, `supplier_person_contact`, `supplier_drug_licence`, `address`, `created_at`) VALUES (2, 'ashok suppliar', '356796896', '', '', '', '', '2024-10-07 11:36:20');
INSERT INTO `medicine_supplier` (`id`, `supplier`, `contact`, `supplier_person`, `supplier_person_contact`, `supplier_drug_licence`, `address`, `created_at`) VALUES (3, 'akhaya suplliar', '235667485', 'vinay', '', 'LINC766776', '', '2024-10-10 08:54:18');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `template_id` varchar(100) NOT NULL,
  `message` text,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text,
  `user_list` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_send_mail` (`send_mail`),
  KEY `index_send_sms` (`send_sms`),
  KEY `index_is_group` (`is_group`),
  KEY `index_is_individual` (`is_individual`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (1, 'record submitted', '', 'please all record submitted', '0', '1', '1', '0', '', '[]', NULL, '2024-09-30 12:42:19');
INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (2, 'hello', '', '<p>hiiiiiiiiiiiiiiiiiiiiiiiiii</p>\r\n', '1', '0', '1', '0', '', '[]', NULL, '2024-09-30 18:19:45');
INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (3, 'hello', '', 'dfjuuiy', '0', '1', '1', '0', '', '[]', NULL, '2024-10-01 07:27:13');
INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (4, 'hello', '', 'sfdfjhjhgh', '0', '1', '0', '1', '', NULL, '[{\"category\":\"Staff-9\",\"user_id\":\"4\",\"email\":\"RASHI@gmail.com\",\"mobileno\":\"9826244698\",\"app_key\":\"\"}]', '2024-10-01 07:28:25');
INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (5, 'Sumited all document', '', 'Sumited all document', '0', '1', '1', '0', '', '[]', NULL, '2024-10-11 12:36:46');
INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (6, 'Sumitted all document', '', 'Sumitted all document', '0', '1', '0', '1', '', NULL, '[{\"category\":\"Staff-3\",\"user_id\":\"8\",\"email\":\"abhay@gmail.com\",\"mobileno\":\"\",\"app_key\":\"\"}]', '2024-10-11 12:39:13');


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `send_notification_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (1, 1, 7, 0, '2024-09-30 12:24:52');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (3, 3, 1, 0, '2024-10-05 08:42:15');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (4, 4, 1, 0, '2024-10-11 12:27:46');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (5, 4, 7, 0, '2024-10-11 12:27:46');


#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int DEFAULT '0',
  `is_sms` int DEFAULT '0',
  `is_mobileapp` int NOT NULL,
  `is_notification` int NOT NULL,
  `display_notification` int NOT NULL,
  `display_sms` int NOT NULL,
  `template` longtext,
  `template_id` varchar(100) NOT NULL,
  `subject` text,
  `variables` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_is_mail` (`is_mail`),
  KEY `index_is_sms` (`is_sms`),
  KEY `index_is_mobileapp` (`is_mobileapp`),
  KEY `index_is_notification` (`is_notification`),
  KEY `index_display_notification` (`display_notification`),
  KEY `index_display_sms` (`display_sms`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration at Smart Hospital is successful on date {{appointment_date}} with Patient Id {{patient_id}} and OPD No {{opdno}}', '', 'OPD Patient', '{{patient_name}} {{appointment_date}} {{patient_id}} {{opdno}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration at Smart Hospital is successful  with Patient Id {{patient_id}} and IPD No {{ipd_no}}', '', 'IPD Patient Registration', '{{patient_name}} {{patient_id}} {{ipd_no}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 1, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Smart Hospital\nTotal bill amount is {{currency_symbol}}{{total_amount}}\nTotal paid amount is {{currency_symbol}}{{paid_amount}}\nTotal balance bill amount is {{currency_symbol}}{{balance_amount}}', '', 'IPD Patient Discharge', '{{patient_name}} {{currency_symbol}} {{total_amount}} {{paid_amount}} {balance_amount}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 1, 0, 0, 0, 1, 'Hello {{display_name}} your Smart Hospital login details are Url: {{url}} Username: {{username}} Password: {{password}}', '', 'Smart Hospital Login Credential', '{{display_name}} {{url}} {{username}} {{password}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 1, 1, 1, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', '', 'Appointment Approved', '{{patient_name}} {{staff_name}}\n{{staff_surname}}  {{date}} {{appointment_no}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 1, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Meeting', '{{title}} {{date}} {{duration}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 1, 1, 1, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 1, 1, 1, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Smart Hospital.\r\n\r\nTotal bill amount was {{currency_symbol}}  {{total_amount}} \r\nTotal paid amount was {{currency_symbol}}{{paid_amount}}  \r\nTotal balance amount is {{currency_symbol}}{{balance_amount}}', '', 'OPD Patient Discharged', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2024-10-14 11:17:40');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}}, recently a request was submitted to reset password for your account with email: {{email}}. If you didn\'t make the request, just ignore this email, otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>click here to reset your password</a>, if you\'re having trouble clicking the password reset link, copy and paste below URL  into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\nSmart Hospital', '', 'Reset Password Request', '{{display_name}}  {{email}}  {{resetpasslink}', '2021-10-22 06:34:34');


#
# TABLE STRUCTURE FOR: nurse_note
#

DROP TABLE IF EXISTS `nurse_note`;

CREATE TABLE `nurse_note` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ipd_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `comment` text,
  `created_by` int NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `nurse_note_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `nurse_note_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `nurse_note` (`id`, `date`, `ipd_id`, `staff_id`, `note`, `comment`, `created_by`, `updated_at`, `created_at`) VALUES (1, '2024-09-28 15:27:00', 2, 4, 'normallllllll', 'all document submitted', 1, '2024-09-28 15:27:00', '2024-09-28 09:57:58');
INSERT INTO `nurse_note` (`id`, `date`, `ipd_id`, `staff_id`, `note`, `comment`, `created_by`, `updated_at`, `created_at`) VALUES (2, '2024-10-03 17:23:00', 3, 4, 'hello', 'hi', 7, '2024-10-03 17:23:00', '2024-10-03 11:53:57');
INSERT INTO `nurse_note` (`id`, `date`, `ipd_id`, `staff_id`, `note`, `comment`, `created_by`, `updated_at`, `created_at`) VALUES (3, '2024-10-09 15:18:00', 4, 4, 'submited all document', 'normal', 1, '2024-10-09 15:18:00', '2024-10-09 09:49:08');


#
# TABLE STRUCTURE FOR: nurse_notes_comment
#

DROP TABLE IF EXISTS `nurse_notes_comment`;

CREATE TABLE `nurse_notes_comment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nurse_note_id` int DEFAULT NULL,
  `comment_staffid` int DEFAULT NULL,
  `comment_staff` text,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `nurse_note_id` (`nurse_note_id`),
  KEY `comment_staffid` (`comment_staffid`),
  CONSTRAINT `nurse_notes_comment_ibfk_1` FOREIGN KEY (`nurse_note_id`) REFERENCES `nurse_note` (`id`) ON DELETE CASCADE,
  CONSTRAINT `nurse_notes_comment_ibfk_2` FOREIGN KEY (`comment_staffid`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: obstetric_history
#

DROP TABLE IF EXISTS `obstetric_history`;

CREATE TABLE `obstetric_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `place_of_delivery` varchar(250) NOT NULL,
  `pregnancy_duration` varchar(250) NOT NULL,
  `pregnancy_complications` varchar(250) NOT NULL,
  `birth_weight` varchar(250) NOT NULL,
  `gender` varchar(100) NOT NULL,
  `infant_feeding` varchar(250) NOT NULL,
  `alive_dead` varchar(50) NOT NULL,
  `date` date DEFAULT NULL,
  `death_cause` varchar(250) NOT NULL,
  `previous_medical_history` text NOT NULL,
  `special_instruction` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_place_of_delivery` (`place_of_delivery`),
  KEY `index_pregnancy_duration` (`pregnancy_duration`),
  KEY `index_pregnancy_complications` (`pregnancy_complications`),
  KEY `index_birth_weight` (`birth_weight`),
  KEY `index_gender` (`gender`),
  KEY `index_infant_feeding` (`infant_feeding`),
  KEY `index_alive_dead` (`alive_dead`),
  KEY `index_date` (`date`),
  KEY `index_death_cause` (`death_cause`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `obstetric_history` (`id`, `patient_id`, `place_of_delivery`, `pregnancy_duration`, `pregnancy_complications`, `birth_weight`, `gender`, `infant_feeding`, `alive_dead`, `date`, `death_cause`, `previous_medical_history`, `special_instruction`, `created_at`) VALUES (1, 3, 'Mumbai ', '280days', 'Complication In Pregnancy Or Puerperium ', '3kg', 'Male', 'Infant Feeding', 'alive', '2024-09-25', '', 'Previous Medical History', 'Previous Medical History', '2024-09-28 08:09:49');
INSERT INTO `obstetric_history` (`id`, `patient_id`, `place_of_delivery`, `pregnancy_duration`, `pregnancy_complications`, `birth_weight`, `gender`, `infant_feeding`, `alive_dead`, `date`, `death_cause`, `previous_medical_history`, `special_instruction`, `created_at`) VALUES (2, 3, 'jabalpur', '', '', '', 'Female', '', 'alive', NULL, '', '', '', '2024-09-28 12:32:31');
INSERT INTO `obstetric_history` (`id`, `patient_id`, `place_of_delivery`, `pregnancy_duration`, `pregnancy_complications`, `birth_weight`, `gender`, `infant_feeding`, `alive_dead`, `date`, `death_cause`, `previous_medical_history`, `special_instruction`, `created_at`) VALUES (3, 5, 'jbl', '', '', '', 'Male', '', 'alive', NULL, '', '', '', '2024-10-03 12:15:39');


#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_reference_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `is_ipd_moved` int NOT NULL DEFAULT '0',
  `discharged` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `opd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `opd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `opd_details_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3;

INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (8, 10, 3, NULL, 0, 'no', '2024-09-28 10:05:47');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (11, 13, 3, 1, 0, 'no', '2024-09-28 10:37:14');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (12, 14, 3, 1, 0, 'no', '2024-09-28 10:37:32');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (13, 15, 3, 1, 0, 'no', '2024-09-28 10:37:41');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (14, 16, 3, 1, 0, 'no', '2024-09-28 10:37:48');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (22, 25, 6, 1, 0, 'no', '2024-10-07 12:01:39');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (23, 27, 7, 1, 0, 'no', '2024-10-08 07:53:02');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (24, 28, 7, 1, 0, 'no', '2024-10-08 08:17:01');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (25, 29, 7, 1, 0, 'no', '2024-10-08 10:35:33');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (26, 30, 7, 1, 0, 'no', '2024-10-09 07:29:57');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (27, 31, 7, 1, 0, 'no', '2024-10-09 08:23:12');
INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`) VALUES (28, 32, 3, 1, 0, 'no', '2024-10-09 08:32:30');


#
# TABLE STRUCTURE FOR: operation
#

DROP TABLE IF EXISTS `operation`;

CREATE TABLE `operation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `operation` varchar(250) NOT NULL,
  `category_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `index_operation` (`operation`),
  CONSTRAINT `operation_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `operation_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `operation` (`id`, `operation`, `category_id`, `is_active`, `created_at`) VALUES (1, 'brain surgery', 1, 'yes', '2024-09-28');
INSERT INTO `operation` (`id`, `operation`, `category_id`, `is_active`, `created_at`) VALUES (2, 'delevary', 3, 'yes', '2024-09-28');
INSERT INTO `operation` (`id`, `operation`, `category_id`, `is_active`, `created_at`) VALUES (3, 'opretion', 2, 'yes', '2024-09-28');
INSERT INTO `operation` (`id`, `operation`, `category_id`, `is_active`, `created_at`) VALUES (4, 'surgery', 1, 'yes', '2024-10-07');


#
# TABLE STRUCTURE FOR: operation_category
#

DROP TABLE IF EXISTS `operation_category`;

CREATE TABLE `operation_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(250) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `operation_category` (`id`, `category`, `is_active`, `created_at`) VALUES (1, 'brain', 'yes', '2024-09-28');
INSERT INTO `operation_category` (`id`, `category`, `is_active`, `created_at`) VALUES (2, 'Knee replacement surgery', 'yes', '2024-09-28');
INSERT INTO `operation_category` (`id`, `category`, `is_active`, `created_at`) VALUES (3, 'C-section', 'yes', '2024-09-28');
INSERT INTO `operation_category` (`id`, `category`, `is_active`, `created_at`) VALUES (4, 'Orthopaedic Surgery', 'yes', '2024-09-28');


#
# TABLE STRUCTURE FOR: operation_theatre
#

DROP TABLE IF EXISTS `operation_theatre`;

CREATE TABLE `operation_theatre` (
  `id` int NOT NULL AUTO_INCREMENT,
  `opd_details_id` int DEFAULT NULL,
  `ipd_details_id` int DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `operation_id` int NOT NULL,
  `date` datetime DEFAULT NULL,
  `operation_type` varchar(100) DEFAULT NULL,
  `consultant_doctor` int DEFAULT NULL,
  `ass_consultant_1` varchar(50) DEFAULT NULL,
  `ass_consultant_2` varchar(50) DEFAULT NULL,
  `anesthetist` varchar(50) DEFAULT NULL,
  `anaethesia_type` varchar(50) DEFAULT NULL,
  `ot_technician` varchar(100) DEFAULT NULL,
  `ot_assistant` varchar(100) DEFAULT NULL,
  `result` text,
  `remark` text,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `consultant_doctor` (`consultant_doctor`),
  KEY `generated_by` (`generated_by`),
  KEY `operation_id` (`operation_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `operation_theatre_ibfk_1` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_2` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_3` FOREIGN KEY (`consultant_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `operation_theatre_ibfk_5` FOREIGN KEY (`operation_id`) REFERENCES `operation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `operation_theatre` (`id`, `opd_details_id`, `ipd_details_id`, `customer_type`, `operation_id`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `generated_by`, `created_at`) VALUES (3, NULL, 2, NULL, 1, '2024-09-28 16:12:00', NULL, 2, '', '', '', '', '', '', '', '', 1, '2024-09-28 10:42:44');
INSERT INTO `operation_theatre` (`id`, `opd_details_id`, `ipd_details_id`, `customer_type`, `operation_id`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `generated_by`, `created_at`) VALUES (4, 25, NULL, NULL, 2, '2024-10-08 16:13:00', NULL, 2, '', '', '', '', '', '', '', '', 1, '2024-10-08 10:43:21');
INSERT INTO `operation_theatre` (`id`, `opd_details_id`, `ipd_details_id`, `customer_type`, `operation_id`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `generated_by`, `created_at`) VALUES (5, 28, NULL, NULL, 3, '2024-10-09 15:03:00', NULL, 2, '', '', '', '', 'ajay', '', '', '', 1, '2024-10-09 09:34:00');
INSERT INTO `operation_theatre` (`id`, `opd_details_id`, `ipd_details_id`, `customer_type`, `operation_id`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `generated_by`, `created_at`) VALUES (6, NULL, 4, NULL, 1, '2024-10-09 16:01:00', NULL, 2, 'abhay', '', '', '', '', '', '', '', 1, '2024-10-09 10:31:19');


#
# TABLE STRUCTURE FOR: organisation
#

DROP TABLE IF EXISTS `organisation`;

CREATE TABLE `organisation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `organisation_name` varchar(200) NOT NULL,
  `code` varchar(50) NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact_person_name` varchar(200) NOT NULL,
  `contact_person_phone` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_organisation_name` (`organisation_name`),
  KEY `index_code` (`code`),
  KEY `index_contact_no` (`contact_no`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (1, 'HDFC Health insurrance', '032', '98790678', '', 'Vinay Mehra', '8890890657', '2024-09-26 07:11:03');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (3, 'Health insurance', '1234', '1234467648', '', '', '', '2024-09-30 12:10:58');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (4, 'LIC health', '2345', '35456546', '', '', '', '2024-09-30 12:16:44');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (5, 'ayushmaan ', '1234', '45567675', '', '', '', '2024-10-05 07:40:40');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (6, 'CGHS card', '100', '347672877', 'jabalpur', '', '', '2024-10-08 07:26:07');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (7, 'Medical health insurance', '111', '45466566', '', '', '', '2024-10-11 11:41:13');


#
# TABLE STRUCTURE FOR: organisations_charges
#

DROP TABLE IF EXISTS `organisations_charges`;

CREATE TABLE `organisations_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `org_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `org_charge` float(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `organisations_charges_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `organisations_charges_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb3;

INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (2, 1, 1, '100.00', '2024-09-26 07:11:34');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (4, 1, 2, '100.00', '2024-09-26 07:12:12');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (6, 1, 3, '200.00', '2024-09-26 07:13:47');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (8, 1, 4, '110.00', '2024-09-26 07:14:40');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (13, 5, 7, '0.00', '2024-10-07 09:09:43');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (14, 4, 7, '0.00', '2024-10-07 09:09:43');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (15, 3, 7, '0.00', '2024-10-07 09:09:43');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (16, 1, 7, '0.00', '2024-10-07 09:09:43');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (17, 6, 8, '100.00', '2024-10-08 09:25:50');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (18, 5, 8, '0.00', '2024-10-08 08:11:46');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (19, 4, 8, '0.00', '2024-10-08 08:11:46');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (20, 3, 8, '0.00', '2024-10-08 08:11:46');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (21, 1, 8, '0.00', '2024-10-08 08:11:46');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (22, 6, 9, '4.00', '2024-10-08 09:26:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (23, 5, 9, '5.00', '2024-10-08 08:22:40');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (24, 4, 9, '5.00', '2024-10-08 08:22:40');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (25, 3, 9, '5.00', '2024-10-08 08:22:40');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (26, 1, 9, '5.00', '2024-10-08 08:22:40');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (27, 6, 10, '5.00', '2024-10-08 08:23:37');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (28, 5, 10, '5.00', '2024-10-08 08:23:37');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (29, 4, 10, '5.00', '2024-10-08 08:23:37');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (30, 3, 10, '5.00', '2024-10-08 08:23:37');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (31, 1, 10, '5.00', '2024-10-08 08:23:37');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (32, 6, 11, '5.00', '2024-10-08 08:24:31');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (33, 5, 11, '5.00', '2024-10-08 08:24:31');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (34, 4, 11, '5.00', '2024-10-08 08:24:31');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (35, 3, 11, '5.00', '2024-10-08 08:24:31');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (36, 1, 11, '5.00', '2024-10-08 08:24:31');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (37, 6, 12, '200.00', '2024-10-08 10:32:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (38, 5, 12, '200.00', '2024-10-08 10:32:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (39, 4, 12, '200.00', '2024-10-08 10:32:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (40, 3, 12, '200.00', '2024-10-08 10:32:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (41, 1, 12, '200.00', '2024-10-08 10:32:16');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (42, 6, 13, '600.00', '2024-10-08 10:50:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (43, 5, 13, '200.00', '2024-10-08 10:50:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (44, 4, 13, '100.00', '2024-10-08 10:50:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (45, 3, 13, '50.00', '2024-10-08 10:50:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (46, 1, 13, '100.00', '2024-10-08 10:50:39');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (47, 6, 14, '300.00', '2024-10-08 11:18:48');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (48, 5, 14, '0.00', '2024-10-08 11:18:48');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (49, 4, 14, '0.00', '2024-10-08 11:18:48');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (50, 3, 14, '0.00', '2024-10-08 11:18:48');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (51, 1, 14, '0.00', '2024-10-08 11:18:48');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (52, 6, 15, '0.00', '2024-10-09 08:26:57');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (53, 5, 15, '0.00', '2024-10-09 08:26:57');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (54, 4, 15, '0.00', '2024-10-09 08:26:57');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (55, 3, 15, '0.00', '2024-10-09 08:26:57');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (56, 1, 15, '0.00', '2024-10-09 08:26:57');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (57, 6, 16, '0.00', '2024-10-09 10:47:30');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (58, 5, 16, '0.00', '2024-10-09 10:47:30');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (59, 4, 16, '0.00', '2024-10-09 10:47:30');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (60, 3, 16, '0.00', '2024-10-09 10:47:30');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_id`, `org_charge`, `created_at`) VALUES (61, 1, 16, '0.00', '2024-10-09 10:47:30');


#
# TABLE STRUCTURE FOR: pathology
#

DROP TABLE IF EXISTS `pathology`;

CREATE TABLE `pathology` (
  `id` int NOT NULL AUTO_INCREMENT,
  `test_name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `pathology_category_id` int DEFAULT NULL,
  `unit` varchar(50) NOT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `charge_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pathology_category_id` (`pathology_category_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`),
  KEY `index_unit` (`unit`),
  KEY `index_sub_category` (`sub_category`),
  KEY `index_report_days` (`report_days`),
  KEY `index_method` (`method`),
  CONSTRAINT `pathology_ibfk_1` FOREIGN KEY (`pathology_category_id`) REFERENCES `pathology_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (3, 'suger', 'sur', '', 4, '', '', '1', '', 2, '2024-10-07 11:43:44');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (4, 'thyroid', 'TSH', '', 4, '', '', '0', '', 10, '2024-10-08 08:56:43');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (5, 'antifungle', 'micro', '', 5, '', '', '0', '', 10, '2024-10-10 09:20:59');


#
# TABLE STRUCTURE FOR: pathology_billing
#

DROP TABLE IF EXISTS `pathology_billing`;

CREATE TABLE `pathology_billing` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_reference_id` int DEFAULT NULL,
  `ipd_prescription_basic_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `doctor_id` int DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) DEFAULT '0.00',
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `discount` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT '0.00',
  `tax` float(10,2) DEFAULT '0.00',
  `net_amount` float(10,2) DEFAULT '0.00',
  `transaction_id` int DEFAULT NULL,
  `note` text,
  `organisation_id` int DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `organisation_id` (`organisation_id`),
  CONSTRAINT `pathology_billing_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_2` FOREIGN KEY (`doctor_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pathology_billing_ibfk_6` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_billing_ibfk_7` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology_billing` (`id`, `case_reference_id`, `ipd_prescription_basic_id`, `date`, `patient_id`, `doctor_id`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `generated_by`, `created_at`, `updated_at`, `insurance_id`) VALUES (2, NULL, NULL, '2024-10-01 10:16:00', 5, 2, 'Ajay Verma (9002)', '50.00', '0.00', '0.00', '0.00', '7.50', '57.50', NULL, '', NULL, NULL, 1, '2024-10-01 04:46:20', NULL, NULL);
INSERT INTO `pathology_billing` (`id`, `case_reference_id`, `ipd_prescription_basic_id`, `date`, `patient_id`, `doctor_id`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `generated_by`, `created_at`, `updated_at`, `insurance_id`) VALUES (3, NULL, NULL, '2024-10-08 16:05:00', 7, 2, 'Ajay Verma (9002)', '150.00', '0.00', '0.00', '0.00', '27.00', '177.00', NULL, '', 6, '2025-10-29', 1, '2024-10-08 10:37:04', NULL, '100');
INSERT INTO `pathology_billing` (`id`, `case_reference_id`, `ipd_prescription_basic_id`, `date`, `patient_id`, `doctor_id`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `generated_by`, `created_at`, `updated_at`, `insurance_id`) VALUES (4, NULL, NULL, '2024-10-09 16:53:00', 7, 2, 'Ajay Verma (9002)', '150.00', '0.00', '0.00', '0.00', '22.50', '172.50', NULL, '', NULL, NULL, 1, '2024-10-09 12:02:45', NULL, NULL);
INSERT INTO `pathology_billing` (`id`, `case_reference_id`, `ipd_prescription_basic_id`, `date`, `patient_id`, `doctor_id`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `generated_by`, `created_at`, `updated_at`, `insurance_id`) VALUES (5, NULL, NULL, '2024-10-10 02:23:00', 7, 2, 'Ajay Verma (9002)', '150.00', '0.00', '0.00', '0.00', '27.00', '177.00', NULL, '', NULL, NULL, 1, '2024-10-10 09:23:40', NULL, NULL);


#
# TABLE STRUCTURE FOR: pathology_category
#

DROP TABLE IF EXISTS `pathology_category`;

CREATE TABLE `pathology_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_category_name` (`category_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (1, 'Hematology', '2024-09-27 09:52:25');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (2, 'virology', '2024-09-27 09:52:40');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (4, 'Pathology', '2024-10-07 11:41:23');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (5, 'Microbiology', '2024-10-10 09:13:18');


#
# TABLE STRUCTURE FOR: pathology_parameter
#

DROP TABLE IF EXISTS `pathology_parameter`;

CREATE TABLE `pathology_parameter` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` int DEFAULT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `unit` (`unit`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`),
  CONSTRAINT `pathology_parameter_ibfk_1` FOREIGN KEY (`unit`) REFERENCES `unit` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (1, 'Thyroid antibodies', '', '0.4-4.0', '0.4', '4.0', '', 4, '	The TSH test measures the level of thyroid-stimulating hormone in your blood. The TSH has a normal test range between 0.4 and 4.0 milli-international units of hormone per liter of blood (mIU/L). If you show signs of hypothyroidism and have a TSH reading above 4.5 mIU/L, you\'re at risk of progressing to hypothyroidism.', '2024-09-27 09:56:16');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (2, 'RBC', '', '4.1	million/mm3	-5.1 1	million/mm3	', '4.1	million/mm3	', '5.1 1	million/mm3	', '', 4, 'RBC blood test', '2024-09-27 09:58:02');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (3, 'WBC', '', '0.5-5.0', '0.5', '5.0', '', 4, '', '2024-10-07 12:03:13');


#
# TABLE STRUCTURE FOR: pathology_parameterdetails
#

DROP TABLE IF EXISTS `pathology_parameterdetails`;

CREATE TABLE `pathology_parameterdetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pathology_id` int DEFAULT NULL,
  `pathology_parameter_id` int DEFAULT NULL,
  `created_id` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `pathology_parameter_id` (`pathology_parameter_id`),
  CONSTRAINT `pathology_parameterdetails_ibfk_1` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_parameterdetails_ibfk_2` FOREIGN KEY (`pathology_parameter_id`) REFERENCES `pathology_parameter` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `pathology_parameter_id`, `created_id`) VALUES (3, 3, 2, '2024-10-07 11:43:44');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `pathology_parameter_id`, `created_id`) VALUES (4, 4, 1, '2024-10-08 08:56:43');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `pathology_parameter_id`, `created_id`) VALUES (5, 5, 2, '2024-10-10 09:20:59');


#
# TABLE STRUCTURE FOR: pathology_report
#

DROP TABLE IF EXISTS `pathology_report`;

CREATE TABLE `pathology_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pathology_bill_id` int DEFAULT NULL,
  `pathology_id` int DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `tax_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `apply_charge` float(10,2) NOT NULL,
  `collection_date` date DEFAULT NULL,
  `collection_specialist` int DEFAULT NULL,
  `pathology_center` varchar(250) DEFAULT NULL,
  `approved_by` int DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `description` text,
  `pathology_report` varchar(255) DEFAULT NULL,
  `report_name` text,
  `pathology_result` text COMMENT 'test result',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `pathology_bill_id` (`pathology_bill_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_collection_date` (`collection_date`),
  CONSTRAINT `pathology_report_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_2` FOREIGN KEY (`pathology_bill_id`) REFERENCES `pathology_billing` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_3` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_4` FOREIGN KEY (`collection_specialist`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_ibfk_5` FOREIGN KEY (`approved_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pathology_report` (`id`, `pathology_bill_id`, `pathology_id`, `customer_type`, `patient_id`, `reporting_date`, `parameter_update`, `tax_percentage`, `apply_charge`, `collection_date`, `collection_specialist`, `pathology_center`, `approved_by`, `patient_name`, `description`, `pathology_report`, `report_name`, `pathology_result`, `created_at`) VALUES (3, 3, 4, NULL, 7, '2024-10-08', NULL, '18.00', '150.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2024-10-08 10:37:04');
INSERT INTO `pathology_report` (`id`, `pathology_bill_id`, `pathology_id`, `customer_type`, `patient_id`, `reporting_date`, `parameter_update`, `tax_percentage`, `apply_charge`, `collection_date`, `collection_specialist`, `pathology_center`, `approved_by`, `patient_name`, `description`, `pathology_report`, `report_name`, `pathology_result`, `created_at`) VALUES (4, 4, 3, NULL, 7, '2024-10-16', NULL, '15.00', '150.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2024-10-09 12:02:45');
INSERT INTO `pathology_report` (`id`, `pathology_bill_id`, `pathology_id`, `customer_type`, `patient_id`, `reporting_date`, `parameter_update`, `tax_percentage`, `apply_charge`, `collection_date`, `collection_specialist`, `pathology_center`, `approved_by`, `patient_name`, `description`, `pathology_report`, `report_name`, `pathology_result`, `created_at`) VALUES (5, 5, 5, NULL, 7, '2024-10-10', NULL, '18.00', '150.00', '2024-10-09', 5, 'In-House Pathology Lab', NULL, NULL, NULL, NULL, NULL, NULL, '2024-10-10 09:23:40');


#
# TABLE STRUCTURE FOR: pathology_report_parameterdetails
#

DROP TABLE IF EXISTS `pathology_report_parameterdetails`;

CREATE TABLE `pathology_report_parameterdetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pathology_report_id` int DEFAULT NULL,
  `pathology_parameterdetail_id` int DEFAULT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pathology_report_id` (`pathology_report_id`),
  KEY `pathology_parameterdetail_id` (`pathology_parameterdetail_id`),
  CONSTRAINT `pathology_report_parameterdetails_ibfk_1` FOREIGN KEY (`pathology_report_id`) REFERENCES `pathology_report` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pathology_report_parameterdetails_ibfk_2` FOREIGN KEY (`pathology_parameterdetail_id`) REFERENCES `pathology_parameterdetails` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: patient_bed_history
#

DROP TABLE IF EXISTS `patient_bed_history`;

CREATE TABLE `patient_bed_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_reference_id` int DEFAULT NULL,
  `bed_group_id` int DEFAULT NULL,
  `bed_id` int DEFAULT NULL,
  `revert_reason` text,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `is_active` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed_id` (`bed_id`),
  KEY `index_from_date` (`from_date`),
  KEY `index_to_date` (`to_date`),
  CONSTRAINT `patient_bed_history_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_bed_history_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_bed_history_ibfk_3` FOREIGN KEY (`bed_id`) REFERENCES `bed` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patient_bed_history` (`id`, `case_reference_id`, `bed_group_id`, `bed_id`, `revert_reason`, `from_date`, `to_date`, `is_active`, `created_at`) VALUES (1, 3, 1, 1, NULL, '2024-09-26 17:32:00', NULL, 'yes', '2024-09-26 12:02:21');
INSERT INTO `patient_bed_history` (`id`, `case_reference_id`, `bed_group_id`, `bed_id`, `revert_reason`, `from_date`, `to_date`, `is_active`, `created_at`) VALUES (2, 9, 3, 3, NULL, '2024-09-28 13:38:00', NULL, 'yes', '2024-09-28 08:08:25');
INSERT INTO `patient_bed_history` (`id`, `case_reference_id`, `bed_group_id`, `bed_id`, `revert_reason`, `from_date`, `to_date`, `is_active`, `created_at`) VALUES (3, 23, 2, 2, NULL, '2024-10-01 10:06:00', NULL, 'yes', '2024-10-01 04:36:56');
INSERT INTO `patient_bed_history` (`id`, `case_reference_id`, `bed_group_id`, `bed_id`, `revert_reason`, `from_date`, `to_date`, `is_active`, `created_at`) VALUES (4, 26, 2, 4, NULL, '2024-10-08 13:19:00', NULL, 'yes', '2024-10-08 07:50:31');


#
# TABLE STRUCTURE FOR: patient_charges
#

DROP TABLE IF EXISTS `patient_charges`;

CREATE TABLE `patient_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `ipd_id` int DEFAULT NULL,
  `opd_id` int DEFAULT NULL,
  `qty` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT '0.00',
  `tpa_charge` float(10,2) DEFAULT '0.00',
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `tax` float(10,2) DEFAULT '0.00',
  `apply_charge` float(10,2) DEFAULT '0.00',
  `amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `organisation_id` int DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `opd_id` (`opd_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `charge_id` (`charge_id`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_qty` (`qty`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tpa_charge` (`tpa_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `patient_charges_ibfk_1` FOREIGN KEY (`opd_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_2` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_charges_ibfk_4` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (10, '2024-09-28 15:35:47', NULL, 8, 1, 1, '200.00', '0.00', '0.00', '18.00', '200.00', '236.00', 'Ajay Verma', NULL, NULL, NULL, '2024-09-28 15:35:47');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (13, '2024-09-28 16:07:14', NULL, 11, 1, 1, '200.00', '0.00', '33.00', '18.00', '200.00', '0.00', NULL, NULL, NULL, NULL, '2024-09-28 16:07:14');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (14, '2024-09-28 16:07:32', NULL, 12, 1, 1, '200.00', '0.00', '33.00', '18.00', '200.00', '0.00', NULL, NULL, NULL, NULL, '2024-09-28 16:07:32');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (15, '2024-09-28 16:07:41', NULL, 13, 1, 1, '200.00', '0.00', '33.00', '18.00', '200.00', '0.00', NULL, NULL, NULL, NULL, '2024-09-28 16:07:41');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (16, '2024-09-28 16:07:48', NULL, 14, 1, 1, '200.00', '0.00', '33.00', '18.00', '200.00', '0.00', NULL, NULL, NULL, NULL, '2024-09-28 16:07:48');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (23, '2024-10-03 15:26:00', 3, NULL, 1, 2, '150.00', '100.00', '0.00', '15.00', '150.00', '172.50', '', NULL, NULL, NULL, '2024-10-03 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (25, '2024-10-07 17:31:39', NULL, 22, 1, 1, '200.00', '0.00', '2.00', '18.00', '200.00', '231.28', NULL, NULL, NULL, NULL, '2024-10-07 17:31:39');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (26, '2024-10-08 13:21:00', NULL, 23, 1, 2, '0.00', '0.00', '5.00', '0.00', '400.00', '0.00', '', 6, '2025-10-29', '100', '2024-10-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (27, '2024-10-08 13:46:00', NULL, 24, 1, 8, '4.00', '0.00', '0.00', '15.00', '0.00', '0.00', '', 6, '2025-10-29', '100', '2024-10-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (28, '2024-10-08 16:05:00', NULL, 25, 1, 12, '200.00', '200.00', '0.00', '15.00', '200.00', '230.00', 'Ajay Verma', 6, '2025-10-29', '100', '2024-10-08 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (29, '2024-10-09 12:59:57', NULL, 26, 1, 1, '200.00', '0.00', '3.00', '18.00', '200.00', '228.92', NULL, NULL, NULL, NULL, '2024-10-09 12:59:57');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (30, '2024-10-09 13:53:12', NULL, 27, 1, 1, '200.00', '0.00', '4.00', '18.00', '200.00', '226.56', NULL, NULL, NULL, NULL, '2024-10-09 13:53:12');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (31, '2024-10-09 14:02:00', NULL, 28, 1, 2, '150.00', '0.00', '0.00', '15.00', '150.00', '172.50', '', NULL, NULL, '', '2024-10-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (32, '2024-10-09 14:02:00', NULL, 28, 1, 2, '150.00', NULL, '0.00', '15.00', '150.00', '172.50', '', NULL, NULL, NULL, '2024-10-09 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (33, '2024-10-09 16:23:00', 4, NULL, 1, 16, '200.00', '0.00', '0.00', '15.00', '200.00', '230.00', '', NULL, NULL, NULL, '2024-10-09 00:00:00');


#
# TABLE STRUCTURE FOR: patient_id_card
#

DROP TABLE IF EXISTS `patient_id_card`;

CREATE TABLE `patient_id_card` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `hospital_name` varchar(100) NOT NULL,
  `hospital_address` varchar(500) NOT NULL,
  `background` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `logo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `sign_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_patient_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_guardian_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_patient_unique_id` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_barcode` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_hospital_name` (`hospital_name`),
  KEY `index_hospital_address` (`hospital_address`),
  KEY `index_header_color` (`header_color`),
  KEY `index_enable_patient_name` (`enable_patient_name`),
  KEY `index_enable_guardian_name` (`enable_guardian_name`),
  KEY `index_enable_patient_unique_id` (`enable_patient_unique_id`),
  KEY `index_enable_address` (`enable_address`),
  KEY `index_enable_phone` (`enable_phone`),
  KEY `index_enable_dob` (`enable_dob`),
  KEY `index_enable_blood_group` (`enable_blood_group`),
  KEY `index_status` (`status`),
  KEY `index_enable_barcode` (`enable_barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patient_id_card` (`id`, `title`, `hospital_name`, `hospital_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_patient_name`, `enable_guardian_name`, `enable_patient_unique_id`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`, `enable_barcode`, `created_at`) VALUES (1, 'Sample Patient Id Card', 'Royal Hospital', 'Nr Loyala Ashram, A 69, Shahpura Rd, Manisha Market, Sector  Bhopal', 'background.jpg', 'logo.jpg', 'signature.png', '#0796f5', 1, 1, 1, 1, 1, 1, 1, 1, 1, '2021-10-19 07:06:02');
INSERT INTO `patient_id_card` (`id`, `title`, `hospital_name`, `hospital_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_patient_name`, `enable_guardian_name`, `enable_patient_unique_id`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`, `enable_barcode`, `created_at`) VALUES (2, 'ID card', 'GLOBAL hospital', 'hospital@gmail.com', '', '', '', '#960f0f', 1, 1, 1, 1, 1, 1, 1, 1, 1, '2024-10-01 09:07:33');


#
# TABLE STRUCTURE FOR: patient_timeline
#

DROP TABLE IF EXISTS `patient_timeline`;

CREATE TABLE `patient_timeline` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` datetime DEFAULT NULL,
  `description` text,
  `document` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `status` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `generated_users_type` varchar(100) NOT NULL,
  `generated_users_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_users_id` (`generated_users_id`),
  KEY `index_title` (`title`),
  KEY `index_date` (`date`),
  KEY `index_timeline_date` (`timeline_date`),
  CONSTRAINT `patient_timeline_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patient_timeline_ibfk_2` FOREIGN KEY (`generated_users_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patient_timeline` (`id`, `patient_id`, `title`, `timeline_date`, `description`, `document`, `status`, `date`, `generated_users_type`, `generated_users_id`, `created_at`) VALUES (3, 5, 'document', '2024-10-03 15:10:00', '', '', 'yes', '2024-10-03 00:00:00', 'staff', 7, '2024-10-03 09:40:49');
INSERT INTO `patient_timeline` (`id`, `patient_id`, `title`, `timeline_date`, `description`, `document`, `status`, `date`, `generated_users_type`, `generated_users_id`, `created_at`) VALUES (4, 7, 'DOCUMENT', '2024-10-08 16:14:00', 'hello', '', 'yes', '2024-10-09 00:00:00', 'staff', 1, '2024-10-08 10:45:00');
INSERT INTO `patient_timeline` (`id`, `patient_id`, `title`, `timeline_date`, `description`, `document`, `status`, `date`, `generated_users_type`, `generated_users_id`, `created_at`) VALUES (5, 3, 'document', '2024-10-09 15:08:00', '', '', 'yes', '2024-10-09 00:00:00', 'staff', 1, '2024-10-09 09:39:13');


#
# TABLE STRUCTURE FOR: patients
#

DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lang_id` int DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` int NOT NULL,
  `month` int NOT NULL,
  `day` int NOT NULL,
  `as_of_date` date DEFAULT NULL,
  `image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `blood_bank_product_id` int DEFAULT NULL,
  `address` text,
  `guardian_name` varchar(100) DEFAULT NULL,
  `patient_type` varchar(200) NOT NULL,
  `identification_number` varchar(60) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  `organisation_id` int DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `is_dead` varchar(255) NOT NULL DEFAULT 'no',
  `is_antenatal` int NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `disable_at` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `idx_patient_name` (`patient_name`),
  KEY `idx_dob` (`dob`),
  KEY `idx_age` (`age`),
  KEY `idx_month` (`month`),
  KEY `idx_mobileno` (`mobileno`),
  KEY `idx_email` (`email`),
  KEY `idx_gender` (`gender`),
  KEY `idx_marital_status` (`marital_status`),
  KEY `idx_address` (`address`(500)),
  KEY `idx_guardian_name` (`guardian_name`),
  KEY `organisation_id` (`organisation_id`),
  CONSTRAINT `patients_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_ibfk_2` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (3, NULL, 'Sophi Paul', '2003-05-07', 21, 4, 21, '2024-09-28', 'uploads/patient_images/no_image.png', '', 'sophi@gmail.com', 'Female', 'Married', '', 2, '', 'Garry Paul', '', '', '', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2024-10-09 08:32:30');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (4, NULL, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, '', '', NULL, NULL, NULL, '', '', '', '', '', '', NULL, NULL, NULL, 'yes', 0, 'no', NULL, '2024-09-30 09:42:41');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (5, NULL, 'Aruna Kumar', '1999-05-03', 25, 4, 29, '2024-10-01', 'uploads/patient_images/no_image.png', '', '', 'Female', 'Married', '', 2, '', 'Karan', '', '', '', '', '', '', NULL, '', NULL, 'yes', 1, 'yes', NULL, '2024-10-04 12:11:56');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (6, NULL, 'rashi', '2020-10-01', 4, 0, 6, '2024-10-07', 'uploads/patient_images/no_image.png', '547456677', '', 'Male', 'Single', '', 2, '', '', '', '', '', '', '', '', 5, '4356675656', '2025-10-28', 'no', 0, 'yes', NULL, '2024-10-07 08:01:03');
INSERT INTO `patients` (`id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`) VALUES (7, NULL, 'Nidhi barma', '1987-10-15', 36, 11, 24, '2024-10-08', 'uploads/patient_images/no_image.png', '9826244698', 'nidhi@gmail.com', 'Female', 'Married', '', 7, 'navy mumbai', 'ramesh', '', '12345', '', '', '', '', 6, '100', '2025-10-29', 'no', 0, 'yes', NULL, '2024-10-08 07:45:48');


#
# TABLE STRUCTURE FOR: patients_vitals
#

DROP TABLE IF EXISTS `patients_vitals`;

CREATE TABLE `patients_vitals` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `vital_id` int NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `messure_date` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_messure_date` (`messure_date`),
  KEY `vital_id` (`vital_id`),
  CONSTRAINT `patients_vitals_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_vitals_ibfk_2` FOREIGN KEY (`vital_id`) REFERENCES `vitals` (`id`) ON DELETE CASCADE,
  CONSTRAINT `patients_vitals_ibfk_3` FOREIGN KEY (`vital_id`) REFERENCES `vitals` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (2, 5, 1, '23-34', '2024-10-03 17:42:00', '2024-10-03 12:12:22');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (3, 7, 2, '65', '2024-10-08 16:15:00', '2024-10-08 10:45:32');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (4, 3, 1, '4.5', '2024-10-09 15:10:00', '2024-10-09 09:40:35');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (5, 7, 2, '50', '2024-10-09 16:52:00', '2024-10-09 11:23:00');


#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_payment_type` (`payment_type`),
  KEY `index_api_username` (`api_username`),
  KEY `index_api_secret_key` (`api_secret_key`),
  KEY `index_salt` (`salt`),
  KEY `index_api_publishable_key` (`api_publishable_key`),
  KEY `index_paytm_website` (`paytm_website`),
  KEY `index_paytm_industrytype` (`paytm_industrytype`),
  KEY `index_api_password` (`api_password`),
  KEY `index_api_signature` (`api_signature`),
  KEY `index_api_email` (`api_email`),
  KEY `index_paypal_demo` (`paypal_demo`),
  KEY `index_account_no` (`account_no`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (1, 'stripe', NULL, 'sk_test_YLQh86Az2IdcuqfQQOx47yam', '', 'pk_test_nYHEZ1mJ8FpaoXV4KVxQs7qR', '', '', NULL, NULL, NULL, '', '', 'yes', '2024-09-28 10:06:18');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (2, 'paystack', NULL, 'sk_test_cd0be6933536323c671f994cc4e85bec4f15b832', '', '', '', '', NULL, NULL, NULL, '', '', 'no', '2024-09-28 10:06:18');


#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_payslip_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `staff_payslip_id` (`staff_payslip_id`),
  KEY `index_allowance_type` (`allowance_type`),
  KEY `index_amount` (`amount`),
  KEY `index_cal_type` (`cal_type`),
  CONSTRAINT `payslip_allowance_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `payslip_allowance_ibfk_2` FOREIGN KEY (`staff_payslip_id`) REFERENCES `staff_payslip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (1, 1, 4, '15000', '0', 'positive', '2024-09-30 09:54:09');
INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (2, 1, 4, '300', '0', 'negative', '2024-09-30 09:54:09');
INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (5, 4, 7, '', '0', 'positive', '2024-10-04 12:40:44');
INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (6, 4, 7, '', '0', 'negative', '2024-10-04 12:40:44');
INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (7, 5, 2, '30000', '0', 'positive', '2024-10-11 10:22:11');
INSERT INTO `payslip_allowance` (`id`, `staff_payslip_id`, `staff_id`, `allowance_type`, `amount`, `cal_type`, `created_at`) VALUES (8, 5, 2, '', '0', 'negative', '2024-10-11 10:22:11');


#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `perm_group_id` int DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int DEFAULT '0',
  `enable_add` int DEFAULT '0',
  `enable_edit` int DEFAULT '0',
  `enable_delete` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11003 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-21 23:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-21 23:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-21 23:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-21 23:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Content Type', 'content_type', 1, 1, 1, 1, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 0, 1, '2018-12-16 22:55:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-21 23:35:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-21 23:35:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-21 23:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-21 23:36:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-21 23:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-21 23:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'OPD Report', 'opd_report', 1, 0, 0, 0, '2018-12-17 21:59:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 1, 1, 0, 0, '2021-09-12 22:56:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-04 22:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-04 22:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-04 22:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-04 22:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-04 22:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-08 16:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-08 16:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-21 23:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-21 23:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-21 23:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-21 23:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-02 21:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-21 23:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-21 23:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-21 23:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-21 23:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complain', 1, 1, 1, 1, '2018-12-18 22:11:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Front Office', 'setup_front_office', 1, 1, 1, 1, '2018-11-14 13:49:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-21 23:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-21 23:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-21 23:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2021-09-13 02:12:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 1, 1, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2021-09-13 02:13:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-21 23:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-21 23:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-01 23:17:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 1, '2020-08-24 14:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'LeaveTypes', 'leave_types', 1, 1, 1, 1, '2021-10-26 11:54:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-25 16:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-25 16:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-02 20:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'Users', 'users', 1, 0, 0, 0, '2021-09-21 19:43:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-02 21:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-04 21:08:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-08 17:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-08 17:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (132, 23, 'OPD Patient', 'opd_patient', 1, 1, 1, 1, '2018-12-19 22:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 23, 'Prescription', 'prescription', 1, 1, 1, 1, '2018-10-10 14:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 23, 'Visit', 'visit', 1, 1, 1, 1, '2021-09-16 20:39:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 23, 'OPD Timeline', 'opd_timeline', 1, 1, 1, 1, '2021-02-24 01:02:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (138, 24, 'IPD Patients', 'ipd_patient', 1, 1, 1, 1, '2018-10-10 20:14:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (139, 24, 'Discharged Patients', 'discharged_patients', 1, 1, 1, 1, '2021-02-24 01:27:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (140, 24, 'Consultant Register', 'consultant_register', 1, 1, 1, 1, '2021-02-24 01:37:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 24, 'IPD Timeline', 'ipd_timeline', 1, 1, 1, 1, '2021-02-25 01:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 24, 'Charges', 'charges', 1, 1, 1, 1, '2018-10-10 14:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 24, 'Payment', 'payment', 1, 1, 1, 1, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 25, 'Medicine', 'medicine', 1, 1, 1, 1, '2018-10-10 14:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 25, 'Pharmacy Bill', 'pharmacy_bill', 1, 1, 1, 1, '2021-02-25 01:33:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 26, 'Pathology Test', 'pathology_test', 1, 1, 1, 1, '2021-02-25 01:36:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 27, 'Radiology Test', 'radiology_test', 1, 1, 1, 1, '2021-02-25 01:45:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 27, 'Radiology  Bill', 'radiology_bill', 1, 1, 1, 1, '2021-09-16 18:16:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 22, 'IPD Income Widget', 'ipd_income_widget', 1, 0, 0, 0, '2018-12-19 22:08:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 22, 'OPD Income Widget', 'opd_income_widget', 1, 0, 0, 0, '2018-12-19 22:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 22, 'Pharmacy Income Widget', 'pharmacy_income_widget', 1, 0, 0, 0, '2018-12-19 22:08:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 22, 'Pathology Income Widget', 'pathology_income_widget', 1, 0, 0, 0, '2018-12-19 22:08:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 22, 'Radiology Income Widget', 'radiology_income_widget', 1, 0, 0, 0, '2018-12-19 22:08:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 22, 'Blood Bank Income Widget', 'blood_bank_income_widget', 1, 0, 0, 0, '2018-12-19 22:09:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 22, 'Ambulance Income Widget', 'ambulance_income_widget', 1, 0, 0, 0, '2018-12-19 22:09:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 29, 'Ambulance Call', 'ambulance_call', 1, 1, 1, 1, '2018-10-26 16:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (166, 29, 'Ambulance', 'ambulance', 1, 1, 1, 1, '2018-10-26 16:37:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (168, 30, 'Blood Issue', 'blood_issue', 1, 1, 1, 1, '2018-10-26 17:20:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (169, 30, 'Blood Donor', 'blood_donor', 1, 1, 1, 1, '2018-10-26 17:20:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (170, 25, 'Medicine Category', 'medicine_category', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (171, 27, 'Radiology Category', 'radiology_category', 1, 1, 1, 1, '2021-02-25 01:52:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (173, 31, 'Organisation', 'organisation', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 26, 'Pathology Category', 'pathology_category', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 32, 'Hospital Charges', 'hospital_charges', 1, 1, 1, 1, '2021-09-12 20:29:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'IPD Report', 'ipd_report', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Pharmacy Bill Report', 'pharmacy_bill_report', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Pathology Patient Report', 'pathology_patient_report', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Radiology Patient Report', 'radiology_patient_report', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'OT Report', 'ot_report', 1, 0, 0, 0, '2019-03-07 19:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Blood Donor Report', 'blood_donor_report', 1, 0, 0, 0, '2019-03-07 19:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (184, 14, 'Payroll Month Report', 'payroll_month_report', 1, 0, 0, 0, '2019-03-07 19:57:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 14, 'Patient Login Credential', 'patient_login_credential', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 14, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-12-11 23:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Yearly Income & Expense Chart', 'yearly_income_expense_chart', 1, 0, 0, 0, '2018-12-11 23:22:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Monthly Income & Expense Chart', 'monthly_income_expense_chart', 1, 0, 0, 0, '2018-12-11 23:25:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 23, 'OPD Prescription Print Header Footer ', 'opd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 24, 'Bed', 'bed', 1, 1, 1, 1, '2018-12-11 23:46:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 24, 'IPD Prescription Print Header Footer', 'ipd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 24, 'Bed Status', 'bed_status', 1, 0, 0, 0, '2018-12-11 23:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 25, 'Medicine Bad Stock', 'medicine_bad_stock', 1, 1, 0, 1, '2018-12-17 14:12:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 25, 'Pharmacy Bill print Header Footer', 'pharmacy_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 30, 'Blood Stock', 'blood_stock', 1, 1, 0, 1, '2021-09-10 22:49:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 32, 'Charge Category', 'charge_category', 1, 1, 1, 1, '2018-12-12 00:19:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (206, 14, 'TPA Report', 'tpa_report', 1, 0, 0, 0, '2019-03-07 19:49:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 14, 'Ambulance Report', 'ambulance_report', 1, 0, 0, 0, '2019-03-07 19:49:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 14, 'Discharge Patient Report', 'discharge_patient_report', 1, 0, 0, 0, '2019-03-07 19:49:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (209, 14, 'Appointment Report', 'appointment_report', 1, 0, 0, 0, '2019-03-07 19:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 14, 'Blood Issue Report', 'blood_issue_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 34, 'Birth Record', 'birth_record', 1, 1, 1, 1, '2018-06-21 23:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 34, 'Death Record', 'death_record', 1, 1, 1, 1, '2018-06-21 23:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (218, 23, 'Move Patient in IPD', 'opd_move_patient_in_ipd', 1, 0, 0, 0, '2021-09-16 21:00:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 23, 'Manual Prescription', 'manual_prescription', 1, 0, 0, 0, '2019-09-22 17:52:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 24, 'Prescription ', 'ipd_prescription', 1, 1, 1, 1, '2019-09-23 13:59:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 23, 'Charges', 'opd_charges', 1, 1, 1, 1, '2019-09-22 17:58:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Payment', 'opd_payment', 1, 1, 1, 1, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Import Medicine', 'import_medicine', 1, 0, 0, 0, '2019-09-22 18:03:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (225, 25, 'Medicine Purchase', 'medicine_purchase', 1, 1, 0, 1, '2021-10-02 04:59:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 25, 'Medicine Supplier', 'medicine_supplier', 1, 1, 1, 1, '2019-09-22 18:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 25, 'Medicine Dosage', 'medicine_dosage', 1, 1, 1, 1, '2019-09-22 18:17:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 36, 'Patient', 'patient', 1, 1, 1, 1, '2021-09-21 21:29:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 36, 'Enabled/Disabled', 'enabled_disabled', 1, 0, 0, 0, '2019-09-22 19:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 22, 'Notification Center', 'notification_center', 1, 0, 0, 0, '2019-09-23 16:48:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 36, 'Import', 'patient_import', 1, 0, 0, 0, '2019-10-03 14:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 34, 'Birth Print Header Footer', 'birth_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 34, 'Death Print Header Footer', 'death_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 26, 'Print Header Footer', 'pathology_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 27, 'Print Header Footer', 'radiology_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 30, 'Print Header Footer', 'bloodbank_print_header_footer', 1, 0, 0, 0, '2021-10-07 04:06:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 29, 'Print Header Footer', 'ambulance_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 24, 'IPD Bill Print Header Footer', 'ipd_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 18, 'Print Payslip Header Footer', 'print_payslip_header_footer', 1, 0, 0, 0, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2020-08-11 18:52:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-03 17:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 14, 'Inventory Stock Report', 'inventory_stock_report', 1, 0, 0, 0, '2019-10-03 18:20:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 14, 'Inventory Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-03 18:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 14, 'Inventory Issue Report', 'issue_inventory_report', 1, 0, 0, 0, '2019-10-03 18:24:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Expiry Medicine Report', 'expiry_medicine_report', 1, 0, 0, 0, '2019-10-03 19:00:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 26, 'Pathology Bill', 'pathology_bill', 1, 1, 1, 1, '2021-02-25 01:58:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Birth Report', 'birth_report', 1, 0, 0, 0, '2019-10-13 16:12:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 14, 'Death Report', 'death_report', 1, 0, 0, 0, '2019-10-13 16:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 26, 'Pathology Unit', 'pathology_unit', 1, 1, 1, 1, '2020-07-21 14:13:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 27, 'Radiology Unit', 'radiology_unit', 1, 1, 1, 1, '2020-07-21 14:14:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 27, 'Radiology Parameter', 'radiology_parameter', 1, 1, 1, 1, '2020-07-21 14:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 26, 'Pathology Parameter', 'pathology_parameter', 1, 1, 1, 1, '2020-07-21 14:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 32, 'Charge Type', 'charge_type', 1, 1, 1, 1, '2024-08-21 09:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 14, 'OPD Balance Report', 'opd_balance_report', 1, 0, 0, 0, '2020-07-27 15:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 14, 'IPD Balance Report', 'ipd_balance_report', 1, 0, 0, 0, '2020-07-27 15:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 15, 'Symptoms Type', 'symptoms_type', 1, 1, 1, 1, '2021-09-13 21:36:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 37, 'Live Consultation', 'live_consultation', 1, 1, 0, 1, '2020-08-12 19:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 37, 'Live Meeting', 'live_meeting', 1, 1, 0, 1, '2020-08-12 19:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 14, 'Live Consultation Report', 'live_consultation_report', 1, 0, 0, 0, '2021-09-13 02:11:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 14, 'Live Meeting Report', 'live_meeting_report', 1, 0, 0, 0, '2021-09-13 02:11:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 37, 'Setting', 'setting', 1, 0, 1, 0, '2020-08-12 20:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (274, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2020-08-20 17:48:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (279, 15, 'Symptoms Head', 'symptoms_head', 1, 1, 1, 1, '2021-09-13 21:36:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (280, 18, 'Specialist', 'specialist', 1, 1, 1, 1, '2019-10-03 10:01:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (281, 22, 'General Income Widget', 'general_income_widget', 1, 0, 0, 0, '2018-12-19 16:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (282, 22, 'Expenses Widget', 'expenses_widget', 1, 0, 0, 0, '2018-12-19 16:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (283, 38, 'Referral Category', 'referral_category', 1, 1, 1, 1, '2021-06-11 02:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (284, 38, 'Referral Commission', 'referral_commission', 1, 1, 1, 1, '2021-06-11 02:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (285, 38, 'Referral Person', 'referral_person', 1, 1, 1, 1, '2021-06-11 02:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (286, 38, 'Referral Payment', 'referral_payment', 1, 1, 1, 1, '2021-06-11 02:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (287, 15, 'Prefix Setting', 'prefix_setting', 1, 0, 1, 0, '2021-06-11 20:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (288, 15, 'Captcha Setting', 'captcha_setting', 1, 0, 1, 0, '2021-06-11 21:43:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (289, 32, 'Tax Category', 'tax_category', 1, 1, 1, 1, '2021-06-11 22:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (290, 32, 'Unit Type', 'unit_type', 1, 1, 1, 1, '2021-06-11 22:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (291, 25, 'Dosage Interval', 'dosage_interval', 1, 1, 1, 1, '2021-06-12 00:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (292, 25, 'Dosage Duration', 'dosage_duration', 1, 1, 1, 1, '2021-06-12 00:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (293, 30, 'Blood Bank Product', 'blood_bank_product', 1, 1, 1, 1, '2021-06-12 00:51:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (294, 39, 'Slot', 'online_appointment_slot', 1, 1, 1, 1, '2021-09-14 01:04:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (295, 39, 'Doctor Shift', 'online_appointment_doctor_shift', 1, 0, 1, 0, '2021-06-12 01:43:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (296, 39, 'Shift', 'online_appointment_shift', 1, 1, 1, 1, '2021-06-12 01:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (297, 39, 'Doctor Wise Appointment', 'doctor_wise_appointment', 1, 0, 0, 0, '2021-10-07 01:45:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (298, 39, 'Patient Queue', 'patient_queue', 1, 0, 0, 0, '2021-10-07 01:45:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (299, 23, 'OPD Medication', 'opd_medication', 1, 1, 1, 1, '2021-06-14 20:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (300, 24, 'IPD Medication', 'ipd_medication', 1, 1, 1, 1, '2021-06-14 20:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (301, 24, 'Bed History', 'bed_history', 1, 0, 0, 0, '2021-06-14 20:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (302, 30, 'Blood Bank Components', 'blood_bank_components', 1, 1, 0, 1, '2021-06-15 00:46:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (303, 23, 'Operation Theatre', 'opd_operation_theatre', 1, 1, 1, 1, '2021-09-07 22:49:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (304, 23, 'Lab Investigation', 'opd_lab_investigation', 1, 0, 0, 0, '2021-09-06 19:36:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (305, 23, 'Patient Discharge', 'opd_patient_discharge', 1, 0, 1, 0, '2021-09-06 19:39:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (306, 23, 'Patient Discharge Revert', 'opd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-06 19:39:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (307, 23, 'Treatment History', 'opd_treatment_history', 1, 0, 0, 0, '2021-09-06 19:49:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (308, 24, 'Lab Investigation', 'ipd_lab_investigation', 1, 0, 0, 0, '2021-09-06 20:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (309, 24, 'Patient Discharge', 'ipd_patient_discharge', 1, 0, 1, 0, '2021-09-06 22:08:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (310, 24, 'Patient Discharge Revert', 'ipd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-06 22:14:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (311, 30, 'Issue Component', 'issue_component', 1, 1, 1, 1, '2021-09-06 22:21:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (312, 26, '	Add/Edit Collection Person', 'pathology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 20:06:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (313, 25, 'Partial Payment', 'pharmacy_partial_payment', 1, 1, 0, 1, '2021-09-07 01:10:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (314, 26, 'Partial Payment', 'pathology_partial_payment', 1, 1, 0, 1, '2021-09-07 02:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (315, 27, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 02:38:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (316, 28, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 02:39:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (317, 30, 'Partial Payment', 'blood_bank_partial_payment', 1, 1, 0, 1, '2021-09-07 02:47:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (318, 29, 'Partial Payment', 'ambulance_partial_payment', 1, 1, 0, 1, '2021-09-07 02:48:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (319, 23, 'Checkup', 'checkup', 1, 1, 1, 1, '2021-09-16 20:40:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (320, 23, 'Print Bill', 'opd_print_bill', 1, 0, 0, 0, '2021-09-07 23:09:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (321, 23, 'Live Consult', 'opd_live_consult', 1, 0, 0, 0, '2021-09-08 00:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (322, 24, 'Nurse Note', 'nurse_note', 1, 1, 1, 1, '2021-09-08 01:20:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (323, 24, 'Bed Type', 'bed_type', 1, 1, 1, 1, '2021-09-08 20:06:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (324, 24, 'Bed Group', 'bed_group', 1, 1, 1, 1, '2021-09-08 20:07:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (325, 24, 'Floor', 'floor', 1, 1, 1, 1, '2021-09-08 20:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (326, 24, 'Operation Theatre', 'ipd_operation_theatre', 1, 1, 1, 1, '2021-09-08 22:38:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (327, 24, 'Live Consult', 'ipd_live_consultation', 1, 0, 0, 0, '2021-09-08 23:05:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (329, 24, 'Treatment History', 'ipd_treatment_history', 1, 0, 0, 0, '2021-09-06 20:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (330, 41, 'OPD Billing', 'opd_billing', 1, 0, 0, 0, '2021-09-09 00:33:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (331, 41, 'OPD Billing Payment', 'opd_billing_payment', 1, 1, 0, 0, '2021-09-09 01:10:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (332, 41, 'IPD Billing', 'ipd_billing', 1, 0, 0, 0, '2021-09-09 00:52:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (333, 41, 'IPD Billing Payment', 'ipd_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (334, 41, 'Pharmacy Billing', 'pharmacy_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (335, 41, 'Pharmacy Billing Payment', 'pharmacy_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (336, 41, 'Pathology Billing', 'pathology_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (337, 41, 'Pathology Billing Payment', 'pathology_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (338, 41, 'Radiology Billing', 'radiology_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (339, 41, 'Radiology Billing Payment', 'radiology_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (340, 41, 'Blood Bank Billing', 'blood_bank_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (341, 41, 'Blood Bank Billing Payment', 'blood_bank_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (342, 41, 'Ambulance Billing', 'ambulance_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (343, 41, 'Ambulance Billing Payment', 'ambulance_billing_payment', 1, 1, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (344, 41, 'Generate Bill', 'generate_bill', 1, 0, 0, 0, '2021-09-09 20:36:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (345, 41, 'Generate Discharge Card', 'generate_discharge_card', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (346, 40, 'Online Appointment', 'online_appointment', 1, 0, 0, 0, '2021-09-09 02:15:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (347, 31, 'TPA Charges ', 'tpa_charges', 1, 0, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (348, 15, 'System Notification Setting', 'system_notification_setting', 1, 0, 1, 0, '2018-07-04 22:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (349, 14, 'All Transaction Report', 'all_transaction_report', 1, 0, 0, 0, '2021-09-13 02:29:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (350, 14, 'Patient Visit Report', 'patient_visit_report', 1, 0, 0, 0, '2019-10-03 18:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (351, 14, 'Patient Bill Report', 'patient_bill_report', 1, 0, 0, 0, '2019-10-03 17:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (352, 14, 'Referral Report', 'referral_report', 1, 0, 0, 0, '2019-10-03 17:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (353, 27, 'Add/Edit Collection Person', 'radiology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 20:06:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (354, 27, 'Add/Edit  Report', 'radiology_add_edit_report', 1, 0, 1, 0, '2021-09-16 20:06:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (355, 26, 'Add/Edit Report', 'pathology_add_edit_report', 1, 0, 1, 0, '2021-09-16 20:06:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (362, 42, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2021-09-20 16:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (363, 42, 'Certificate', 'certificate', 1, 1, 1, 1, '2021-09-20 16:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (364, 42, 'Generate Staff ID Card', 'generate_staff_id_card', 1, 0, 0, 0, '2021-09-20 16:56:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (365, 42, 'Staff ID Card', 'staff_id_card', 1, 1, 1, 1, '2021-09-20 16:56:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (366, 42, 'Generate Patient ID Card', 'generate_patient_id_card', 1, 0, 0, 0, '2021-09-20 23:13:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (367, 42, 'Patient ID Card', 'patient_id_card', 1, 1, 1, 1, '2021-09-20 16:54:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (369, 14, 'Component Issue Report', 'component_issue_report', 1, 0, 0, 0, '2019-03-07 19:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (370, 14, 'Audit Trail Report', 'audit_trail_report', 1, 0, 0, 0, '2021-09-28 01:08:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (371, 43, 'Chat', 'chat', 1, 0, 0, 0, '2021-10-07 05:05:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (372, 15, 'Custom Fields', 'custom_fields', 1, 0, 0, 0, '2021-10-29 07:41:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (373, 14, 'Daily Transaction Report', 'daily_transaction_report', 1, 0, 0, 0, '2021-10-29 07:42:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (374, 15, 'Operation', 'operation', 1, 1, 1, 1, '2021-10-29 07:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (375, 15, 'Operation Category', 'operation_category', 1, 1, 1, 1, '2021-10-29 07:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (386, 39, 'Appointment', 'appointment', 1, 1, 0, 1, '2021-12-24 09:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (387, 39, 'Reschedule', 'reschedule', 1, 0, 0, 0, '2021-12-24 09:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (388, 15, 'Finding', 'finding', 1, 1, 1, 1, '2021-10-29 07:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (389, 15, 'Finding Category', 'finding_category', 1, 1, 1, 1, '2021-10-29 07:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (390, 41, 'Appointment Billing', 'appointment_billing', 1, 0, 0, 0, '2021-09-09 00:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (391, 15, 'Vital', 'vital', 1, 1, 1, 1, '2021-10-29 07:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (392, 23, 'OPD Vitals', 'opd_vitals', 1, 1, 1, 1, '2018-12-19 22:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (393, 24, 'IPD Vitals', 'ipd_vitals', 1, 1, 1, 1, '2021-02-25 01:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (394, 24, 'Previous Obstetric History', 'ipd_previous_obstetric_history', 1, 1, 1, 1, '2021-02-25 01:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (395, 24, 'Postnatal History', 'ipd_postnatal_history', 1, 1, 1, 1, '2021-02-25 01:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (396, 24, 'Antenatal', 'ipd_antenatal', 1, 1, 1, 1, '2021-02-25 01:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (397, 39, 'Print Appointment Header Footer', 'print_appointment_header_footer', 1, 0, 0, 0, '2024-02-29 09:05:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (398, 23, 'Antenatal', 'opd_antenatal', 1, 1, 1, 1, '2024-03-11 11:24:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (399, 41, 'Payment Receipt Header Footer', 'payment_receipt_header_footer', 1, 0, 0, 0, '2024-02-29 10:44:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (400, 13, 'Send Credential', 'send_credential', 1, 0, 0, 0, '2024-02-29 10:44:43');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (401, 24, 'IPD Antenatal Finding Print Header Footer', 'ipd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 10:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (402, 23, 'OPD Antenatal Finding Print Header Footer ', 'opd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 10:44:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (403, 24, 'Discharge Summary Print Header Footer', 'discharge_summary_print_header_footer', 1, 0, 0, 0, '2024-02-29 10:44:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (404, 24, 'IPD Obstetric History Print Header Footer', 'ipd_obstetric_history_print_header_footer', 1, 0, 0, 0, '2024-02-29 10:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (405, 39, 'Appointment Priority', 'appointment_priority', 1, 1, 1, 1, '2021-06-12 01:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (406, 25, 'Unit', 'medicine_unit', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (407, 25, 'Company', 'medicine_company', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (408, 25, 'Medicine Group', 'medicine_group', 1, 1, 1, 1, '2018-10-24 19:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (409, 8, 'Content Share List', 'content_share_list', 1, 0, 0, 1, '2024-04-20 06:05:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (410, 8, 'Upload/Share Content', 'upload_share_content', 1, 1, 0, 1, '2024-04-20 06:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (411, 8, 'Generate URL', 'generate_url', 1, 0, 0, 0, '2024-04-20 06:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (412, 8, 'Share', 'share_content', 1, 0, 0, 0, '2024-04-20 06:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (413, 23, 'OPD Bill Print Header Footer', 'opd_bill_print_header_footer', 1, 0, 1, 0, '2024-05-01 12:39:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (414, 15, 'Attendance Setting', 'attendance_setting', 1, 0, 1, 0, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (415, 44, 'Duty Roster', 'duty_roster', 1, 0, 0, 0, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (416, 44, 'Shift', 'roster_shift', 1, 1, 1, 1, '2024-08-08 09:03:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (417, 44, 'Roster List', 'roster_list', 1, 1, 1, 1, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (418, 44, 'Roster Assign', 'roster_assign', 1, 1, 1, 1, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (419, 45, 'Annual Calendar', 'annual_calendar', 1, 1, 1, 1, '2018-07-04 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10001, 1000, 'Setting', 'google_authenticate_setting', 1, 0, 0, 0, '2018-07-06 10:41:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10002, 1000, 'Setup 2FA', 'google_authenticate_setup_two_fa', 1, 0, 0, 0, '2018-07-06 10:41:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (11001, 1100, 'Attendance', 'qr_code_attendance', 1, 0, 0, 0, '2023-12-11 12:34:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (11002, 1100, 'Setting', 'qr_code_setting', 1, 0, 0, 0, '2023-12-11 12:34:25');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int DEFAULT '0',
  `system` int NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`)
) ENGINE=InnoDB AUTO_INCREMENT=11001 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '15.00', '2021-10-22 00:07:50');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '16.00', '2021-10-22 00:07:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '19.00', '2021-10-22 00:13:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '18.00', '2021-10-22 00:13:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (13, 'Messaging', 'communicate', 1, 0, '17.00', '2021-10-22 00:13:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '23.00', '2021-10-22 00:14:35');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '24.00', '2021-10-22 00:16:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '21.00', '2021-10-22 00:14:07');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '10.00', '2021-10-22 00:05:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '12.00', '2021-10-22 00:06:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '28.00', '2021-10-22 00:22:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '0.01', '2021-10-22 00:18:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (23, 'OPD', 'opd', 1, 0, '3.00', '2021-10-22 00:04:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (24, 'IPD', 'ipd', 1, 0, '4.00', '2021-10-22 00:04:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (25, 'Pharmacy', 'pharmacy', 1, 0, '5.00', '2021-10-22 00:04:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (26, 'Pathology', 'pathology', 1, 0, '6.00', '2021-10-22 00:04:59');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (27, 'Radiology', 'radiology', 1, 0, '7.00', '2021-10-22 00:05:09');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (29, 'Ambulance', 'ambulance', 1, 0, '9.00', '2021-10-22 00:05:31');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (30, 'Blood Bank', 'blood_bank', 1, 0, '8.00', '2021-10-22 00:05:21');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (31, 'TPA Management', 'tpa_management', 1, 0, '14.00', '2021-10-22 00:06:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (32, 'Hospital Charges', 'hospital_charges', 1, 1, '26.00', '2021-10-22 00:19:04');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (34, 'Birth Death Record', 'birth_death_report', 1, 0, '11.00', '2021-10-22 00:06:10');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (36, 'Patient', 'patient', 1, 0, '25.00', '2021-10-22 00:18:46');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (37, 'Live Consultation', 'live_consultation', 1, 0, '22.00', '2021-10-22 00:14:21');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (38, 'Referral', 'referral', 1, 0, '13.00', '2021-10-22 00:06:48');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (39, 'Appointment', 'appointment', 1, 0, '2.00', '2021-10-22 00:04:15');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (41, 'Billing', 'bill', 1, 0, '1.00', '2024-08-21 09:29:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (42, 'Certificate', 'certificate', 1, 0, '20.00', '2021-10-04 03:36:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (43, 'Chat', 'chat', 1, 0, '27.00', '2021-10-22 00:22:19');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (44, 'Duty Roster', 'duty_roster', 1, 0, '12.10', '2024-08-09 10:37:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (45, 'Annual Calendar', 'annual_calendar', 1, 0, '12.20', '2024-08-17 06:32:13');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (1000, 'Two Factor Authenticator', 'google_authenticator', 1, 0, '0.00', '2022-11-17 10:53:36');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (1100, 'QR Code Attendence', 'qr_code_attendence', 1, 0, '0.00', '2023-12-13 09:21:57');


#
# TABLE STRUCTURE FOR: permission_patient
#

DROP TABLE IF EXISTS `permission_patient`;

CREATE TABLE `permission_patient` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permission_group_short_code` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int DEFAULT NULL,
  `system` int NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_permission_group_short_code` (`permission_group_short_code`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (1, 'appointment', 'My Appointments', 'my_appointments', 1, 0, '1.00', '2021-09-27 13:17:05');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (2, 'opd', 'OPD', 'opd', 1, 0, '2.00', '2021-09-27 13:17:21');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'ipd', 'IPD', 'ipd', 1, 0, '3.00', '2021-09-25 09:33:07');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'pharmacy', 'Pharmacy', 'pharmacy', 1, 0, '4.00', '2021-09-25 06:03:29');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (5, 'pathology', 'Pathology', 'pathology', 1, 0, '5.00', '2021-09-27 13:15:45');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (6, 'radiology', 'Radiology', 'radiology', 1, 0, '6.00', '2021-09-27 13:15:47');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (7, 'ambulance', 'Ambulance', 'ambulance', 1, 0, '7.00', '2021-09-27 13:15:50');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'blood_bank', 'Blood Bank', 'blood_bank', 1, 0, '8.00', '2021-09-24 07:40:59');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (9, 'live_consultation', 'Live Consultation', 'live_consultation', 1, 0, '9.00', '2021-09-27 13:16:49');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'calendar_to_do_list', 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '11.00', '2021-10-04 09:07:25');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (11, 'chat', 'Chat', 'chat', 1, 0, '11.00', '2021-10-04 07:34:59');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (12, 'download_center', 'Download Center', 'download_center', 1, 0, '12.00', '2024-06-26 12:29:50');


#
# TABLE STRUCTURE FOR: pharmacy
#

DROP TABLE IF EXISTS `pharmacy`;

CREATE TABLE `pharmacy` (
  `id` int NOT NULL AUTO_INCREMENT,
  `medicine_name` varchar(200) DEFAULT NULL,
  `medicine_category_id` int DEFAULT NULL,
  `medicine_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `medicine_company` varchar(100) DEFAULT NULL,
  `medicine_composition` varchar(100) DEFAULT NULL,
  `medicine_group` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `min_level` varchar(50) DEFAULT NULL,
  `reorder_level` varchar(50) DEFAULT NULL,
  `vat` float DEFAULT NULL,
  `unit_packing` varchar(50) DEFAULT NULL,
  `vat_ac` varchar(50) DEFAULT NULL,
  `rack_number` varchar(255) NOT NULL,
  `note` text,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `idx_medicine_name` (`medicine_name`),
  KEY `index_medicine_name` (`medicine_name`),
  KEY `index_medicine_company` (`medicine_company`),
  KEY `index_medicine_composition` (`medicine_composition`),
  KEY `index_medicine_group` (`medicine_group`),
  KEY `index_unit` (`unit`),
  KEY `index_min_level` (`min_level`),
  KEY `index_reorder_level` (`reorder_level`),
  KEY `index_vat` (`vat`),
  KEY `index_unit_packing` (`unit_packing`),
  KEY `index_vat_ac` (`vat_ac`),
  KEY `index_rack_number` (`rack_number`),
  CONSTRAINT `pharmacy_ibfk_1` FOREIGN KEY (`medicine_category_id`) REFERENCES `medicine_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `vat_ac`, `rack_number`, `note`, `is_active`, `created_at`) VALUES (1, 'peracetemol', 1, '', '1', '', '1', '1', '', '', '0', '2', '', '', '', '', '2024-09-26 13:05:58');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `vat_ac`, `rack_number`, `note`, `is_active`, `created_at`) VALUES (2, 'combiflame', 1, '', '1', 'sts', '1', '2', '100', '100', '20', '1', '1', '1', '1', '', '2024-10-10 08:07:46');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `vat_ac`, `rack_number`, `note`, `is_active`, `created_at`) VALUES (3, 'CIPLA', 2, '', '2', '', '1', '3', '', '', '0', '5', '', '', '', '', '2024-10-10 08:34:56');


#
# TABLE STRUCTURE FOR: pharmacy_bill_basic
#

DROP TABLE IF EXISTS `pharmacy_bill_basic`;

CREATE TABLE `pharmacy_bill_basic` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `ipd_prescription_basic_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `doctor_name` varchar(50) DEFAULT NULL,
  `file` varchar(200) NOT NULL,
  `total` float(10,2) DEFAULT '0.00',
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `discount` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT '0.00',
  `tax` float(10,2) DEFAULT '0.00',
  `net_amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_customer_name` (`customer_name`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  CONSTRAINT `pharmacy_bill_basic_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_basic_ibfk_4` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pharmacy_bill_basic` (`id`, `date`, `patient_id`, `ipd_prescription_basic_id`, `case_reference_id`, `customer_name`, `customer_type`, `doctor_name`, `file`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `note`, `generated_by`, `created_at`) VALUES (8, '2024-10-10 13:57:00', 7, NULL, NULL, '', NULL, 'Ajay Verma (9002)', '', '200.00', '12.00', '24.00', NULL, '17.60', '193.60', '', 1, '2024-10-10 08:25:14');
INSERT INTO `pharmacy_bill_basic` (`id`, `date`, `patient_id`, `ipd_prescription_basic_id`, `case_reference_id`, `customer_name`, `customer_type`, `doctor_name`, `file`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `note`, `generated_by`, `created_at`) VALUES (9, '2024-10-10 13:39:00', 6, NULL, NULL, '', NULL, 'Ajay Verma (9002)', '', '360.00', '20.00', '72.00', NULL, '43.20', '331.20', '', 1, '2024-10-10 09:07:05');


#
# TABLE STRUCTURE FOR: pharmacy_bill_detail
#

DROP TABLE IF EXISTS `pharmacy_bill_detail`;

CREATE TABLE `pharmacy_bill_detail` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pharmacy_bill_basic_id` int DEFAULT NULL,
  `medicine_batch_detail_id` int DEFAULT NULL,
  `quantity` varchar(100) NOT NULL,
  `sale_price` float(10,2) NOT NULL,
  `discount` float(10,2) NOT NULL,
  `amount` float(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pharmacy_bill_basic_id` (`pharmacy_bill_basic_id`),
  KEY `medicine_batch_detail_id` (`medicine_batch_detail_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_sale_price` (`sale_price`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `pharmacy_bill_detail_ibfk_1` FOREIGN KEY (`pharmacy_bill_basic_id`) REFERENCES `pharmacy_bill_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pharmacy_bill_detail_ibfk_2` FOREIGN KEY (`medicine_batch_detail_id`) REFERENCES `medicine_batch_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pharmacy_bill_detail` (`id`, `pharmacy_bill_basic_id`, `medicine_batch_detail_id`, `quantity`, `sale_price`, `discount`, `amount`, `created_at`) VALUES (5, 8, 1, '10', '20.00', '0.00', '0.00', '2024-10-10 08:25:14');
INSERT INTO `pharmacy_bill_detail` (`id`, `pharmacy_bill_basic_id`, `medicine_batch_detail_id`, `quantity`, `sale_price`, `discount`, `amount`, `created_at`) VALUES (6, 9, 1, '10', '20.00', '10.00', '0.00', '2024-10-10 09:07:05');
INSERT INTO `pharmacy_bill_detail` (`id`, `pharmacy_bill_basic_id`, `medicine_batch_detail_id`, `quantity`, `sale_price`, `discount`, `amount`, `created_at`) VALUES (7, 9, 2, '10', '20.00', '10.00', '0.00', '2024-10-10 09:07:05');


#
# TABLE STRUCTURE FOR: pharmacy_company
#

DROP TABLE IF EXISTS `pharmacy_company`;

CREATE TABLE `pharmacy_company` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_company_name` (`company_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `pharmacy_company` (`id`, `company_name`, `created_at`) VALUES (1, 'pharma company', '2024-09-26 12:08:10');
INSERT INTO `pharmacy_company` (`id`, `company_name`, `created_at`) VALUES (2, 'medicine pvt.lmt', '2024-10-07 11:39:26');
INSERT INTO `pharmacy_company` (`id`, `company_name`, `created_at`) VALUES (3, 'Cipla pharmecy', '2024-10-10 09:07:01');


#
# TABLE STRUCTURE FOR: postnatal_examine
#

DROP TABLE IF EXISTS `postnatal_examine`;

CREATE TABLE `postnatal_examine` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `labor_time` datetime NOT NULL,
  `delivery_time` datetime NOT NULL,
  `routine_question` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `general_remark` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_labor_time` (`labor_time`),
  KEY `index_delivery_time` (`delivery_time`),
  CONSTRAINT `postnatal_examine_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `postnatal_examine` (`id`, `patient_id`, `labor_time`, `delivery_time`, `routine_question`, `general_remark`) VALUES (1, 3, '2024-09-28 01:39:00', '2024-10-10 13:39:00', 'Previous Medical History', 'Previous Medical History');
INSERT INTO `postnatal_examine` (`id`, `patient_id`, `labor_time`, `delivery_time`, `routine_question`, `general_remark`) VALUES (2, 5, '2024-10-03 17:48:00', '2024-10-03 17:49:00', '', '');


#
# TABLE STRUCTURE FOR: prefixes
#

DROP TABLE IF EXISTS `prefixes`;

CREATE TABLE `prefixes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `prefix` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_prefix` (`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (1, 'ipd_no', 'IPDN', '2021-06-30 17:40:23');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (2, 'opd_no', 'OPDN', '2021-02-22 13:38:01');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (3, 'ipd_prescription', 'IPDP', '2021-02-12 18:42:07');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (4, 'opd_prescription', 'OPDP', '2021-02-12 18:42:17');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (5, 'appointment', 'APPN', '2021-10-22 05:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (6, 'pharmacy_billing', 'PHAB', '2021-10-22 05:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (7, 'operation_theater_reference_no', 'OTRN', '2021-10-22 05:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (8, 'blood_bank_billing', 'BLBB', '2021-10-22 05:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (9, 'ambulance_call_billing', 'AMCB', '2021-10-22 05:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (10, 'radiology_billing', 'RADB', '2021-10-22 05:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (11, 'pathology_billing', 'PATB', '2021-10-22 05:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (12, 'checkup_id', 'OCID', '2021-10-22 05:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (13, 'purchase_no', 'PHPN', '2021-10-22 05:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (14, 'transaction_id', 'TRID', '2021-10-22 05:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (15, 'birth_record_reference_no', 'BRRN', '2021-10-22 05:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (16, 'death_record_reference_no', 'DRRN', '2021-10-22 05:44:25');


#
# TABLE STRUCTURE FOR: primary_examine
#

DROP TABLE IF EXISTS `primary_examine`;

CREATE TABLE `primary_examine` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipdid` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `bleeding` varchar(250) DEFAULT NULL,
  `headache` varchar(250) DEFAULT NULL,
  `pain` varchar(250) DEFAULT NULL,
  `constipation` varchar(250) DEFAULT NULL,
  `urinary_symptoms` varchar(250) NOT NULL,
  `vomiting` varchar(250) DEFAULT NULL,
  `cough` varchar(250) DEFAULT NULL,
  `vaginal` varchar(250) DEFAULT NULL,
  `discharge` varchar(250) DEFAULT NULL,
  `oedema` varchar(250) DEFAULT NULL,
  `haemoroids` varchar(250) DEFAULT NULL,
  `weight` varchar(250) NOT NULL,
  `height` varchar(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `general_condition` text NOT NULL,
  `finding_remark` varchar(250) NOT NULL,
  `pelvic_examination` text NOT NULL,
  `sp` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_bleeding` (`bleeding`),
  KEY `index_headache` (`headache`),
  KEY `index_pain` (`pain`),
  KEY `index_constipation` (`constipation`),
  KEY `index_urinary_symptoms` (`urinary_symptoms`),
  KEY `index_vomiting` (`vomiting`),
  KEY `index_cough` (`cough`),
  KEY `index_vaginal` (`vaginal`),
  KEY `index_discharge` (`discharge`),
  KEY `index_oedema` (`oedema`),
  KEY `index_haemoroids` (`haemoroids`),
  KEY `index_weight` (`weight`),
  KEY `index_height` (`height`),
  KEY `index_date` (`date`),
  CONSTRAINT `primary_examine_ibfk_1` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `primary_examine_ibfk_2` FOREIGN KEY (`ipdid`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `primary_examine` (`id`, `ipdid`, `visit_details_id`, `bleeding`, `headache`, `pain`, `constipation`, `urinary_symptoms`, `vomiting`, `cough`, `vaginal`, `discharge`, `oedema`, `haemoroids`, `weight`, `height`, `date`, `general_condition`, `finding_remark`, `pelvic_examination`, `sp`) VALUES (5, 2, NULL, 'k', 'k', 'k', 'k', 'kk', 'k', 'k', 'k', 'k', 'k', 'kk', 'k', 'k', '2024-09-30 12:36:00', 'k', 'k', 'k', 'k');


#
# TABLE STRUCTURE FOR: print_setting
#

DROP TABLE IF EXISTS `print_setting`;

CREATE TABLE `print_setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `print_header` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `print_footer` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `setting_for` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3;

INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (1, 'uploads/printing/1.jpg', '<p>\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n\r\n\r\n<br></p>', 'opdpre', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (2, 'uploads/printing/2.jpg', '<p>\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 s<br></p>', 'opd', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (3, 'uploads/printing/3.jpg', '<p>\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 s<br></p>', 'ipdpres', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (4, 'uploads/printing/4.jpg', '<p>\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n\r\n\r\n<br></p>', 'ipd', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (5, 'uploads/printing/5.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'bill', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (6, 'uploads/printing/6.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'pharmacy', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (7, 'uploads/printing/7.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'payslip', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (8, 'uploads/printing/8.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'paymentreceipt', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (9, 'uploads/printing/9.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'birth', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (10, 'uploads/printing/10.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'death', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (11, 'uploads/printing/11.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'pathology', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (12, 'uploads/printing/12.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'radiology', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (13, 'uploads/printing/13.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'ot', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (14, 'uploads/printing/14.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'bloodbank', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (15, 'uploads/printing/15.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'ambulance', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (16, 'uploads/printing/16.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'discharge_card', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (17, 'uploads/printing/17.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'obstetric_history', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (18, 'uploads/printing/18.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'opd_antenatal_finding', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (19, 'uploads/printing/19.jpg', '<p>\r\n\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n<br></p>', 'ipd_antenatal_finding', 'yes', '2021-09-25 06:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (20, 'uploads/printing/20.jpg', '<p>\r\nis simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500 sss\r\n\r\n\r\n\r\n<br></p>', 'appointment', 'yes', '2021-09-25 06:44:20');


#
# TABLE STRUCTURE FOR: radio
#

DROP TABLE IF EXISTS `radio`;

CREATE TABLE `radio` (
  `id` int NOT NULL AUTO_INCREMENT,
  `test_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `radiology_category_id` int DEFAULT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `charge_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`),
  CONSTRAINT `radio_ibfk_1` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `radio` (`id`, `test_name`, `short_name`, `test_type`, `radiology_category_id`, `sub_category`, `report_days`, `charge_id`, `created_at`) VALUES (2, 'x-ray', 'scanning', '', 6, '', '0', 14, '2024-10-08 11:21:52');
INSERT INTO `radio` (`id`, `test_name`, `short_name`, `test_type`, `radiology_category_id`, `sub_category`, `report_days`, `charge_id`, `created_at`) VALUES (3, 'ESG', 'esg', '', 1, '', '0', 14, '2024-10-10 11:23:41');


#
# TABLE STRUCTURE FOR: radiology_billing
#

DROP TABLE IF EXISTS `radiology_billing`;

CREATE TABLE `radiology_billing` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `ipd_prescription_basic_id` int DEFAULT NULL,
  `doctor_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) NOT NULL,
  `discount` float(10,2) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `tax` float(10,2) NOT NULL,
  `net_amount` float(10,2) NOT NULL,
  `transaction_id` int DEFAULT NULL,
  `note` text,
  `organisation_id` int DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `index_transaction_id` (`transaction_id`),
  KEY `index_organisation_id` (`organisation_id`),
  KEY `index_insurance_validity` (`insurance_validity`),
  KEY `index_insurance_id` (`insurance_id`),
  CONSTRAINT `radiology_billing_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_3` FOREIGN KEY (`doctor_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `radiology_billing_ibfk_6` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_billing_ibfk_7` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `radiology_billing` (`id`, `patient_id`, `case_reference_id`, `ipd_prescription_basic_id`, `doctor_id`, `date`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`, `updated_at`) VALUES (3, 3, NULL, NULL, 2, '2024-09-28 17:53:00', 'Ajay Verma (9002)', '300.00', '0.00', '0.00', '0.00', '9.00', '309.00', NULL, 'hdhf', NULL, NULL, NULL, 1, '2024-09-28 12:24:18', NULL);
INSERT INTO `radiology_billing` (`id`, `patient_id`, `case_reference_id`, `ipd_prescription_basic_id`, `doctor_id`, `date`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`, `updated_at`) VALUES (4, 7, NULL, NULL, 2, '2024-10-08 16:52:00', 'Ajay Verma (9002)', '300.00', '0.00', '0.00', '0.00', '9.00', '309.00', NULL, '', 6, '2025-10-29', '100', 1, '2024-10-08 11:23:18', NULL);
INSERT INTO `radiology_billing` (`id`, `patient_id`, `case_reference_id`, `ipd_prescription_basic_id`, `doctor_id`, `date`, `doctor_name`, `total`, `discount_percentage`, `discount`, `tax_percentage`, `tax`, `net_amount`, `transaction_id`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`, `updated_at`) VALUES (5, 7, NULL, NULL, 2, '2024-10-10 04:15:00', 'Ajay Verma (9002)', '500.00', '0.00', '0.00', '0.00', '15.00', '515.00', NULL, '', NULL, NULL, NULL, 1, '2024-10-10 11:21:23', NULL);


#
# TABLE STRUCTURE FOR: radiology_parameter
#

DROP TABLE IF EXISTS `radiology_parameter`;

CREATE TABLE `radiology_parameter` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (1, 'MRI Cardiac with Contrast', '', '1CT-5CT', '1CT', '5CT', '', '7', '	MRI Cardiac with Contrast', '2024-09-27 11:46:45');
INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (2, 'XRAY', '', '4-5', '4', '5', '', '7', '', '2024-09-27 11:47:15');
INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (4, 'CT-scan', '', '2-4', '2', '4', '', '7', 'CT-scan with scrining', '2024-10-10 11:15:13');


#
# TABLE STRUCTURE FOR: radiology_parameterdetails
#

DROP TABLE IF EXISTS `radiology_parameterdetails`;

CREATE TABLE `radiology_parameterdetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `radiology_id` int DEFAULT NULL,
  `radiology_parameter_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_parameter_id` (`radiology_parameter_id`),
  CONSTRAINT `radiology_parameterdetails_ibfk_1` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_parameterdetails_ibfk_2` FOREIGN KEY (`radiology_parameter_id`) REFERENCES `radiology_parameter` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `radiology_parameterdetails` (`id`, `radiology_id`, `radiology_parameter_id`, `created_at`) VALUES (2, 2, 2, '2024-10-08 11:21:52');
INSERT INTO `radiology_parameterdetails` (`id`, `radiology_id`, `radiology_parameter_id`, `created_at`) VALUES (3, 3, 4, '2024-10-10 11:23:41');


#
# TABLE STRUCTURE FOR: radiology_report
#

DROP TABLE IF EXISTS `radiology_report`;

CREATE TABLE `radiology_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `radiology_bill_id` int DEFAULT NULL,
  `radiology_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(10) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `description` text,
  `radiology_report` text,
  `report_name` text,
  `radiology_result` text COMMENT 'test result',
  `tax_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `apply_charge` float(10,2) NOT NULL DEFAULT '0.00',
  `radiology_center` varchar(250) NOT NULL,
  `generated_by` int DEFAULT NULL,
  `collection_specialist` int DEFAULT NULL,
  `collection_date` date DEFAULT NULL,
  `approved_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_bill_id` (`radiology_bill_id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_by` (`generated_by`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_patient_name` (`patient_name`),
  KEY `index_consultant_doctor` (`consultant_doctor`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_radiology_center` (`radiology_center`),
  CONSTRAINT `radiology_report_ibfk_1` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_2` FOREIGN KEY (`radiology_bill_id`) REFERENCES `radiology_billing` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_4` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_5` FOREIGN KEY (`collection_specialist`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_ibfk_6` FOREIGN KEY (`approved_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `radiology_report` (`id`, `radiology_bill_id`, `radiology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `parameter_update`, `description`, `radiology_report`, `report_name`, `radiology_result`, `tax_percentage`, `apply_charge`, `radiology_center`, `generated_by`, `collection_specialist`, `collection_date`, `approved_by`, `created_at`) VALUES (5, 4, 2, 7, NULL, NULL, '', '2024-10-08', NULL, NULL, NULL, NULL, NULL, '3.00', '300.00', '', 1, NULL, NULL, NULL, '2024-10-08 11:23:18');
INSERT INTO `radiology_report` (`id`, `radiology_bill_id`, `radiology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `parameter_update`, `description`, `radiology_report`, `report_name`, `radiology_result`, `tax_percentage`, `apply_charge`, `radiology_center`, `generated_by`, `collection_specialist`, `collection_date`, `approved_by`, `created_at`) VALUES (6, 5, 2, 7, NULL, NULL, '', '2024-10-10', NULL, NULL, NULL, NULL, NULL, '3.00', '500.00', '', 1, NULL, NULL, NULL, '2024-10-10 11:21:23');


#
# TABLE STRUCTURE FOR: radiology_report_parameterdetails
#

DROP TABLE IF EXISTS `radiology_report_parameterdetails`;

CREATE TABLE `radiology_report_parameterdetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `radiology_report_id` int DEFAULT NULL,
  `radiology_parameterdetail_id` int DEFAULT NULL,
  `radiology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `radiology_report_id` (`radiology_report_id`),
  KEY `radiology_parameterdetail_id` (`radiology_parameterdetail_id`),
  CONSTRAINT `radiology_report_parameterdetails_ibfk_1` FOREIGN KEY (`radiology_report_id`) REFERENCES `radiology_report` (`id`) ON DELETE CASCADE,
  CONSTRAINT `radiology_report_parameterdetails_ibfk_2` FOREIGN KEY (`radiology_parameterdetail_id`) REFERENCES `radiology_parameterdetails` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: read_notification
#

DROP TABLE IF EXISTS `read_notification`;

CREATE TABLE `read_notification` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `notification_id` int DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `read_notification_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `read_notification` (`id`, `staff_id`, `notification_id`, `is_active`, `created_at`) VALUES (1, 1, 1, 'no', '2024-10-01 07:44:02');


#
# TABLE STRUCTURE FOR: read_systemnotification
#

DROP TABLE IF EXISTS `read_systemnotification`;

CREATE TABLE `read_systemnotification` (
  `id` int NOT NULL AUTO_INCREMENT,
  `notification_id` int DEFAULT NULL,
  `receiver_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `read_systemnotification_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `system_notification` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3;

INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (1, 7, 1, 'no', '2024-09-26 07:48:25');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (2, 4, 1, 'no', '2024-09-26 07:48:27');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (3, 7, 1, 'no', '2024-09-26 07:48:28');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (4, 7, 1, 'no', '2024-09-26 07:48:32');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (5, 7, 1, 'no', '2024-09-26 15:37:59');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (6, 4, 1, 'no', '2024-09-26 15:38:01');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (7, 1, 1, 'no', '2024-09-26 15:38:04');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (8, 21, 1, 'no', '2024-09-26 15:38:13');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (9, 21, 1, 'no', '2024-09-26 15:38:14');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (10, 1, 1, 'no', '2024-09-26 17:13:36');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (11, 4, 1, 'no', '2024-09-26 17:13:37');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (12, 27, 1, 'no', '2024-09-26 17:14:11');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (13, 14, 1, 'no', '2024-09-27 16:46:53');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (14, 27, 1, 'no', '2024-09-28 18:09:37');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (15, 30, 1, 'no', '2024-09-28 18:09:40');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (16, 202, 1, 'no', '2024-09-30 12:48:08');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (17, 199, 1, 'no', '2024-09-30 12:48:10');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (18, 198, 1, 'no', '2024-09-30 12:48:12');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (19, 195, 1, 'no', '2024-09-30 12:48:15');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (20, 192, 1, 'no', '2024-09-30 12:48:16');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (21, 189, 1, 'no', '2024-09-30 12:48:17');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (22, 228, 1, 'no', '2024-10-01 13:08:00');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (23, 228, 1, 'no', '2024-10-01 13:08:04');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (24, 334, 1, 'no', '2024-10-07 12:56:11');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (25, 334, 1, 'no', '2024-10-07 12:56:15');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (26, 334, 1, 'no', '2024-10-07 12:56:17');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (27, 333, 7, 'no', '2024-10-07 12:58:47');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (28, 403, 1, 'no', '2024-10-09 12:34:05');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (29, 406, 1, 'no', '2024-10-09 12:34:08');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (30, 606, 1, 'no', '2024-10-14 15:17:11');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (31, 610, 1, 'no', '2024-10-14 15:17:13');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (32, 613, 1, 'no', '2024-10-14 15:17:14');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (33, 617, 1, 'no', '2024-10-14 15:17:16');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (34, 617, 1, 'no', '2024-10-14 15:17:18');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (35, 621, 1, 'no', '2024-10-14 15:17:19');
INSERT INTO `read_systemnotification` (`id`, `notification_id`, `receiver_id`, `is_active`, `date`) VALUES (36, 623, 1, 'no', '2024-10-14 15:17:20');


#
# TABLE STRUCTURE FOR: referral_category
#

DROP TABLE IF EXISTS `referral_category`;

CREATE TABLE `referral_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_category` (`id`, `name`, `is_active`, `created_at`) VALUES (1, 'patient', 1, '2024-09-30 11:52:33');
INSERT INTO `referral_category` (`id`, `name`, `is_active`, `created_at`) VALUES (2, 'staff', 1, '2024-09-30 11:52:50');
INSERT INTO `referral_category` (`id`, `name`, `is_active`, `created_at`) VALUES (3, 'Reletives', 1, '2024-10-11 11:21:17');


#
# TABLE STRUCTURE FOR: referral_commission
#

DROP TABLE IF EXISTS `referral_commission`;

CREATE TABLE `referral_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `referral_category_id` int DEFAULT NULL,
  `referral_type_id` int DEFAULT NULL,
  `commission` float DEFAULT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `referral_category_id` (`referral_category_id`),
  KEY `referral_type_id` (`referral_type_id`),
  CONSTRAINT `referral_commission_ibfk_1` FOREIGN KEY (`referral_category_id`) REFERENCES `referral_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_commission_ibfk_2` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (1, 1, 1, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (2, 1, 2, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (3, 1, 3, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (4, 1, 4, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (5, 1, 5, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (6, 1, 6, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (7, 1, 7, '5', 1, '2024-09-30 11:55:31');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (8, 2, 1, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (9, 2, 2, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (10, 2, 3, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (11, 2, 4, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (12, 2, 5, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (13, 2, 6, '0', 1, '2024-09-30 11:55:42');
INSERT INTO `referral_commission` (`id`, `referral_category_id`, `referral_type_id`, `commission`, `is_active`, `created_at`) VALUES (14, 2, 7, '0', 1, '2024-09-30 11:55:42');


#
# TABLE STRUCTURE FOR: referral_payment
#

DROP TABLE IF EXISTS `referral_payment`;

CREATE TABLE `referral_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `referral_person_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `referral_type` int DEFAULT NULL,
  `billing_id` int NOT NULL,
  `bill_amount` float(10,2) DEFAULT '0.00',
  `percentage` float(10,2) DEFAULT '0.00',
  `amount` float(10,2) DEFAULT '0.00',
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type` (`referral_type`),
  KEY `index_bill_amount` (`bill_amount`),
  KEY `index_percentage` (`percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_date` (`date`),
  CONSTRAINT `referral_payment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_payment_ibfk_2` FOREIGN KEY (`referral_person_id`) REFERENCES `referral_person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_payment_ibfk_3` FOREIGN KEY (`referral_type`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_payment` (`id`, `referral_person_id`, `patient_id`, `referral_type`, `billing_id`, `bill_amount`, `percentage`, `amount`, `date`, `created_at`) VALUES (1, 1, 5, 2, 3, '1225.00', '3.00', '0.00', '2024-10-01 12:45:14', '2024-10-01 07:15:14');
INSERT INTO `referral_payment` (`id`, `referral_person_id`, `patient_id`, `referral_type`, `billing_id`, `bill_amount`, `percentage`, `amount`, `date`, `created_at`) VALUES (2, 1, 3, 2, 2, '200.00', '3.00', '6.00', '2024-10-01 13:27:32', '2024-10-01 07:57:32');
INSERT INTO `referral_payment` (`id`, `referral_person_id`, `patient_id`, `referral_type`, `billing_id`, `bill_amount`, `percentage`, `amount`, `date`, `created_at`) VALUES (3, 1, 3, 1, 8, '236.00', '3.00', '7.08', '2024-10-05 12:48:35', '2024-10-05 07:18:35');
INSERT INTO `referral_payment` (`id`, `referral_person_id`, `patient_id`, `referral_type`, `billing_id`, `bill_amount`, `percentage`, `amount`, `date`, `created_at`) VALUES (4, 1, 7, 1, 24, '0.00', '3.00', '0.00', '2024-10-11 16:52:30', '2024-10-11 11:22:30');


#
# TABLE STRUCTURE FOR: referral_person
#

DROP TABLE IF EXISTS `referral_person`;

CREATE TABLE `referral_person` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `category_id` int DEFAULT NULL,
  `contact` varchar(20) DEFAULT NULL,
  `person_name` varchar(100) DEFAULT NULL,
  `person_phone` varchar(50) DEFAULT NULL,
  `standard_commission` float(10,2) NOT NULL DEFAULT '0.00',
  `address` varchar(100) DEFAULT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `referral_category` (`category_id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_person_name` (`person_name`),
  KEY `index_person_phone` (`person_phone`),
  KEY `index_standard_commission` (`standard_commission`),
  CONSTRAINT `referral_person_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `referral_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_person` (`id`, `name`, `category_id`, `contact`, `person_name`, `person_phone`, `standard_commission`, `address`, `is_active`, `created_at`) VALUES (1, 'naman', 1, '', '', '46756676778', '0.00', '', 1, '2024-09-30 11:59:04');
INSERT INTO `referral_person` (`id`, `name`, `category_id`, `contact`, `person_name`, `person_phone`, `standard_commission`, `address`, `is_active`, `created_at`) VALUES (2, 'ajay', 1, '3456654778', '', '', '0.00', '', 1, '2024-10-05 07:29:58');
INSERT INTO `referral_person` (`id`, `name`, `category_id`, `contact`, `person_name`, `person_phone`, `standard_commission`, `address`, `is_active`, `created_at`) VALUES (3, 'rashi', 2, '', '', '', '0.00', '', 1, '2024-10-11 11:24:05');


#
# TABLE STRUCTURE FOR: referral_person_commission
#

DROP TABLE IF EXISTS `referral_person_commission`;

CREATE TABLE `referral_person_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `referral_person_id` int DEFAULT NULL,
  `referral_type_id` int DEFAULT NULL,
  `commission` float(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type_id` (`referral_type_id`),
  CONSTRAINT `referral_person_commission_ibfk_1` FOREIGN KEY (`referral_person_id`) REFERENCES `referral_person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `referral_person_commission_ibfk_2` FOREIGN KEY (`referral_type_id`) REFERENCES `referral_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (1, 1, 1, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (2, 1, 2, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (3, 1, 3, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (4, 1, 4, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (5, 1, 5, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (6, 1, 6, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (7, 1, 7, '3.00', '2024-09-30 11:59:04');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (8, 2, 1, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (9, 2, 2, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (10, 2, 3, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (11, 2, 4, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (12, 2, 5, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (13, 2, 6, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (14, 2, 7, '4.00', '2024-10-05 07:29:58');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (15, 3, 1, '2.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (16, 3, 2, '0.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (17, 3, 3, '2.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (18, 3, 4, '3.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (19, 3, 5, '3.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (20, 3, 6, '3.00', '2024-10-11 11:24:05');
INSERT INTO `referral_person_commission` (`id`, `referral_person_id`, `referral_type_id`, `commission`, `created_at`) VALUES (21, 3, 7, '2.00', '2024-10-11 11:24:05');


#
# TABLE STRUCTURE FOR: referral_type
#

DROP TABLE IF EXISTS `referral_type`;

CREATE TABLE `referral_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `prefixes_type` varchar(100) NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`name`),
  KEY `index_prefixes_type` (`prefixes_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (1, 'opd', 'opd_no', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (2, 'ipd', 'ipd_no', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (3, 'pharmacy', 'pharmacy_billing', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (4, 'pathology', 'pathology_billing', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (5, 'radiology', 'radiology_billing', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (6, 'blood_bank', 'blood_bank_billing', 1, '2021-09-17 02:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (7, 'ambulance', 'ambulance_call_billing', 1, '2021-09-17 02:07:51');


#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `is_system` int NOT NULL DEFAULT '0',
  `is_superadmin` int NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;

INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (1, 'Admin', NULL, 0, 1, 0, '2018-12-25 06:19:43');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (2, 'Accountant', NULL, 0, 1, 0, '2018-12-25 06:19:38');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (3, 'Doctor', NULL, 0, 1, 0, '2018-07-21 05:07:36');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (4, 'Pharmacist', NULL, 0, 1, 0, '2018-07-21 05:08:26');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (5, 'Pathologist', NULL, 0, 1, 0, '2018-12-25 06:19:59');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (6, 'Radiologist', NULL, 0, 1, 0, '2018-12-25 06:20:27');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (7, 'Super Admin', NULL, 0, 1, 1, '2018-12-25 06:22:24');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (8, 'Receptionist', NULL, 0, 1, 0, '2018-12-25 06:20:22');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (9, 'Nurse', NULL, 0, 1, 0, '2020-12-23 01:58:58');


#
# TABLE STRUCTURE FOR: roles_permissions
#

DROP TABLE IF EXISTS `roles_permissions`;

CREATE TABLE `roles_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role_id` int DEFAULT NULL,
  `perm_cat_id` int DEFAULT NULL,
  `can_view` int DEFAULT NULL,
  `can_add` int DEFAULT NULL,
  `can_edit` int DEFAULT NULL,
  `can_delete` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_can_view` (`can_view`),
  KEY `index_can_add` (`can_add`),
  KEY `index_can_edit` (`can_edit`),
  KEY `index_can_delete` (`can_delete`),
  KEY `role_id` (`role_id`),
  KEY `perm_cat_id` (`perm_cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2418 DEFAULT CHARSET=utf8mb3;

INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1, 1, 346, 1, 0, 0, 0, '2021-09-15 02:19:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2, 1, 80, 1, 1, 1, 1, '2024-10-04 11:35:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (3, 1, 81, 1, 1, 1, 1, '2024-10-04 11:38:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (4, 1, 82, 1, 1, 1, 1, '2024-10-04 11:40:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (5, 1, 83, 1, 1, 1, 1, '2024-10-04 11:43:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (6, 1, 84, 1, 1, 0, 1, '2024-10-04 11:50:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (7, 1, 85, 1, 1, 1, 1, '2021-09-15 02:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (8, 1, 204, 1, 1, 1, 1, '2021-09-15 02:22:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (9, 1, 205, 1, 0, 0, 0, '2021-09-15 02:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (10, 1, 216, 1, 0, 0, 0, '2021-09-15 02:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (11, 1, 217, 1, 0, 0, 0, '2021-09-15 02:20:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (14, 1, 237, 1, 0, 0, 0, '2021-09-15 02:25:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (15, 1, 239, 1, 0, 0, 0, '2021-09-15 02:25:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (16, 1, 214, 1, 1, 1, 1, '2024-10-04 12:08:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (17, 1, 215, 1, 0, 0, 1, '2024-10-04 12:12:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (18, 1, 240, 1, 0, 0, 0, '2024-10-04 12:01:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (19, 1, 242, 1, 0, 0, 0, '2024-10-04 12:01:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (46, 1, 185, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (49, 1, 189, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (58, 1, 250, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (59, 1, 251, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (61, 1, 254, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (66, 1, 265, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (67, 1, 266, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (70, 1, 349, 1, 0, 0, 0, '2021-09-15 18:37:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (78, 1, 12, 1, 1, 1, 1, '2024-10-05 08:35:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (79, 1, 13, 1, 1, 1, 1, '2024-10-05 08:39:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (81, 1, 134, 1, 1, 1, 1, '2024-10-03 07:49:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (84, 1, 192, 1, 0, 0, 0, '2024-10-03 07:19:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (105, 1, 140, 1, 1, 1, 1, '2021-10-07 04:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (106, 1, 142, 1, 1, 1, 1, '2024-10-03 09:52:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (114, 1, 300, 1, 1, 1, 1, '2024-10-03 11:51:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (117, 1, 309, 1, 0, 1, 0, '2021-09-16 22:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (119, 1, 322, 1, 1, 1, 1, '2024-10-03 11:57:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (125, 1, 170, 1, 1, 1, 1, '2024-10-04 07:40:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (127, 1, 201, 1, 0, 0, 0, '2024-10-03 12:29:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (131, 1, 227, 1, 1, 1, 1, '2024-10-04 07:53:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (132, 1, 291, 1, 1, 1, 1, '2024-10-04 07:55:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (133, 1, 292, 1, 1, 1, 1, '2024-10-04 07:58:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (142, 1, 317, 1, 1, 0, 1, '2021-09-15 20:15:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (143, 1, 269, 1, 1, 0, 1, '2024-10-05 10:28:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (144, 1, 270, 1, 1, 0, 1, '2024-10-05 10:28:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (154, 1, 60, 1, 0, 1, 0, '2021-09-15 20:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (155, 1, 126, 1, 0, 0, 0, '2021-09-15 20:53:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (157, 1, 131, 1, 0, 0, 0, '2021-09-15 20:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (158, 1, 267, 1, 1, 1, 1, '2024-10-07 07:44:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (159, 1, 274, 1, 0, 0, 0, '2021-09-15 20:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (160, 1, 279, 1, 1, 1, 1, '2024-10-07 07:45:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (161, 1, 287, 1, 0, 1, 0, '2024-10-07 07:45:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (162, 1, 288, 1, 0, 1, 0, '2024-10-07 07:46:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (163, 1, 348, 1, 0, 1, 0, '2021-09-15 20:54:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (164, 1, 61, 1, 1, 0, 1, '2024-10-05 09:44:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (165, 1, 62, 1, 1, 0, 1, '2024-10-05 09:45:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (166, 1, 63, 1, 1, 0, 1, '2024-10-05 09:48:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (167, 1, 64, 1, 1, 1, 1, '2021-10-07 04:57:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (168, 1, 65, 1, 1, 1, 1, '2024-10-05 09:55:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (169, 1, 66, 1, 1, 1, 1, '2024-10-05 09:54:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (170, 1, 67, 1, 1, 1, 1, '2024-10-05 09:56:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (171, 1, 43, 1, 1, 0, 0, '2024-10-05 08:45:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (172, 1, 44, 1, 0, 0, 0, '2021-09-15 21:53:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (175, 1, 283, 1, 1, 1, 1, '2024-10-05 07:22:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (176, 1, 284, 1, 1, 1, 1, '2024-10-05 07:28:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (177, 1, 285, 1, 1, 1, 1, '2024-10-05 07:33:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (178, 1, 286, 1, 1, 1, 1, '2024-10-05 07:39:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (181, 1, 146, 1, 1, 1, 1, '2024-10-03 12:42:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (182, 1, 148, 1, 1, 1, 1, '2024-10-03 13:10:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (184, 1, 86, 1, 1, 1, 1, '2024-10-04 12:23:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (192, 1, 127, 1, 0, 0, 0, '2021-09-16 00:46:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (194, 1, 152, 1, 1, 1, 1, '2024-10-04 08:52:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (195, 1, 153, 1, 1, 1, 1, '2024-10-04 08:54:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (197, 1, 354, 1, 0, 1, 0, '2021-09-17 19:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (199, 1, 261, 1, 1, 1, 1, '2024-10-04 09:01:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (200, 1, 262, 1, 1, 1, 1, '2024-10-04 09:04:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (201, 1, 315, 1, 1, 0, 1, '2021-09-17 19:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (202, 1, 244, 1, 0, 0, 0, '2024-10-04 08:49:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (221, 1, 138, 1, 1, 1, 1, '2024-10-03 09:34:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (222, 1, 139, 1, 1, 1, 1, '2024-10-03 09:41:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (223, 1, 143, 1, 1, 1, 1, '2024-10-03 10:01:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (224, 1, 144, 1, 1, 1, 1, '2024-10-03 11:28:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (226, 1, 197, 1, 0, 0, 0, '2024-10-03 09:31:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (228, 1, 248, 1, 0, 0, 0, '2024-10-03 09:31:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (229, 1, 301, 1, 0, 0, 0, '2021-09-16 22:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (230, 1, 308, 1, 0, 0, 0, '2021-09-16 22:16:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (236, 1, 149, 1, 1, 1, 1, '2024-10-04 08:13:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (237, 1, 175, 1, 1, 1, 1, '2024-10-04 08:40:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (238, 1, 243, 1, 0, 0, 0, '2024-10-04 08:09:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (239, 1, 257, 1, 1, 1, 1, '2024-10-04 08:44:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (243, 1, 314, 1, 1, 0, 1, '2021-10-22 00:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (245, 1, 310, 1, 0, 0, 0, '2021-09-16 22:29:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (247, 1, 355, 1, 0, 1, 0, '2021-10-22 00:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (248, 1, 260, 1, 1, 1, 1, '2024-10-04 08:48:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (249, 1, 263, 1, 0, 0, 1, '2024-10-04 08:48:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (250, 1, 312, 1, 0, 1, 0, '2021-10-22 00:28:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (254, 1, 135, 1, 1, 1, 1, '2024-10-03 08:15:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (255, 1, 137, 1, 1, 1, 1, '2024-10-03 08:31:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (257, 1, 219, 1, 0, 0, 0, '2021-09-17 01:09:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (258, 1, 221, 1, 1, 1, 1, '2024-10-03 08:40:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (259, 1, 222, 1, 1, 1, 1, '2024-10-03 08:58:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (260, 1, 299, 1, 1, 1, 1, '2024-10-03 09:02:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (261, 1, 303, 1, 1, 1, 1, '2024-10-03 09:03:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (262, 1, 304, 1, 0, 0, 0, '2021-09-17 01:21:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (263, 1, 305, 1, 0, 1, 0, '2021-09-17 01:22:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (264, 1, 306, 1, 0, 0, 0, '2021-09-17 01:22:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (265, 1, 307, 1, 0, 0, 0, '2021-09-17 01:23:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (266, 1, 319, 1, 1, 1, 1, '2021-10-07 05:01:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (274, 1, 220, 1, 1, 1, 1, '2024-10-03 11:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (275, 1, 326, 1, 1, 1, 1, '2024-10-03 12:09:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (277, 1, 225, 1, 1, 0, 1, '2024-10-04 07:42:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (278, 1, 226, 1, 1, 1, 1, '2024-10-04 07:47:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (279, 1, 224, 1, 0, 0, 0, '2021-09-17 19:38:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (280, 1, 313, 1, 1, 0, 1, '2021-09-17 19:39:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (281, 1, 171, 1, 1, 1, 1, '2024-10-04 08:59:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (282, 1, 353, 1, 0, 1, 0, '2021-09-17 19:46:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (283, 1, 168, 1, 1, 1, 1, '2024-10-04 09:19:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (284, 1, 169, 1, 1, 1, 1, '2024-10-04 09:21:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (285, 1, 311, 1, 1, 1, 1, '2021-09-17 20:24:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (286, 1, 246, 1, 0, 0, 0, '2024-10-04 09:16:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (287, 1, 202, 1, 1, 0, 1, '2024-10-04 09:24:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (288, 1, 293, 1, 1, 1, 1, '2024-10-04 10:54:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (289, 1, 302, 1, 0, 0, 1, '2024-10-04 11:01:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (290, 1, 173, 1, 1, 1, 1, '2024-10-05 07:43:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (291, 1, 347, 1, 0, 1, 1, '2021-09-17 20:36:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (292, 1, 273, 1, 0, 1, 0, '2021-09-17 21:43:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (293, 1, 9, 1, 1, 1, 1, '2024-10-05 08:31:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (294, 1, 10, 1, 1, 1, 1, '2024-10-05 08:31:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (295, 1, 176, 1, 1, 1, 1, '2024-10-07 08:18:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (296, 1, 102, 1, 1, 1, 1, '2024-10-07 09:03:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (297, 1, 31, 1, 1, 0, 1, '2024-10-05 09:05:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (298, 1, 32, 1, 1, 1, 1, '2024-10-05 09:07:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (299, 1, 33, 1, 1, 1, 1, '2024-10-05 09:12:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (300, 1, 34, 1, 1, 1, 1, '2024-10-05 09:15:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (301, 1, 35, 1, 1, 1, 1, '2024-10-05 09:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (302, 1, 104, 1, 1, 1, 1, '2024-10-05 09:19:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (303, 1, 87, 1, 0, 0, 0, '2021-09-17 23:01:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (304, 1, 88, 1, 1, 1, 0, '2024-10-04 12:26:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (305, 1, 90, 1, 1, 1, 1, '2024-10-04 12:40:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (306, 1, 108, 1, 1, 1, 1, '2024-10-04 12:49:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (307, 1, 109, 1, 1, 0, 1, '2024-10-04 12:51:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (308, 1, 110, 1, 1, 1, 1, '2024-10-04 12:53:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (309, 1, 111, 1, 1, 1, 1, '2024-10-04 12:55:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (310, 1, 112, 1, 1, 1, 1, '2024-10-04 12:57:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (311, 1, 249, 1, 0, 0, 0, '2024-09-30 11:16:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (313, 1, 203, 1, 1, 1, 1, '2024-10-07 08:20:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (314, 1, 264, 1, 1, 0, 1, '2024-10-07 08:44:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (315, 1, 289, 1, 1, 1, 1, '2024-10-07 08:55:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (316, 1, 290, 1, 1, 1, 1, '2024-10-07 08:58:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (317, 1, 165, 1, 1, 1, 1, '2024-10-04 11:20:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (318, 1, 166, 1, 1, 1, 0, '2024-10-04 11:24:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (319, 1, 247, 1, 0, 0, 0, '2024-10-04 11:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (320, 1, 318, 1, 1, 0, 1, '2021-09-17 23:23:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (324, 2, 237, 1, 0, 0, 0, '2021-09-18 01:01:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (327, 2, 135, 1, 1, 1, 0, '2021-10-07 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (334, 2, 221, 1, 1, 1, 1, '2021-09-18 01:25:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (335, 2, 222, 1, 1, 0, 1, '2021-09-18 01:26:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (336, 2, 299, 1, 0, 0, 0, '2021-10-07 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (337, 2, 303, 1, 0, 0, 0, '2021-10-07 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (339, 2, 305, 1, 0, 1, 0, '2021-09-18 01:38:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (341, 2, 307, 1, 0, 0, 0, '2021-09-18 01:43:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (343, 2, 320, 1, 0, 0, 0, '2021-09-18 01:44:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (346, 2, 138, 1, 1, 1, 0, '2021-10-07 01:02:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (350, 2, 143, 1, 1, 1, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (351, 2, 144, 1, 1, 0, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (354, 2, 329, 1, 0, 0, 0, '2021-09-18 02:23:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (356, 2, 326, 1, 0, 0, 0, '2021-10-07 05:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (357, 3, 132, 1, 1, 1, 1, '2021-09-21 20:39:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (358, 3, 134, 1, 1, 1, 1, '2021-09-19 19:30:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (362, 3, 135, 1, 1, 1, 1, '2021-09-19 19:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (363, 3, 137, 1, 1, 1, 1, '2021-09-19 19:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (364, 3, 192, 1, 0, 1, 0, '2021-09-19 19:46:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (373, 3, 218, 1, 0, 0, 0, '2021-09-19 21:47:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (374, 3, 219, 1, 0, 0, 0, '2021-09-19 21:48:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (375, 3, 221, 1, 1, 1, 1, '2021-09-19 21:48:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (376, 3, 222, 1, 1, 0, 1, '2021-09-19 21:51:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (377, 3, 299, 1, 1, 1, 1, '2021-09-19 21:53:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (378, 3, 303, 1, 1, 1, 1, '2021-09-19 22:05:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (379, 2, 139, 1, 1, 1, 0, '2021-10-07 01:02:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (380, 3, 304, 1, 0, 0, 0, '2021-09-19 22:21:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (382, 3, 305, 1, 0, 1, 0, '2021-09-19 22:23:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (384, 2, 198, 1, 0, 0, 0, '2021-09-19 22:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (386, 2, 300, 1, 1, 1, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (387, 2, 301, 1, 0, 0, 0, '2021-09-19 22:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (388, 2, 308, 1, 0, 0, 0, '2021-09-19 22:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (389, 2, 309, 1, 0, 0, 0, '2021-09-19 22:24:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (391, 2, 323, 1, 1, 1, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (392, 2, 324, 1, 1, 1, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (393, 2, 325, 1, 1, 1, 1, '2021-09-19 23:54:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (394, 3, 306, 1, 0, 0, 0, '2021-09-19 22:24:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (395, 3, 307, 1, 0, 0, 0, '2021-09-19 22:26:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (396, 3, 319, 1, 1, 1, 1, '2021-09-19 22:27:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (397, 3, 320, 1, 0, 0, 0, '2021-09-19 22:38:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (398, 3, 321, 1, 0, 0, 0, '2021-09-19 22:46:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (399, 3, 138, 1, 1, 1, 1, '2021-09-19 22:47:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (400, 3, 139, 1, 1, 1, 1, '2021-09-19 22:50:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (401, 3, 140, 1, 1, 1, 1, '2021-09-19 22:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (402, 3, 142, 1, 1, 1, 1, '2021-09-19 22:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (403, 3, 143, 1, 1, 1, 1, '2021-09-19 22:51:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (404, 3, 144, 1, 1, 0, 1, '2021-09-19 22:52:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (405, 3, 196, 1, 1, 1, 1, '2021-09-19 22:56:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (406, 3, 197, 1, 0, 1, 0, '2021-09-19 22:57:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (407, 3, 198, 1, 0, 0, 0, '2021-09-19 22:57:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (408, 3, 220, 1, 1, 1, 1, '2021-09-19 22:57:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (409, 3, 248, 1, 0, 1, 0, '2021-09-19 22:58:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (410, 3, 300, 1, 1, 1, 1, '2021-09-19 22:58:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (411, 3, 301, 1, 0, 0, 0, '2021-09-19 22:59:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (412, 3, 308, 1, 0, 0, 0, '2021-09-19 22:59:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (413, 3, 309, 1, 0, 1, 0, '2021-09-19 23:00:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (414, 3, 310, 1, 0, 0, 0, '2021-09-19 23:00:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (415, 3, 322, 1, 1, 1, 1, '2021-09-19 23:01:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (416, 3, 323, 1, 1, 1, 1, '2021-09-19 23:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (417, 3, 324, 1, 1, 1, 1, '2021-09-19 23:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (418, 3, 325, 1, 1, 1, 1, '2021-09-19 23:02:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (419, 3, 326, 1, 1, 1, 1, '2021-09-19 23:03:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (420, 3, 327, 1, 0, 0, 0, '2021-09-19 23:10:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (421, 3, 329, 1, 0, 0, 0, '2021-09-19 23:10:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (422, 3, 146, 1, 0, 0, 0, '2021-09-21 21:58:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (424, 2, 327, 1, 0, 0, 0, '2021-09-19 23:14:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (425, 3, 236, 1, 1, 1, 1, '2021-10-07 02:00:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (433, 3, 226, 1, 0, 0, 0, '2021-09-20 19:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (435, 3, 291, 1, 0, 0, 0, '2021-09-20 19:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (436, 3, 292, 1, 0, 0, 0, '2021-09-20 19:02:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (438, 3, 149, 1, 0, 0, 0, '2021-10-07 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (444, 3, 312, 1, 0, 0, 0, '2021-10-07 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (447, 2, 149, 1, 0, 0, 0, '2021-10-07 01:17:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (453, 2, 312, 1, 0, 1, 0, '2021-09-20 00:04:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (454, 2, 314, 1, 1, 0, 1, '2021-09-22 19:32:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (455, 2, 355, 1, 0, 1, 0, '2021-09-20 00:04:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (456, 3, 152, 1, 0, 0, 0, '2021-10-07 01:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (463, 3, 353, 1, 0, 0, 0, '2021-10-07 01:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (465, 2, 152, 1, 0, 0, 0, '2021-10-07 01:21:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (466, 2, 153, 1, 0, 0, 0, '2021-10-07 01:22:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (472, 2, 353, 1, 0, 1, 0, '2021-09-20 00:34:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (474, 3, 168, 1, 0, 0, 0, '2021-10-07 01:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (475, 2, 146, 1, 0, 0, 0, '2021-10-07 01:12:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (476, 2, 148, 1, 0, 0, 0, '2021-10-07 01:12:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (478, 2, 200, 1, 0, 0, 0, '2021-10-07 01:14:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (481, 2, 225, 1, 0, 0, 0, '2021-10-07 01:14:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (484, 2, 291, 1, 1, 0, 0, '2021-10-07 05:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (485, 2, 292, 1, 1, 0, 0, '2021-10-07 05:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (486, 2, 313, 1, 1, 0, 0, '2021-10-07 05:33:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (495, 3, 270, 1, 1, 0, 1, '2021-09-20 01:25:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (496, 2, 168, 1, 0, 0, 0, '2021-10-07 01:24:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (498, 2, 202, 1, 0, 0, 0, '2021-10-07 01:24:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (500, 2, 293, 1, 0, 0, 0, '2021-10-07 01:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (501, 2, 302, 1, 0, 0, 0, '2021-10-07 01:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (502, 2, 311, 1, 0, 0, 0, '2021-10-07 01:25:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (503, 2, 317, 1, 1, 0, 1, '2021-09-21 02:02:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (504, 3, 102, 1, 1, 1, 1, '2021-09-20 01:26:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (506, 3, 118, 1, 0, 0, 0, '2021-09-20 01:29:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (519, 3, 173, 1, 0, 0, 0, '2021-10-07 01:56:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (520, 3, 347, 1, 0, 0, 0, '2021-10-07 01:56:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (527, 3, 176, 1, 0, 0, 0, '2021-10-07 02:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (530, 3, 289, 1, 0, 0, 0, '2021-10-07 02:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (531, 3, 290, 1, 0, 0, 0, '2021-10-07 02:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (533, 3, 330, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (534, 3, 331, 1, 0, 0, 0, '2021-10-07 05:42:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (535, 3, 332, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (536, 3, 333, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (537, 3, 334, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (538, 3, 335, 1, 0, 0, 0, '2021-10-07 02:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (539, 3, 336, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (540, 3, 337, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (541, 3, 338, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (542, 3, 339, 1, 0, 0, 0, '2021-10-07 02:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (543, 3, 340, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (544, 3, 341, 1, 0, 0, 0, '2021-09-21 02:32:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (545, 3, 342, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (546, 3, 343, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (547, 3, 344, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (548, 3, 345, 1, 0, 0, 0, '2021-09-20 01:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (550, 3, 166, 1, 0, 0, 0, '2021-09-21 01:50:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (565, 3, 204, 1, 1, 1, 1, '2021-09-20 18:43:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (566, 3, 205, 1, 0, 0, 0, '2021-09-20 02:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (567, 3, 216, 1, 0, 0, 0, '2021-09-20 02:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (568, 3, 217, 1, 0, 0, 0, '2021-09-20 02:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (573, 3, 214, 1, 1, 1, 1, '2021-09-20 02:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (574, 3, 215, 1, 1, 1, 1, '2021-09-20 02:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (577, 3, 294, 1, 1, 1, 1, '2021-10-07 05:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (578, 3, 295, 1, 0, 1, 0, '2021-09-20 23:39:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (579, 3, 296, 1, 1, 1, 1, '2021-09-20 23:39:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (580, 3, 297, 1, 0, 0, 0, '2021-10-07 05:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (581, 3, 298, 1, 0, 0, 0, '2021-10-07 05:43:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (584, 2, 165, 1, 0, 0, 0, '2021-10-07 05:35:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (585, 2, 166, 1, 0, 0, 0, '2021-10-07 01:35:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (594, 2, 204, 1, 1, 1, 1, '2021-09-20 18:35:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (596, 2, 216, 1, 0, 0, 0, '2021-09-20 18:14:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (597, 2, 217, 1, 0, 0, 0, '2021-09-20 18:14:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (607, 2, 294, 1, 1, 1, 1, '2021-09-20 20:46:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (608, 2, 295, 1, 0, 1, 0, '2021-09-20 19:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (609, 2, 296, 1, 1, 1, 1, '2021-09-20 20:46:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (610, 2, 297, 1, 0, 1, 0, '2021-09-20 19:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (611, 2, 298, 1, 0, 1, 0, '2021-09-20 19:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (612, 2, 102, 1, 1, 1, 1, '2021-10-07 01:46:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (614, 2, 304, 1, 0, 0, 0, '2021-09-20 20:11:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (619, 3, 302, 1, 0, 0, 0, '2021-10-07 01:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (620, 3, 311, 1, 0, 0, 0, '2021-10-07 01:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (624, 3, 269, 1, 1, 0, 1, '2021-09-20 20:50:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (626, 2, 176, 1, 1, 1, 1, '2021-09-20 20:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (627, 2, 203, 1, 1, 1, 1, '2021-09-20 20:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (629, 2, 289, 1, 1, 1, 1, '2021-09-20 20:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (630, 2, 290, 1, 1, 1, 1, '2021-09-20 20:55:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (631, 2, 9, 1, 1, 1, 1, '2021-10-07 01:27:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (632, 2, 10, 1, 1, 1, 1, '2021-10-07 01:27:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (633, 2, 12, 1, 1, 1, 1, '2021-09-20 21:09:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (634, 2, 13, 1, 1, 1, 1, '2021-09-22 19:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (639, 2, 330, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (640, 2, 331, 1, 1, 0, 0, '2021-09-20 22:53:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (641, 2, 332, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (642, 2, 333, 1, 1, 0, 0, '2021-09-20 22:53:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (643, 2, 334, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (644, 2, 335, 1, 1, 0, 0, '2021-09-21 01:52:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (646, 2, 337, 1, 1, 0, 0, '2021-09-21 19:15:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (647, 2, 338, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (648, 2, 339, 1, 1, 0, 0, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (649, 2, 340, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (650, 2, 341, 1, 1, 0, 0, '2021-09-22 19:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (651, 2, 342, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (652, 2, 343, 1, 1, 0, 0, '2021-09-22 19:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (653, 2, 344, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (654, 2, 345, 1, 0, 0, 0, '2021-09-20 22:27:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (655, 2, 48, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (658, 2, 178, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (659, 2, 179, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (660, 2, 180, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (661, 2, 181, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (662, 2, 182, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (667, 2, 188, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (668, 2, 189, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (669, 2, 206, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (670, 2, 207, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (671, 2, 208, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (672, 2, 209, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (673, 2, 210, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (675, 2, 212, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (676, 2, 213, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (677, 2, 250, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (678, 2, 251, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (679, 2, 253, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (680, 2, 254, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (681, 2, 255, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (687, 2, 271, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (688, 2, 272, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (689, 2, 349, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (690, 2, 350, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (691, 2, 351, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (692, 2, 352, 1, 0, 0, 0, '2021-09-20 23:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (693, 3, 86, 1, 0, 0, 0, '2021-10-07 02:07:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (695, 2, 43, 1, 1, 1, 1, '2021-09-21 00:07:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (696, 2, 44, 1, 0, 0, 0, '2021-09-20 23:59:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (700, 3, 109, 1, 1, 0, 1, '2021-10-07 02:07:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (703, 2, 27, 1, 1, 0, 1, '2021-09-21 00:22:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (706, 2, 31, 1, 1, 0, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (707, 2, 32, 1, 1, 1, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (708, 2, 33, 1, 1, 1, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (709, 2, 34, 1, 1, 1, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (710, 2, 35, 1, 1, 1, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (711, 2, 104, 1, 1, 1, 1, '2021-09-21 00:38:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (712, 2, 315, 1, 1, 0, 1, '2021-09-22 19:34:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (726, 3, 43, 1, 1, 1, 1, '2021-09-21 01:03:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (727, 3, 44, 1, 0, 0, 0, '2021-09-21 01:03:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (728, 3, 27, 1, 1, 0, 1, '2021-09-21 01:12:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (735, 3, 165, 1, 0, 0, 0, '2021-10-07 02:02:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (750, 3, 267, 1, 1, 1, 1, '2021-09-21 01:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (751, 3, 274, 1, 0, 0, 0, '2021-09-21 01:45:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (752, 3, 279, 1, 1, 1, 1, '2021-09-21 01:47:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (757, 2, 86, 1, 1, 1, 1, '2021-09-21 20:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (764, 2, 283, 1, 1, 1, 1, '2021-09-22 01:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (765, 2, 284, 1, 1, 1, 1, '2021-09-22 01:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (766, 2, 285, 1, 1, 1, 1, '2021-09-22 01:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (767, 2, 286, 1, 1, 1, 1, '2021-09-22 01:07:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (768, 3, 48, 1, 0, 0, 0, '2021-09-21 02:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (771, 3, 178, 1, 0, 0, 0, '2021-09-21 02:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (775, 3, 182, 1, 0, 0, 0, '2021-09-21 02:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (801, 3, 272, 1, 0, 0, 0, '2021-09-21 02:12:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (806, 2, 88, 1, 0, 0, 0, '2021-10-07 05:36:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (807, 2, 90, 1, 0, 0, 0, '2021-10-07 05:36:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (809, 2, 109, 1, 1, 0, 1, '2021-09-27 06:57:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (814, 2, 249, 1, 1, 1, 1, '2021-09-22 01:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (816, 2, 310, 1, 0, 0, 0, '2021-09-21 18:00:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (817, 2, 129, 0, 1, 0, 1, '2021-09-22 01:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (819, 1, 362, 1, 0, 0, 0, '2021-09-21 18:50:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (820, 1, 363, 1, 1, 1, 1, '2024-10-05 09:30:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (821, 1, 364, 1, 0, 0, 0, '2021-09-21 18:59:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (822, 1, 365, 1, 1, 1, 1, '2024-10-05 09:36:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (823, 1, 366, 1, 0, 0, 0, '2021-09-21 18:59:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (826, 2, 132, 1, 1, 1, 0, '2021-10-07 01:01:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (849, 2, 319, 1, 0, 0, 0, '2021-10-07 05:31:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (870, 3, 368, 1, 0, 0, 0, '2021-09-21 20:33:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (924, 8, 152, 1, 0, 0, 0, '2021-10-07 04:04:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (927, 4, 270, 1, 0, 0, 0, '2021-10-07 02:27:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (948, 4, 334, 1, 0, 0, 0, '2021-09-21 23:56:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (949, 4, 335, 1, 1, 0, 0, '2021-09-30 06:47:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (962, 4, 176, 1, 1, 1, 1, '2021-10-07 05:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (963, 4, 203, 1, 1, 1, 1, '2021-10-07 05:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (965, 4, 289, 1, 1, 1, 1, '2021-09-30 07:32:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (966, 4, 290, 1, 1, 1, 1, '2021-09-30 07:32:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (983, 4, 216, 1, 0, 0, 0, '2021-09-22 00:25:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (984, 4, 217, 1, 0, 0, 0, '2021-09-22 00:34:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (990, 4, 86, 1, 0, 0, 0, '2021-10-07 02:37:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (995, 4, 109, 1, 1, 0, 1, '2021-10-01 00:27:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1001, 2, 118, 1, 0, 0, 0, '2021-09-22 00:55:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1016, 4, 43, 1, 1, 1, 1, '2021-09-22 01:04:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1017, 4, 44, 1, 0, 0, 0, '2021-09-22 01:04:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1018, 4, 27, 1, 1, 0, 1, '2021-09-22 01:12:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1060, 4, 179, 1, 0, 0, 0, '2021-09-22 01:51:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1099, 2, 336, 1, 0, 0, 0, '2021-09-22 19:19:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1119, 1, 367, 1, 1, 1, 1, '2024-10-05 09:38:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1134, 9, 102, 1, 1, 1, 1, '2021-09-22 20:44:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1136, 9, 132, 1, 0, 0, 0, '2021-10-07 04:18:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1137, 9, 134, 1, 0, 0, 0, '2021-10-07 04:18:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1138, 9, 135, 1, 0, 0, 0, '2021-10-07 04:18:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1141, 9, 218, 1, 0, 0, 0, '2021-09-22 20:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1142, 9, 219, 1, 0, 0, 0, '2021-09-22 20:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1145, 9, 299, 1, 1, 1, 1, '2021-09-22 22:31:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1146, 9, 303, 1, 0, 0, 0, '2021-10-07 04:24:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1147, 9, 304, 1, 0, 0, 0, '2021-09-22 20:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1148, 9, 305, 1, 0, 0, 0, '2021-10-07 04:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1150, 9, 307, 1, 0, 0, 0, '2021-09-22 20:46:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1151, 9, 319, 1, 0, 0, 0, '2021-10-07 04:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1165, 5, 308, 1, 0, 0, 0, '2021-09-22 20:57:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1175, 5, 329, 1, 0, 0, 0, '2021-09-22 22:14:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1189, 5, 149, 1, 1, 1, 1, '2021-09-22 22:40:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1190, 5, 175, 1, 1, 1, 1, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1191, 5, 243, 1, 0, 1, 0, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1193, 5, 260, 1, 1, 1, 1, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1194, 5, 263, 1, 1, 1, 1, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1195, 5, 312, 1, 0, 1, 0, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1196, 5, 314, 1, 1, 0, 1, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1197, 5, 355, 1, 0, 1, 0, '2021-09-22 22:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1204, 9, 138, 1, 0, 0, 0, '2021-10-07 04:51:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1205, 9, 139, 1, 0, 0, 0, '2021-10-07 04:51:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1206, 9, 140, 1, 1, 1, 1, '2021-10-23 04:56:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1207, 9, 142, 1, 1, 1, 1, '2021-10-23 04:56:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1210, 9, 196, 1, 0, 0, 0, '2021-10-07 04:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1212, 9, 198, 1, 0, 0, 0, '2021-09-22 23:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1213, 9, 220, 1, 0, 0, 0, '2021-10-07 04:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1215, 9, 300, 1, 1, 1, 1, '2021-09-23 01:24:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1216, 9, 301, 1, 0, 0, 0, '2021-09-22 23:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1217, 9, 308, 1, 0, 0, 0, '2021-09-22 23:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1218, 9, 309, 1, 0, 0, 0, '2021-10-07 04:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1220, 9, 322, 1, 1, 1, 1, '2021-09-23 01:24:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1224, 9, 326, 1, 0, 0, 0, '2021-10-07 04:27:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1225, 9, 327, 1, 0, 0, 0, '2021-09-22 23:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1226, 9, 329, 1, 0, 0, 0, '2021-09-22 23:19:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1246, 5, 317, 1, 1, 0, 1, '2021-09-23 00:16:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1248, 5, 270, 1, 0, 0, 0, '2021-10-07 03:23:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1250, 5, 102, 1, 1, 1, 1, '2021-09-23 00:32:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1251, 5, 346, 1, 0, 0, 0, '2021-09-23 00:32:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1269, 5, 337, 1, 1, 0, 0, '2021-09-23 01:31:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1278, 5, 236, 1, 0, 0, 0, '2021-10-07 03:26:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1306, 5, 216, 1, 0, 0, 0, '2021-09-23 01:40:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1307, 5, 217, 1, 0, 0, 0, '2021-09-23 01:40:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1317, 5, 86, 1, 0, 0, 0, '2021-10-07 03:29:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1322, 5, 109, 1, 1, 0, 1, '2021-09-23 19:36:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1329, 5, 43, 1, 1, 1, 1, '2021-09-30 00:45:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1330, 5, 44, 1, 0, 0, 0, '2021-09-23 02:12:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1331, 5, 27, 1, 1, 0, 1, '2021-09-23 02:15:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1355, 9, 270, 1, 0, 0, 0, '2021-10-07 06:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1358, 9, 236, 1, 0, 0, 0, '2021-10-07 04:42:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1370, 5, 158, 1, 0, 0, 0, '2021-09-23 19:44:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1416, 5, 369, 1, 0, 0, 0, '2021-09-23 20:16:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1426, 5, 180, 1, 0, 0, 0, '2021-09-23 20:23:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1460, 6, 270, 1, 0, 0, 0, '2021-10-07 03:38:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1503, 6, 304, 1, 0, 0, 0, '2021-09-27 00:19:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1509, 6, 319, 1, 0, 0, 0, '2021-10-07 06:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1518, 9, 216, 1, 0, 0, 0, '2021-09-27 00:45:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1519, 9, 217, 1, 0, 0, 0, '2021-09-27 00:45:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1579, 2, 155, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1580, 2, 156, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1581, 2, 157, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1582, 2, 158, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1583, 2, 159, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1584, 2, 161, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1585, 2, 162, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1586, 2, 190, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1587, 2, 191, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1588, 2, 238, 1, 0, 0, 0, '2021-09-27 05:41:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1596, 9, 48, 1, 0, 0, 0, '2021-09-27 06:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1599, 9, 178, 1, 0, 0, 0, '2021-09-27 06:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1603, 9, 182, 1, 0, 0, 0, '2021-09-27 06:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1631, 9, 350, 1, 0, 0, 0, '2021-09-27 06:56:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1663, 9, 27, 1, 0, 0, 0, '2021-10-23 04:59:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1664, 9, 43, 1, 1, 1, 1, '2021-09-28 01:25:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1665, 9, 44, 1, 0, 0, 0, '2021-09-28 01:20:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1666, 9, 86, 1, 0, 0, 0, '2021-10-07 04:46:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1671, 9, 109, 1, 1, 0, 1, '2021-09-28 01:58:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1679, 9, 204, 1, 1, 1, 1, '2021-09-28 03:31:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1680, 9, 205, 1, 0, 0, 0, '2021-09-28 03:31:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1697, 6, 152, 1, 1, 1, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1698, 6, 153, 1, 1, 1, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1699, 6, 171, 1, 1, 1, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1700, 6, 244, 1, 0, 1, 0, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1701, 6, 261, 1, 1, 1, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1702, 6, 262, 1, 1, 1, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1703, 6, 315, 1, 1, 0, 1, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1704, 6, 353, 1, 0, 1, 0, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1705, 6, 354, 1, 0, 1, 0, '2021-09-28 05:21:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1713, 6, 236, 1, 0, 0, 0, '2021-10-07 03:46:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1716, 6, 176, 1, 1, 1, 1, '2021-10-07 06:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1719, 6, 289, 1, 1, 1, 1, '2021-09-28 06:47:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1720, 6, 290, 1, 1, 1, 1, '2021-09-28 06:47:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1739, 6, 43, 1, 1, 1, 1, '2021-09-28 07:53:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1740, 6, 44, 1, 0, 0, 0, '2021-09-28 07:51:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1741, 6, 27, 1, 1, 0, 1, '2021-09-28 07:57:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1742, 6, 118, 1, 0, 0, 0, '2021-09-28 07:59:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1747, 6, 159, 1, 0, 0, 0, '2021-09-28 07:59:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1782, 2, 205, 1, 0, 0, 0, '2021-09-29 03:01:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1823, 6, 338, 1, 0, 0, 0, '2021-09-29 05:47:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1824, 6, 339, 1, 1, 0, 0, '2021-09-29 06:07:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1831, 2, 318, 1, 1, 0, 1, '2021-09-29 06:26:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1838, 6, 181, 1, 0, 0, 0, '2021-09-29 06:27:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1872, 6, 102, 1, 1, 1, 1, '2021-09-29 06:31:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1873, 6, 86, 1, 0, 0, 0, '2021-10-07 03:48:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1878, 6, 109, 1, 1, 0, 1, '2021-09-29 07:05:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1900, 6, 329, 1, 0, 0, 0, '2021-09-29 07:59:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1906, 5, 370, 1, 0, 0, 0, '2021-09-30 02:11:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1908, 4, 146, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1909, 4, 148, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1910, 4, 170, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1911, 4, 200, 1, 1, 0, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1912, 4, 201, 1, 0, 1, 0, '2021-09-30 05:42:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1913, 4, 224, 1, 0, 0, 0, '2021-09-30 05:36:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1914, 4, 225, 1, 1, 0, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1915, 4, 226, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1916, 4, 227, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1917, 4, 291, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1918, 4, 292, 1, 1, 1, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1919, 4, 313, 1, 1, 0, 1, '2021-10-07 02:24:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1931, 4, 236, 1, 0, 0, 0, '2021-10-07 02:30:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1934, 4, 118, 1, 0, 0, 0, '2021-10-01 00:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1937, 4, 157, 1, 0, 0, 0, '2021-10-01 00:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1944, 4, 238, 1, 0, 0, 0, '2021-10-01 00:51:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1957, 4, 256, 1, 0, 0, 0, '2021-10-01 00:54:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1976, 4, 102, 1, 1, 1, 1, '2021-10-01 01:33:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1977, 4, 274, 1, 0, 0, 0, '2021-10-01 01:36:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1980, 9, 137, 1, 1, 1, 1, '2021-10-23 04:54:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1981, 2, 173, 1, 1, 1, 1, '2021-10-07 05:34:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1982, 2, 347, 1, 0, 1, 1, '2021-10-07 05:34:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1995, 1, 196, 1, 1, 1, 1, '2024-10-03 11:37:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1996, 1, 323, 1, 1, 1, 1, '2024-10-03 11:59:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1997, 1, 324, 1, 1, 1, 1, '2024-10-03 12:01:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1998, 1, 325, 1, 1, 1, 1, '2024-10-03 12:02:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1999, 1, 236, 1, 1, 1, 1, '2024-10-07 08:02:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2001, 2, 270, 1, 0, 0, 0, '2021-10-07 01:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2002, 2, 236, 1, 1, 1, 0, '2021-10-07 01:28:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2003, 2, 266, 1, 0, 0, 0, '2021-10-07 01:43:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2019, 8, 132, 1, 1, 1, 1, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2020, 8, 135, 1, 1, 1, 1, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2021, 8, 218, 1, 0, 0, 0, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2022, 8, 219, 1, 0, 0, 0, '2021-10-07 04:00:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2023, 8, 221, 1, 1, 1, 1, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2024, 8, 222, 1, 1, 0, 1, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2025, 8, 138, 1, 1, 1, 1, '2021-10-07 04:00:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2026, 8, 139, 1, 1, 1, 1, '2021-10-07 04:00:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2027, 8, 143, 1, 1, 1, 1, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2028, 8, 144, 1, 1, 0, 1, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2029, 8, 326, 1, 0, 0, 0, '2021-10-07 04:01:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2031, 8, 196, 1, 1, 1, 1, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2032, 8, 198, 1, 0, 0, 0, '2021-10-07 04:03:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2034, 4, 202, 1, 0, 0, 0, '2021-10-07 04:03:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2035, 8, 146, 1, 0, 0, 0, '2021-10-07 04:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2036, 8, 148, 1, 0, 0, 0, '2021-10-07 04:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2037, 8, 200, 1, 0, 0, 0, '2021-10-07 04:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2038, 8, 225, 1, 0, 0, 0, '2021-10-07 04:03:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2039, 8, 149, 1, 0, 0, 0, '2021-10-07 04:04:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2042, 8, 168, 1, 0, 0, 0, '2021-10-07 04:04:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2043, 8, 270, 1, 0, 0, 0, '2021-10-07 04:05:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2044, 8, 173, 1, 0, 0, 0, '2021-10-07 04:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2045, 8, 347, 1, 0, 0, 0, '2021-10-07 04:06:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2046, 8, 330, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2047, 8, 332, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2048, 8, 334, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2049, 8, 336, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2050, 8, 338, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2051, 8, 340, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2052, 8, 342, 1, 0, 0, 0, '2021-10-07 04:08:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2053, 8, 236, 1, 1, 1, 0, '2021-10-07 04:08:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2055, 8, 165, 1, 1, 1, 1, '2021-10-07 06:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2056, 8, 166, 1, 1, 1, 1, '2021-10-07 06:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2057, 8, 80, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2058, 8, 81, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2059, 8, 82, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2060, 8, 83, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2061, 8, 84, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2062, 8, 85, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2063, 8, 204, 1, 1, 1, 1, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2064, 8, 205, 1, 0, 0, 0, '2021-10-07 04:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2065, 8, 214, 1, 0, 0, 0, '2021-10-07 04:11:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2066, 8, 215, 1, 0, 0, 0, '2021-10-07 04:11:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2067, 8, 86, 1, 0, 0, 0, '2021-10-07 04:11:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2068, 8, 109, 1, 1, 0, 1, '2021-10-07 04:11:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2069, 8, 31, 1, 0, 0, 0, '2021-10-07 04:12:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2070, 8, 32, 1, 0, 0, 0, '2021-10-07 04:12:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2071, 8, 48, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2072, 8, 89, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2073, 8, 178, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2074, 8, 180, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2075, 8, 181, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2076, 8, 182, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2077, 8, 207, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2078, 8, 208, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2079, 8, 209, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2080, 8, 253, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2081, 8, 254, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2082, 8, 255, 1, 0, 0, 0, '2021-10-07 04:13:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2083, 8, 118, 1, 0, 0, 0, '2021-10-07 04:14:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2084, 8, 238, 1, 0, 0, 0, '2021-10-07 04:14:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2085, 8, 102, 1, 1, 1, 1, '2021-10-07 04:14:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2086, 9, 321, 1, 0, 0, 0, '2021-10-07 04:25:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2093, 1, 132, 1, 1, 1, 1, '2024-10-03 07:41:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2094, 1, 198, 1, 0, 0, 0, '2021-10-07 04:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2095, 1, 327, 1, 0, 0, 0, '2021-10-07 04:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2096, 1, 329, 1, 0, 0, 0, '2021-10-07 04:55:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2108, 1, 294, 1, 1, 1, 1, '2024-10-02 12:40:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2109, 1, 296, 1, 1, 1, 1, '2024-10-02 12:42:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2112, 1, 129, 0, 1, 0, 1, '2021-10-07 04:56:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2113, 1, 27, 1, 1, 1, 1, '2024-10-05 09:22:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2127, 1, 320, 1, 0, 0, 0, '2021-10-07 05:01:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2128, 1, 321, 1, 0, 0, 0, '2021-10-07 05:01:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2150, 1, 280, 1, 1, 1, 1, '2024-10-04 13:01:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2152, 1, 370, 1, 0, 0, 0, '2021-10-07 05:30:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2155, 2, 321, 1, 0, 0, 0, '2021-10-07 05:31:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2156, 2, 197, 1, 0, 0, 0, '2021-10-07 05:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2157, 2, 248, 1, 0, 0, 0, '2021-10-07 05:33:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2158, 2, 264, 1, 1, 0, 1, '2021-10-07 05:34:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2159, 2, 247, 1, 0, 0, 0, '2021-10-07 05:35:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2160, 2, 281, 1, 0, 0, 0, '2021-10-07 05:40:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2161, 2, 282, 1, 0, 0, 0, '2021-10-07 05:40:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2162, 2, 371, 1, 0, 0, 0, '2021-10-07 05:40:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2163, 3, 257, 1, 0, 0, 0, '2021-10-07 05:41:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2164, 3, 355, 1, 0, 0, 0, '2021-10-07 05:41:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2165, 3, 153, 1, 0, 0, 0, '2021-10-07 05:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2166, 3, 244, 1, 0, 0, 0, '2021-10-07 05:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2167, 3, 354, 1, 0, 0, 0, '2021-10-07 05:41:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2168, 3, 202, 1, 0, 0, 0, '2021-10-07 05:42:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2169, 3, 246, 1, 0, 0, 0, '2021-10-07 05:42:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2170, 3, 237, 1, 0, 0, 0, '2021-10-07 05:43:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2171, 3, 240, 1, 0, 1, 0, '2021-10-07 05:43:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2172, 3, 242, 1, 0, 1, 0, '2021-10-07 05:43:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2173, 3, 129, 0, 1, 0, 1, '2021-10-07 05:43:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2174, 3, 183, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2175, 3, 188, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2176, 3, 206, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2177, 3, 207, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2178, 3, 208, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2179, 3, 209, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2180, 3, 211, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2181, 3, 258, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2182, 3, 271, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2183, 3, 350, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2184, 3, 369, 1, 0, 0, 0, '2021-10-07 05:46:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2185, 3, 238, 1, 0, 0, 0, '2021-10-07 05:46:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2186, 3, 362, 1, 0, 0, 0, '2021-10-07 05:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2187, 3, 363, 1, 1, 1, 1, '2021-10-07 05:47:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2188, 3, 366, 1, 0, 0, 0, '2021-10-07 05:46:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2189, 3, 367, 1, 1, 1, 1, '2021-10-07 05:47:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2190, 3, 371, 1, 0, 0, 0, '2021-10-07 05:47:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2194, 4, 132, 1, 0, 0, 0, '2021-10-07 05:50:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2195, 4, 138, 1, 0, 0, 0, '2021-10-07 05:51:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2196, 4, 264, 1, 1, 0, 1, '2021-10-07 05:52:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2198, 4, 371, 1, 0, 0, 0, '2021-10-07 05:56:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2201, 5, 132, 1, 0, 0, 0, '2021-10-07 05:56:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2202, 5, 304, 1, 0, 0, 0, '2021-10-07 05:56:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2204, 5, 138, 1, 0, 0, 0, '2021-10-07 05:57:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2205, 5, 139, 1, 0, 0, 0, '2021-10-07 05:57:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2206, 5, 307, 1, 0, 0, 0, '2021-10-07 05:57:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2207, 5, 257, 1, 1, 1, 1, '2021-10-07 05:58:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2209, 5, 168, 1, 1, 1, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2210, 5, 169, 1, 1, 1, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2211, 5, 202, 1, 1, 0, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2212, 5, 246, 1, 0, 0, 0, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2213, 5, 293, 1, 1, 1, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2214, 5, 302, 1, 1, 0, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2215, 5, 311, 1, 1, 1, 1, '2021-10-07 05:58:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2216, 5, 336, 1, 0, 0, 0, '2021-10-07 05:59:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2217, 5, 274, 1, 0, 0, 0, '2021-10-07 06:00:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2219, 5, 183, 1, 0, 0, 0, '2021-10-07 06:01:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2220, 5, 211, 1, 0, 0, 0, '2021-10-07 06:01:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2221, 5, 371, 1, 0, 0, 0, '2021-10-07 06:02:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2222, 6, 132, 1, 0, 0, 0, '2021-10-07 06:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2223, 6, 135, 1, 0, 0, 0, '2021-10-07 06:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2224, 6, 138, 1, 0, 0, 0, '2021-10-07 06:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2225, 6, 139, 1, 0, 0, 0, '2021-10-07 06:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2226, 6, 308, 1, 0, 0, 0, '2021-10-07 06:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2227, 6, 309, 1, 0, 0, 0, '2021-10-07 06:03:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2228, 6, 203, 1, 1, 1, 1, '2021-10-07 06:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2229, 6, 264, 1, 1, 0, 1, '2021-10-07 06:04:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2231, 6, 274, 1, 0, 0, 0, '2021-10-07 06:06:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2232, 6, 371, 1, 0, 0, 0, '2021-10-07 06:07:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2233, 8, 304, 1, 0, 0, 0, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2234, 8, 305, 1, 0, 1, 0, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2235, 8, 306, 1, 0, 0, 0, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2236, 8, 307, 1, 0, 0, 0, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2237, 8, 319, 1, 1, 1, 1, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2238, 8, 320, 1, 0, 0, 0, '2021-10-07 06:09:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2239, 8, 301, 1, 0, 0, 0, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2240, 8, 309, 1, 0, 1, 0, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2241, 8, 310, 1, 0, 0, 0, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2242, 8, 329, 1, 0, 0, 0, '2021-10-07 06:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2243, 8, 257, 1, 0, 0, 0, '2021-10-07 06:10:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2244, 8, 153, 1, 0, 0, 0, '2021-10-07 06:11:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2245, 8, 169, 1, 0, 0, 0, '2021-10-07 06:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2246, 8, 202, 1, 0, 0, 0, '2021-10-07 06:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2247, 8, 302, 1, 0, 0, 0, '2021-10-07 06:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2248, 8, 311, 1, 0, 0, 0, '2021-10-07 06:11:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2249, 2, 348, 1, 0, 1, 0, '2021-10-07 06:17:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2250, 8, 247, 1, 1, 1, 1, '2021-10-07 06:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2251, 8, 318, 1, 1, 0, 1, '2021-10-07 06:12:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2252, 8, 294, 1, 1, 1, 1, '2021-10-07 06:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2253, 8, 295, 1, 0, 1, 0, '2021-10-07 06:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2254, 8, 296, 1, 1, 1, 1, '2021-10-07 06:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2255, 8, 297, 1, 0, 0, 0, '2021-10-07 06:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2256, 8, 298, 1, 0, 0, 0, '2021-10-07 06:13:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2257, 2, 56, 1, 0, 0, 0, '2021-10-07 06:13:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2258, 8, 43, 1, 1, 1, 1, '2021-10-07 06:13:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2259, 8, 44, 1, 0, 0, 0, '2021-10-07 06:13:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2260, 8, 27, 1, 1, 0, 1, '2021-10-07 06:13:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2261, 8, 274, 1, 0, 0, 0, '2021-10-07 06:13:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2262, 2, 54, 1, 0, 0, 0, '2021-10-07 06:13:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2263, 8, 183, 1, 0, 0, 0, '2021-10-07 06:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2264, 8, 256, 1, 0, 0, 0, '2021-10-07 06:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2265, 8, 258, 1, 0, 0, 0, '2021-10-07 06:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2266, 8, 259, 1, 0, 0, 0, '2021-10-07 06:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2267, 8, 350, 1, 0, 0, 0, '2021-10-07 06:15:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2268, 8, 162, 1, 0, 0, 0, '2021-10-07 06:15:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2269, 8, 371, 1, 0, 0, 0, '2021-10-07 06:15:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2271, 9, 274, 1, 0, 0, 0, '2021-10-07 06:19:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2272, 9, 118, 1, 0, 0, 0, '2021-10-07 06:20:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2273, 9, 238, 1, 0, 0, 0, '2021-10-07 06:20:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2274, 9, 371, 1, 0, 0, 0, '2021-10-07 06:20:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2275, 1, 218, 1, 0, 0, 0, '2021-10-07 06:20:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2279, 1, 333, 1, 1, 0, 0, '2024-10-02 12:04:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2281, 1, 335, 1, 1, 0, 0, '2024-10-02 12:13:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2283, 1, 337, 1, 1, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2284, 1, 338, 1, 0, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2285, 1, 339, 1, 1, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2286, 1, 340, 1, 0, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2287, 1, 341, 1, 1, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2288, 1, 342, 1, 0, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2289, 1, 343, 1, 1, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2290, 1, 344, 1, 0, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2291, 1, 345, 1, 0, 0, 0, '2021-10-22 00:27:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2292, 1, 372, 1, 0, 0, 0, '2024-10-07 07:17:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2293, 1, 373, 1, 0, 0, 0, '2024-10-05 10:29:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2294, 1, 374, 1, 1, 1, 1, '2024-10-07 07:50:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2295, 1, 375, 1, 1, 1, 1, '2024-10-07 07:50:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2296, 1, 386, 1, 1, 0, 1, '2024-10-02 12:59:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2297, 3, 386, 1, 1, 0, 1, '2021-11-10 06:22:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2298, 1, 387, 1, 0, 0, 0, '2021-11-10 06:24:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2299, 3, 387, 1, 0, 0, 0, '2021-11-10 06:24:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2300, 1, 419, 1, 1, 1, 1, '2024-10-05 07:16:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2301, 1, 415, 1, 0, 0, 0, '2024-08-20 10:19:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2302, 1, 416, 1, 1, 1, 1, '2024-10-05 07:06:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2303, 1, 417, 1, 1, 1, 1, '2024-10-05 07:08:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2304, 1, 418, 1, 1, 1, 1, '2024-10-05 07:12:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2305, 1, 414, 1, 0, 1, 0, '2024-08-20 10:20:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2306, 1, 398, 1, 1, 1, 1, '2024-10-03 09:29:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2307, 1, 402, 1, 0, 0, 0, '2024-08-20 10:21:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2308, 1, 413, 1, 0, 1, 0, '2024-08-20 10:21:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2309, 1, 409, 1, 0, 0, 1, '2024-10-05 09:24:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2310, 1, 410, 1, 1, 0, 1, '2024-10-05 09:26:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2311, 1, 411, 1, 0, 0, 0, '2024-08-20 10:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2312, 1, 412, 1, 0, 0, 0, '2024-08-20 10:21:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2313, 1, 406, 1, 1, 1, 1, '2024-10-04 08:05:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2314, 1, 407, 1, 1, 1, 1, '2024-10-04 08:06:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2315, 1, 408, 1, 1, 1, 1, '2024-10-04 08:08:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2317, 1, 393, 1, 1, 1, 1, '2024-10-03 12:13:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2318, 1, 394, 1, 1, 1, 1, '2024-10-03 12:24:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2319, 1, 395, 1, 1, 1, 0, '2024-10-03 12:26:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2320, 1, 396, 1, 1, 1, 1, '2024-08-20 10:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2321, 1, 401, 1, 0, 0, 0, '2024-08-20 10:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2322, 1, 403, 1, 0, 0, 0, '2024-08-20 10:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2323, 1, 404, 1, 0, 0, 0, '2024-08-20 10:23:11');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2324, 1, 392, 1, 1, 1, 1, '2024-10-03 09:10:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2325, 1, 400, 1, 0, 0, 0, '2024-08-20 10:25:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2326, 1, 390, 1, 0, 0, 0, '2024-08-20 10:25:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2327, 1, 399, 1, 0, 0, 0, '2024-08-20 10:25:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2328, 1, 388, 1, 1, 1, 1, '2024-10-07 07:54:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2329, 1, 389, 1, 1, 1, 1, '2024-10-07 07:56:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2330, 1, 391, 1, 1, 1, 1, '2024-10-07 07:57:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2331, 1, 397, 1, 0, 0, 0, '2024-08-20 10:31:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2336, 3, 11002, 1, 0, 0, 0, '2024-09-28 12:29:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2337, 3, 11001, 1, 0, 0, 0, '2024-09-28 12:30:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2338, 3, 419, 1, 1, 1, 1, '2024-09-28 12:31:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2339, 3, 415, 1, 0, 0, 0, '2024-09-28 12:31:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2340, 3, 416, 1, 1, 1, 1, '2024-09-28 12:32:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2341, 3, 417, 1, 1, 1, 1, '2024-09-28 12:32:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2342, 3, 418, 1, 1, 1, 1, '2024-09-28 12:32:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2345, 3, 10002, 1, 0, 0, 0, '2024-09-30 07:37:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2346, 3, 10001, 1, 0, 0, 0, '2024-09-30 07:37:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2347, 1, 10001, 1, 0, 0, 0, '2024-10-02 11:40:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2348, 1, 10002, 1, 0, 0, 0, '2024-10-02 11:40:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2349, 1, 11001, 1, 0, 0, 0, '2024-10-02 11:41:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2350, 1, 11002, 1, 0, 0, 0, '2024-10-02 11:41:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2351, 1, 118, 1, 0, 0, 0, '2024-10-02 11:42:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2352, 1, 155, 1, 0, 0, 0, '2024-10-02 11:43:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2353, 1, 156, 1, 0, 0, 0, '2024-10-02 11:43:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2354, 1, 157, 1, 0, 0, 0, '2024-10-02 11:44:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2355, 1, 158, 1, 0, 0, 0, '2024-10-02 11:44:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2356, 1, 159, 1, 0, 0, 0, '2024-10-02 11:44:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2357, 1, 161, 1, 0, 0, 0, '2024-10-02 11:45:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2358, 1, 162, 1, 0, 0, 0, '2024-10-02 11:45:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2359, 1, 190, 1, 0, 0, 0, '2024-10-02 11:45:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2360, 1, 191, 1, 0, 0, 0, '2024-10-02 11:46:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2361, 1, 238, 1, 0, 0, 0, '2024-10-02 11:46:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2362, 1, 281, 1, 0, 0, 0, '2024-10-02 11:47:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2363, 1, 282, 1, 0, 0, 0, '2024-10-02 11:47:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2364, 1, 330, 1, 0, 0, 0, '2024-10-02 11:49:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2365, 1, 331, 1, 1, 0, 0, '2024-10-02 11:54:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2367, 1, 332, 1, 0, 0, 0, '2024-10-02 11:59:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2368, 1, 334, 1, 0, 0, 0, '2024-10-02 12:06:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2369, 1, 336, 1, 0, 0, 0, '2024-10-02 12:15:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2370, 1, 295, 1, 0, 1, 0, '2024-10-02 12:41:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2371, 1, 405, 1, 1, 1, 1, '2024-10-02 12:55:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2372, 1, 297, 1, 0, 0, 0, '2024-10-02 12:55:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2373, 1, 298, 1, 0, 0, 0, '2024-10-02 12:56:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2374, 1, 200, 1, 1, 0, 1, '2024-10-04 07:37:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2375, 1, 48, 1, 0, 0, 0, '2024-10-05 10:30:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2376, 1, 89, 1, 0, 0, 0, '2024-10-05 10:30:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2377, 1, 91, 1, 0, 0, 0, '2024-10-05 10:35:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2378, 1, 178, 1, 0, 0, 0, '2024-10-05 10:35:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2379, 1, 179, 1, 0, 0, 0, '2024-10-05 10:35:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2380, 1, 180, 1, 0, 0, 0, '2024-10-05 10:36:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2381, 1, 181, 1, 0, 0, 0, '2024-10-05 10:37:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2382, 1, 182, 1, 0, 0, 0, '2024-10-05 10:37:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2383, 1, 183, 1, 0, 0, 0, '2024-10-05 10:38:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2384, 1, 184, 1, 0, 0, 0, '2024-10-05 10:39:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2385, 1, 187, 1, 0, 0, 0, '2024-10-05 10:40:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2386, 1, 188, 1, 0, 0, 0, '2024-10-05 10:41:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2387, 1, 206, 1, 0, 0, 0, '2024-10-05 10:42:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2390, 1, 207, 1, 0, 0, 0, '2024-10-05 10:51:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2391, 1, 208, 1, 0, 0, 0, '2024-10-05 10:52:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2392, 1, 209, 1, 0, 0, 0, '2024-10-05 10:54:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2393, 1, 210, 1, 0, 0, 0, '2024-10-05 10:56:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2394, 1, 211, 1, 0, 0, 0, '2024-10-05 10:58:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2395, 1, 212, 1, 0, 0, 0, '2024-10-05 11:01:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2396, 1, 213, 1, 0, 0, 0, '2024-10-05 11:01:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2397, 1, 253, 1, 0, 0, 0, '2024-10-05 11:04:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2398, 1, 255, 1, 0, 0, 0, '2024-10-05 11:05:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2400, 1, 256, 1, 0, 0, 0, '2024-10-05 11:07:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2401, 1, 258, 1, 0, 0, 0, '2024-10-05 11:08:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2402, 1, 259, 1, 0, 0, 0, '2024-10-05 11:08:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2403, 1, 271, 1, 0, 0, 0, '2024-10-05 11:09:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2404, 1, 272, 1, 0, 0, 0, '2024-10-05 11:09:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2405, 1, 350, 1, 0, 0, 0, '2024-10-05 11:10:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2406, 1, 351, 1, 0, 0, 0, '2024-10-05 11:10:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2407, 1, 352, 1, 0, 0, 0, '2024-10-05 11:12:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2408, 1, 369, 1, 0, 0, 0, '2024-10-05 11:12:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2409, 1, 53, 1, 1, 0, 0, '2024-10-07 07:21:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2410, 1, 54, 1, 0, 1, 0, '2024-10-07 07:24:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2412, 1, 56, 1, 0, 1, 0, '2024-10-07 07:32:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2413, 1, 57, 1, 0, 1, 0, '2024-10-07 07:33:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2414, 1, 58, 1, 0, 1, 0, '2024-10-07 07:34:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2415, 1, 59, 1, 0, 1, 0, '2024-10-07 07:36:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2416, 1, 130, 1, 1, 0, 1, '2024-10-07 07:39:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2417, 1, 371, 1, 0, 0, 0, '2024-10-07 08:59:14');


#
# TABLE STRUCTURE FOR: sch_settings
#

DROP TABLE IF EXISTS `sch_settings`;

CREATE TABLE `sch_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `base_url` varchar(500) DEFAULT NULL,
  `folder_path` text,
  `name` varchar(100) DEFAULT NULL,
  `biometric` int DEFAULT '0',
  `biometric_device` text,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text,
  `start_month` varchar(100) NOT NULL,
  `session_id` int DEFAULT NULL,
  `lang_id` int DEFAULT NULL,
  `languages` varchar(255) NOT NULL DEFAULT '["4"]',
  `dise_code` varchar(50) DEFAULT NULL,
  `date_format` varchar(50) NOT NULL,
  `time_format` varchar(20) DEFAULT '24-hour',
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `is_rtl` varchar(10) DEFAULT 'disabled',
  `timezone` varchar(30) DEFAULT 'UTC',
  `image` varchar(100) DEFAULT NULL,
  `mini_logo` varchar(200) NOT NULL,
  `theme` varchar(200) NOT NULL DEFAULT 'default.jpg',
  `credit_limit` varchar(255) DEFAULT NULL,
  `opd_record_month` varchar(50) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `cron_secret_key` varchar(100) NOT NULL,
  `doctor_restriction` varchar(100) NOT NULL,
  `superadmin_restriction` varchar(200) NOT NULL,
  `patient_panel` varchar(50) NOT NULL,
  `scan_code_type` varchar(50) NOT NULL DEFAULT 'barcode',
  `mobile_api_url` varchar(200) NOT NULL,
  `app_primary_color_code` varchar(50) NOT NULL,
  `app_secondary_color_code` varchar(50) NOT NULL,
  `app_logo` varchar(200) NOT NULL,
  `zoom_api_key` varchar(200) NOT NULL,
  `zoom_api_secret` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `lang_id` (`lang_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `sch_settings` (`id`, `base_url`, `folder_path`, `name`, `biometric`, `biometric_device`, `email`, `phone`, `address`, `start_month`, `session_id`, `lang_id`, `languages`, `dise_code`, `date_format`, `time_format`, `currency`, `currency_symbol`, `is_rtl`, `timezone`, `image`, `mini_logo`, `theme`, `credit_limit`, `opd_record_month`, `is_active`, `cron_secret_key`, `doctor_restriction`, `superadmin_restriction`, `patient_panel`, `scan_code_type`, `mobile_api_url`, `app_primary_color_code`, `app_secondary_color_code`, `app_logo`, `zoom_api_key`, `zoom_api_secret`, `created_at`) VALUES (1, NULL, NULL, 'Your Hospital Name', 0, '', 'Your Hospital Email', 'Your Hospital Phone', 'Your Hospital Address', '', NULL, 4, '[\"4\",\"50\"]', 'Your Hospital Code', 'd/m/Y', '12-hour', 'USD', '$', 'disabled', 'Asia/Kolkata', '0.png', '0mini_logo.png', 'default.jpg', '20000', '1', 'no', '', 'disabled', 'enabled', 'enabled', 'barcode', '', '#424242', '#eeeeee', '0app_logo.png', '', '', '2024-10-14 11:14:42');


#
# TABLE STRUCTURE FOR: send_notification
#

DROP TABLE IF EXISTS `send_notification`;

CREATE TABLE `send_notification` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `message` text,
  `visible_staff` varchar(10) NOT NULL DEFAULT 'no',
  `visible_patient` varchar(10) NOT NULL DEFAULT 'no',
  `created_by` varchar(60) DEFAULT NULL,
  `created_id` int DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_id` (`created_id`),
  KEY `index_title` (`title`),
  KEY `index_publish_date` (`publish_date`),
  KEY `index_date` (`date`),
  KEY `index_visible_staff` (`visible_staff`),
  KEY `index_visible_patient` (`visible_patient`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `send_notification` (`id`, `title`, `publish_date`, `date`, `message`, `visible_staff`, `visible_patient`, `created_by`, `created_id`, `is_active`, `created_at`) VALUES (1, 'DOCUMENT', '2024-10-01', '2024-09-30', '<p>all document submitted</p>', 'Yes', 'No', 'admin', 1, 'no', '2024-09-30 12:24:52');
INSERT INTO `send_notification` (`id`, `title`, `publish_date`, `date`, `message`, `visible_staff`, `visible_patient`, `created_by`, `created_id`, `is_active`, `created_at`) VALUES (3, 'today absent doctor', '2024-10-11', '2024-10-22', '<p>absent</p>', 'Yes', 'No', 'admin', 1, 'no', '2024-10-11 12:25:57');
INSERT INTO `send_notification` (`id`, `title`, `publish_date`, `date`, `message`, `visible_staff`, `visible_patient`, `created_by`, `created_id`, `is_active`, `created_at`) VALUES (4, 'Please follow all protocal', '2024-10-12', '2024-10-11', '<p>all staff and patient Please follow all protocal</p>', 'Yes', 'No', 'admin', 1, 'no', '2024-10-11 12:27:46');


#
# TABLE STRUCTURE FOR: share_content_for
#

DROP TABLE IF EXISTS `share_content_for`;

CREATE TABLE `share_content_for` (
  `id` int NOT NULL AUTO_INCREMENT,
  `group_id` varchar(20) DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `share_content_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `upload_content_id` (`share_content_id`),
  KEY `student_id` (`patient_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (1, 'patient', NULL, NULL, 1, '2024-09-28 09:06:48');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (2, 'patient', NULL, NULL, 2, '2024-09-28 10:34:35');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (3, 'patient', NULL, NULL, 4, '2024-09-30 12:32:52');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (4, '1', NULL, NULL, 4, '2024-09-30 12:32:52');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (5, '2', NULL, NULL, 4, '2024-09-30 12:32:52');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (6, '3', NULL, NULL, 4, '2024-09-30 12:32:52');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (7, 'patient', NULL, NULL, 5, '2024-09-30 12:38:37');
INSERT INTO `share_content_for` (`id`, `group_id`, `patient_id`, `staff_id`, `share_content_id`, `created_at`) VALUES (8, '1', NULL, NULL, 5, '2024-09-30 12:38:37');


#
# TABLE STRUCTURE FOR: share_contents
#

DROP TABLE IF EXISTS `share_contents`;

CREATE TABLE `share_contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `send_to` varchar(50) DEFAULT NULL,
  `title` text,
  `share_date` date DEFAULT NULL,
  `valid_upto` date DEFAULT NULL,
  `description` text,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `index_send_to` (`send_to`),
  KEY `index_share_date` (`share_date`),
  KEY `index_valid_upto` (`valid_upto`),
  KEY `index_created_by` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `share_contents` (`id`, `send_to`, `title`, `share_date`, `valid_upto`, `description`, `created_by`, `created_at`) VALUES (3, 'public', 'hospital list', '2024-09-23', '2024-09-30', NULL, 1, '2024-09-30 12:32:23');
INSERT INTO `share_contents` (`id`, `send_to`, `title`, `share_date`, `valid_upto`, `description`, `created_by`, `created_at`) VALUES (4, 'group', 'Hospital List', '2024-09-27', '2024-09-30', 'dsf', 1, '2024-09-30 12:32:52');
INSERT INTO `share_contents` (`id`, `send_to`, `title`, `share_date`, `valid_upto`, `description`, `created_by`, `created_at`) VALUES (5, 'group', 'Pharmacy list', '2024-09-16', NULL, 'sdf', 1, '2024-09-30 12:38:37');


#
# TABLE STRUCTURE FOR: share_upload_contents
#

DROP TABLE IF EXISTS `share_upload_contents`;

CREATE TABLE `share_upload_contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `upload_content_id` int DEFAULT NULL,
  `share_content_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `upload_content_id` (`upload_content_id`),
  KEY `share_content_id` (`share_content_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (1, 11, 1, '2024-09-28 09:06:48');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (2, 28, 2, '2024-09-28 10:34:35');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (3, 46, 3, '2024-09-30 12:32:23');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (4, 47, 3, '2024-09-30 12:32:23');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (5, 46, 4, '2024-09-30 12:32:52');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (6, 47, 4, '2024-09-30 12:32:52');
INSERT INTO `share_upload_contents` (`id`, `upload_content_id`, `share_content_id`, `created_at`) VALUES (7, 47, 5, '2024-09-30 12:38:37');


#
# TABLE STRUCTURE FOR: shift_details
#

DROP TABLE IF EXISTS `shift_details`;

CREATE TABLE `shift_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `consult_duration` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_consult_duration` (`consult_duration`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `shift_details` (`id`, `staff_id`, `consult_duration`, `charge_id`, `created_at`) VALUES (1, 2, 15, 1, '2024-09-26 07:30:33');


#
# TABLE STRUCTURE FOR: sms_config
#

DROP TABLE IF EXISTS `sms_config`;

CREATE TABLE `sms_config` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `api_id` varchar(100) NOT NULL,
  `authkey` varchar(100) NOT NULL,
  `senderid` varchar(100) NOT NULL,
  `contact` text,
  `username` varchar(150) DEFAULT NULL,
  `url` varchar(150) DEFAULT NULL,
  `password` varchar(150) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'disabled',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `sms_config` (`id`, `type`, `name`, `api_id`, `authkey`, `senderid`, `contact`, `username`, `url`, `password`, `is_active`, `created_at`) VALUES (1, 'clickatell', '', '45667', '', '', NULL, 'superadmin@gmail.com', NULL, 'superadmin', 'disabled', '2024-10-14 11:18:31');
INSERT INTO `sms_config` (`id`, `type`, `name`, `api_id`, `authkey`, `senderid`, `contact`, `username`, `url`, `password`, `is_active`, `created_at`) VALUES (2, 'twilio', '', '678668', '', '', '5678687', NULL, NULL, '56677878', 'disabled', '2024-10-14 11:19:29');


#
# TABLE STRUCTURE FOR: source
#

DROP TABLE IF EXISTS `source`;

CREATE TABLE `source` (
  `id` int NOT NULL AUTO_INCREMENT,
  `source` varchar(100) NOT NULL,
  `description` mediumtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_source` (`source`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `source` (`id`, `source`, `description`, `created_at`) VALUES (1, 'Staff', '', '2024-09-30 07:42:37');
INSERT INTO `source` (`id`, `source`, `description`, `created_at`) VALUES (2, 'offline', '', '2024-10-07 11:29:19');
INSERT INTO `source` (`id`, `source`, `description`, `created_at`) VALUES (3, 'Patient', '', '2024-10-10 12:04:05');


#
# TABLE STRUCTURE FOR: specialist
#

DROP TABLE IF EXISTS `specialist`;

CREATE TABLE `specialist` (
  `id` int NOT NULL AUTO_INCREMENT,
  `specialist_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_specialist_name` (`specialist_name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (1, 'Psychiatrist', 'yes', '2024-09-26 07:16:36');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (2, 'Radiologist', 'yes', '2024-09-26 07:16:47');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (3, 'Cardiologist', 'yes', '2024-09-26 07:16:59');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (4, 'Surgeon', 'yes', '2024-09-26 07:17:22');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (5, 'Darmetologist', 'yes', '2024-10-07 12:10:38');
INSERT INTO `specialist` (`id`, `specialist_name`, `is_active`, `created_at`) VALUES (6, 'Pathologist', 'yes', '2024-10-11 10:28:31');


#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(200) DEFAULT NULL,
  `lang_id` int NOT NULL,
  `department_id` int DEFAULT NULL,
  `staff_designation_id` int DEFAULT NULL,
  `specialist` varchar(200) NOT NULL,
  `qualification` varchar(200) NOT NULL,
  `work_exp` varchar(200) NOT NULL,
  `specialization` varchar(200) NOT NULL,
  `name` varchar(200) NOT NULL,
  `surname` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `emergency_contact_no` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `dob` date DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `date_of_joining` date DEFAULT NULL,
  `date_of_leaving` date DEFAULT NULL,
  `local_address` varchar(300) NOT NULL,
  `permanent_address` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `image` varchar(200) NOT NULL,
  `password` varchar(250) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `blood_group` varchar(100) NOT NULL,
  `account_title` varchar(200) NOT NULL,
  `bank_account_no` varchar(200) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `bank_branch` varchar(100) NOT NULL,
  `payscale` varchar(200) NOT NULL,
  `basic_salary` varchar(200) NOT NULL,
  `epf_no` varchar(200) NOT NULL,
  `contract_type` varchar(100) NOT NULL,
  `shift` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `facebook` varchar(200) NOT NULL,
  `twitter` varchar(200) NOT NULL,
  `linkedin` varchar(200) NOT NULL,
  `instagram` varchar(200) NOT NULL,
  `resume` varchar(200) NOT NULL,
  `joining_letter` varchar(200) NOT NULL,
  `resignation_letter` varchar(200) NOT NULL,
  `other_document_name` varchar(200) NOT NULL,
  `other_document_file` varchar(200) NOT NULL,
  `user_id` int NOT NULL,
  `is_active` int NOT NULL,
  `verification_code` varchar(100) NOT NULL,
  `zoom_api_key` varchar(100) NOT NULL,
  `zoom_api_secret` varchar(100) NOT NULL,
  `pan_number` varchar(30) NOT NULL,
  `identification_number` varchar(30) NOT NULL,
  `local_identification_number` varchar(30) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_id` (`employee_id`),
  KEY `staff_designation_id` (`staff_designation_id`),
  KEY `department_id` (`department_id`),
  KEY `index_name` (`name`),
  KEY `index_surname` (`surname`),
  KEY `index_father_name` (`father_name`),
  KEY `index_mother_name` (`mother_name`),
  KEY `index_contact_no` (`contact_no`),
  KEY `index_emergency_contact_no` (`emergency_contact_no`),
  KEY `index_email` (`email`),
  KEY `index_dob` (`dob`),
  KEY `index_marital_status` (`marital_status`),
  KEY `index_date_of_joining` (`date_of_joining`),
  KEY `index_date_of_leaving` (`date_of_leaving`),
  KEY `index_gender` (`gender`),
  KEY `index_blood_group` (`blood_group`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (1, '9001', 4, NULL, NULL, '', '', '', '', 'Super Admin', '', '', '', '', '', 'superadmin@gmail.com', NULL, '', NULL, NULL, '', '', '', '', '$2y$10$WdcU4VHKm44BZgHk53QkQuOFi5o0/4n7SS7SGQuqKkPU831ZJalNG', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, '', '', '', '', '', '', '2024-09-25 06:08:24');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (2, '9002', 0, 1, 3, '4', '', '4', '', 'Ajay', 'Verma', 'Mahesh', 'Manu', '', '', 'ajay@gmail.com', '1989-01-02', 'Married', '2017-09-19', NULL, '', '', '', '2.jpg', '$2y$10$1ZPcRPdxovnFeBzDPBcIv.yjUn6h6ty7ZQ2rsvpBcoB8HTKdiWU7u', 'Male', 'B+', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-09-26 07:28:19');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (3, '9006', 0, 3, 4, '3', '', '5', '', 'David', 'martin', 'william', 'Oliva', '', '', 'david@gmail.com', '2015-11-10', 'Married', NULL, NULL, '', '', '', '3.png', '$2y$10$lR7cgsZYLRyOOrftQ/tqneLs1VNL98ue2w0TvJsK0LawPC90m57Be', 'Male', 'O+', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-09-26 07:29:52');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (4, '9003', 0, 2, 5, '', 'bsc nursing', '5', '', 'RASHI', '', 'RAM', '', '9826244698', '', 'RASHI@gmail.com', '1987-04-22', 'Married', '2020-09-03', NULL, '', '', '', '', '$2y$10$g25NDdxgtohBiOy6NlbVP.XjUB5IAvdx3vbL9CJUT8T4stUZA6qw.', 'Female', 'O+', '', '', '', '', '', '', '15000', '', 'permanent', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-09-28 09:50:44');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (5, '9007', 0, 4, 0, '3', '', '', '', 'Kalvin', 'Martin', 'jarry', 'maria', '', '', 'kalvin@gmail.com', '1988-12-25', 'Married', NULL, NULL, '', '', '', '', '$2y$10$MOo4/XKUCK9V3ZohjJ4heO1C2829F9qzFdm/Yp78r70SVS0Bg/PG2', 'Male', 'O+', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-09-30 04:50:17');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (6, '90010', 0, 0, 6, '', '', '', '', 'Vinay', 'Mishra', 'Karun mishra', 'Rita Mishra', '', '', 'vinay@gmail.com', '1999-05-10', 'Married', NULL, NULL, '', '', '', '', '$2y$10$/ESxohReJkkWBpEX3rJ7fOUFdx6ifyfr7trMIKc0rphkelhF6ohGi', 'Male', 'O+', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-09-30 07:28:11');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (7, '1000', 0, 4, 1, '1', 'mbbs', '10', '', 'HERRY', 'JONSON', '', '', '3454675654', '', 'harry@gmail.com', '1984-10-09', 'Married', '2000-10-24', NULL, 'noida', '', '', '', '$2y$10$elps4nqIQJzFrTqldh0bqO45znOz3Vdgg9zPPuHV5WApi2SnVz46C', 'Male', 'A+', '', '', '', '', '', '', '40000', '1000', 'permanent', 'morning', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '', '', '', '', '', '', '2024-10-02 11:32:02');
INSERT INTO `staff` (`id`, `employee_id`, `lang_id`, `department_id`, `staff_designation_id`, `specialist`, `qualification`, `work_exp`, `specialization`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `blood_group`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`, `zoom_api_key`, `zoom_api_secret`, `pan_number`, `identification_number`, `local_identification_number`, `created_at`) VALUES (8, '9005', 0, 6, 3, '1', 'MBBS', '10', '', 'Abhay', 'Sharma', 'ajay', 'meena', '', '', 'abhay@gmail.com', '1989-10-15', 'Married', '2015-10-08', NULL, '', '', '', '', '$2y$10$vVr8qArRn/qbjXLwGoKPWOI5ZdrUW3EhYmmQKMFwlN.Nd79.gHMwS', 'Male', 'A+', '', '', '', '', '', '', '30000', '', 'permanent', 'MORNNIG', '', '', '', '', '', '', '', '', '', '', 0, 1, '', '', '', '58768885O', '', '', '2024-10-11 10:18:10');


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `staff_id` int DEFAULT NULL,
  `staff_attendance_type_id` int DEFAULT NULL,
  `biometric_attendence` int DEFAULT '0',
  `qrcode_attendance` int NOT NULL DEFAULT '0',
  `biometric_device_data` text,
  `user_agent` varchar(255) DEFAULT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` int NOT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `staff_attendance_type_id` (`staff_attendance_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (1, '2024-09-26', 2, 3, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-26 12:47:15', '2024-09-26 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (2, '2024-09-26', 3, 3, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-26 12:47:15', '2024-09-26 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (3, '2024-09-27', 2, 1, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-27 00:00:00', NULL);
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (4, '2024-09-28', 2, 1, 0, 1, '{\"uid\":\"\",\"user_id\":\"\",\"t\":\"\",\"ip\":\"1.22.246.120\",\"serial_number\":\"\",\"country\":\"India\",\"city\":\"Allahabad\",\"region\":\"Uttar Pradesh\",\"latitude\":25.4358011,\"longitude\":81.846311}', 'Desktop | Mac OS X | Chrome 128.0.0.0', '', 0, '09:00:00', '17:30:00', '2024-09-28 11:45:22', '2024-09-28 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (5, '2024-09-28', 3, 4, 0, 1, '{\"uid\":\"\",\"user_id\":\"\",\"t\":\"\",\"ip\":\"152.58.57.96\",\"serial_number\":\"\",\"country\":\"India\",\"city\":\"Bhopal\",\"region\":\"Madhya Pradesh\",\"latitude\":23.2599333,\"longitude\":77.412615}', 'Mobile | Android | Chrome 128.0.0.0', '', 0, NULL, NULL, '2024-09-28 15:24:55', NULL);
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (6, '2024-09-28', 4, 2, 0, 0, NULL, NULL, '', 0, '05:30:00', '17:34:00', '2024-09-28 00:00:00', '2024-09-28 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (7, '2024-09-30', 2, 2, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-30 05:59:42', '2024-09-30 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (8, '2024-09-30', 3, 1, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-30 05:59:43', '2024-09-30 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (9, '2024-09-30', 4, 1, 0, 0, NULL, NULL, '', 0, '09:00:00', '17:34:00', '2024-09-30 05:59:43', '2024-09-30 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (10, '2024-09-30', 5, 1, 0, 0, NULL, NULL, '', 0, '00:00:00', '00:00:00', '2024-09-30 05:59:43', '2024-09-30 00:00:00');
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (11, '2024-09-30', 1, 1, 0, 1, '{\"uid\":\"\",\"user_id\":\"\",\"t\":\"\",\"ip\":\"152.58.57.96\",\"serial_number\":\"\",\"country\":\"India\",\"city\":\"Bhopal\",\"region\":\"Madhya Pradesh\",\"latitude\":23.2599333,\"longitude\":77.412615}', 'Mobile | Android | Chrome 128.0.0.0', '', 0, NULL, NULL, '2024-09-30 12:56:42', NULL);
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `updated_at`) VALUES (12, '2024-09-30', 6, 4, 0, 1, '{\"uid\":\"\",\"user_id\":\"\",\"t\":\"\",\"ip\":\"152.58.57.96\",\"serial_number\":\"\",\"country\":\"India\",\"city\":\"Bhopal\",\"region\":\"Madhya Pradesh\",\"latitude\":23.2599333,\"longitude\":77.412615}', 'Mobile | Android | Chrome 128.0.0.0', '', 0, NULL, NULL, '2024-09-30 12:58:37', NULL);
INSERT INTO `staff_attendance` (`id`, `date`, `staff_id`, `staff_attendance_type_id`, `biometric_attendence`, `qrcode_attendance`, `biometric_device_data`, `user_agent`, `remark`, `is_active`, `in_time`, `out_time`, `created_at`, `u